/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.ConfigSQLExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.elasticsearch.client.BlockedTaskRejectedExecutionHandler;
import org.frameworkset.elasticsearch.client.Context;
import org.frameworkset.elasticsearch.client.DB2ESExportResultHandler;
import org.frameworkset.elasticsearch.client.DB2ESImportBuilder;
import org.frameworkset.elasticsearch.client.DBConfig;
import org.frameworkset.elasticsearch.client.DBESThread;
import org.frameworkset.elasticsearch.client.DataRefactor;
import org.frameworkset.elasticsearch.client.DefaultEsIdGenerator;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.EsIdGenerator;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.IndexPattern;
import org.frameworkset.elasticsearch.client.schedule.CallInterceptor;
import org.frameworkset.elasticsearch.client.schedule.ImportIncreamentConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleConfig;
import org.frameworkset.elasticsearch.client.schedule.ScheduleService;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.util.ESJDBCResultSet;
import org.frameworkset.persitent.util.JDBCResultSet;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESJDBC
extends JDBCResultSet
implements ESJDBCResultSet {
    private static Logger logger = LoggerFactory.getLogger(ESJDBC.class);
    private ScheduleService scheduleService;
    private String indexType;
    private ErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;
    public static EsIdGenerator DEFAULT_EsIdGenerator = new DefaultEsIdGenerator();
    private EsIdGenerator esIdGenerator = DEFAULT_EsIdGenerator;
    private DBConfig dbConfig;
    private ExecutorService blockedExecutor;
    protected boolean pagine;
    private boolean printTaskLog = false;
    private List<CallInterceptor> callInterceptors;
    private DB2ESExportResultHandler exportResultHandler;
    private DB2ESImportBuilder importBuilder;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private String esIdField;
    private String esParentIdField;
    private String esParentIdValue;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private Object esVersionValue;
    private String esVersionType;
    private Boolean useJavaName;
    private Boolean useLowcase;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private DateFormat format;
    private Map<String, FieldMeta> fieldMetaMap;
    private List<FieldMeta> fieldValues;
    private DataRefactor dataRefactor;
    private String sql;
    private String sqlFilepath;
    private String sqlName;
    private ConfigSQLExecutor executor;
    private String refreshOption;
    private int batchSize = 1000;
    private Integer scheduleBatchSize;
    private String index;
    private IndexPattern indexPattern;
    private AtomicInteger rejectCounts = new AtomicInteger();
    private boolean asyn;
    private boolean continueOnError = true;
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ScheduleConfig scheduleConfig;
    private ImportIncreamentConfig importIncreamentConfig;

    public boolean isPagine() {
        return this.pagine;
    }

    public void setPagine(boolean pagine) {
        this.pagine = pagine;
    }

    public void setForceStop() {
        this.forceStop = true;
    }

    public ErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    public void setErrorWrapper(ErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public Boolean getUseLowcase() {
        return this.useLowcase;
    }

    public void setUseLowcase(Boolean useLowcase) {
        this.useLowcase = useLowcase;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public void setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public void setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public void setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public void setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public void setRoutingField(String routingField) {
        this.routingField = routingField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public void setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public void setEsIdField(String esIdField) {
        this.esIdField = esIdField;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public void setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public void setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public void setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public void setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
    }

    public DateFormateMeta getDateFormateMeta() {
        return DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            DateFormateMeta dateFormateMeta = this.getDateFormateMeta();
            if (dateFormateMeta == null) {
                dateFormateMeta = SerialUtil.getDateFormateMeta();
            }
            this.format = dateFormateMeta.toDateFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public void destroy() {
        this.format = null;
        if (this.blockedExecutor != null) {
            this.blockedExecutor.shutdown();
        }
    }

    public void setFieldMetaMap(Map<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    public FieldMeta getMappingName(String colName) {
        if (this.fieldMetaMap != null) {
            return this.fieldMetaMap.get(colName.toLowerCase());
        }
        return null;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService buildThreadPool() {
        if (this.blockedExecutor != null) {
            return this.blockedExecutor;
        }
        ESJDBC eSJDBC = this;
        synchronized (eSJDBC) {
            if (this.blockedExecutor == null) {
                this.blockedExecutor = new ThreadPoolExecutor(this.getThreadCount(), this.getThreadCount(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.getQueue()), new ThreadFactory(){
                    private AtomicInteger threadCount = new AtomicInteger(0);

                    @Override
                    public Thread newThread(Runnable r) {
                        int num = this.threadCount.incrementAndGet();
                        return new DBESThread(r, num);
                    }
                }, new BlockedTaskRejectedExecutionHandler(this.rejectCounts));
            }
        }
        return this.blockedExecutor;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List<FieldMeta> fieldValues) {
        this.fieldValues = fieldValues;
    }

    public DataRefactor getDataRefactor() {
        return this.dataRefactor;
    }

    public void setDataRefactor(DataRefactor dataRefactor) {
        this.dataRefactor = dataRefactor;
    }

    public Object getValue(int i, String colName) throws Exception {
        Object value = this.resultSet.getObject(i + 1);
        return value;
    }

    public Object getValue(String colName) throws Exception {
        if (colName == null) {
            return null;
        }
        Object value = this.resultSet.getObject(colName);
        return value;
    }

    public void refactorData(Context context) throws Exception {
        if (this.dataRefactor != null) {
            this.dataRefactor.refactor(context);
        }
    }

    public DB2ESImportBuilder getImportBuilder() {
        return this.importBuilder;
    }

    public void setImportBuilder(DB2ESImportBuilder importBuilder) {
        this.importBuilder = importBuilder;
    }

    public ESJDBC addFieldValue(String fieldName, Object value) {
        this.importBuilder.addFieldValue(fieldName, value);
        return this;
    }

    public ESJDBC addFieldValue(String fieldName, String dateFormat, Object value) {
        this.importBuilder.addFieldValue(fieldName, dateFormat, value);
        return this;
    }

    public ESJDBC addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        this.importBuilder.addFieldValue(fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName);
        return this;
    }

    public ESJDBC addIgnoreFieldMapping(String dbColumnName) {
        this.importBuilder.addIgnoreFieldMapping(dbColumnName);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName, dateFormat);
        return this;
    }

    public ESJDBC addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.importBuilder.addFieldMapping(dbColumnName, esFieldName, dateFormat, locale, timeZone);
        return this;
    }

    public String getEsParentIdValue() {
        return this.esParentIdValue;
    }

    public void setEsParentIdValue(String esParentIdValue) {
        this.esParentIdValue = esParentIdValue;
    }

    public Object getEsVersionValue() {
        return this.esVersionValue;
    }

    public void setEsVersionValue(Object esVersionValue) {
        this.esVersionValue = esVersionValue;
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public void setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    public void setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
    }

    public ScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    public void setScheduleConfig(ScheduleConfig scheduleConfig) {
        this.scheduleConfig = scheduleConfig;
    }

    public ImportIncreamentConfig getImportIncreamentConfig() {
        return this.importIncreamentConfig;
    }

    public String getLastValueStoreTableName() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStoreTableName() : null;
    }

    public String getLastValueStorePath() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueStorePath() : null;
    }

    public String getDateLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getDateLastValueColumn() : null;
    }

    public String getNumberLastValueColumn() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getNumberLastValueColumn() : null;
    }

    public Integer getLastValueType() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValueType() : null;
    }

    public void setImportIncreamentConfig(ImportIncreamentConfig importIncreamentConfig) {
        this.importIncreamentConfig = importIncreamentConfig;
    }

    public boolean isFromFirst() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.isFromFirst() : false;
    }

    public Long getConfigLastValue() {
        return this.importIncreamentConfig != null ? this.importIncreamentConfig.getLastValue() : null;
    }

    public String getSqlFilepath() {
        return this.sqlFilepath;
    }

    public void setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
    }

    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    public Integer getScheduleBatchSize() {
        return this.scheduleBatchSize;
    }

    public void setScheduleBatchSize(Integer scheduleBatchSize) {
        this.scheduleBatchSize = scheduleBatchSize;
    }

    public Object getLastValue() throws Exception {
        if (this.scheduleService != null) {
            if (this.scheduleService.getLastValueClumnName() == null) {
                return null;
            }
            return this.getValue(this.scheduleService.getLastValueClumnName());
        }
        return null;
    }

    public void flushLastValue(Object lastValue) {
        if (this.scheduleService != null && lastValue != null) {
            this.scheduleService.flushLastValue(lastValue);
        }
    }

    public void stop() {
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
    }

    public List<CallInterceptor> getCallInterceptors() {
        return this.callInterceptors;
    }

    public void setCallInterceptors(List<CallInterceptor> callInterceptors) {
        this.callInterceptors = callInterceptors;
    }

    public boolean isPrintTaskLog() {
        return this.printTaskLog;
    }

    public void setPrintTaskLog(boolean printTaskLog) {
        this.printTaskLog = printTaskLog;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlName) {
        this.sqlName = sqlName;
    }

    public ConfigSQLExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ConfigSQLExecutor executor) {
        this.executor = executor;
    }

    public EsIdGenerator getEsIdGenerator() {
        return this.esIdGenerator;
    }

    public void setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
        }
    }

    public IndexPattern getIndexPattern() {
        return this.indexPattern;
    }

    public void setIndexPattern(IndexPattern indexPattern) {
        this.indexPattern = indexPattern;
    }

    public String buildIndexName() {
        if (this.indexPattern == null) {
            return this.index;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.indexPattern.getDateFormat());
        String date = dateFormat.format(new Date());
        StringBuilder builder = new StringBuilder();
        builder.append(this.indexPattern.getIndexPrefix()).append(date);
        if (this.indexPattern.getIndexEnd() != null) {
            builder.append(this.indexPattern.getIndexEnd());
        }
        return builder.toString();
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public DB2ESExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public void setExportResultHandler(DB2ESExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }

    public int getMaxRetry() {
        if (this.exportResultHandler != null) {
            return this.exportResultHandler.getMaxRetry();
        }
        return -1;
    }
}

