/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.ImportCount;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.frameworkset.elasticsearch.client.db2es.TaskCommandImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCall
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TaskCall.class);
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private ErrorWrapper errorWrapper;
    private int taskNo;
    private ImportCount totalCount;
    private boolean printTaskLog;
    private int currentSize;

    public TaskCall(String refreshOption, String datas, ErrorWrapper errorWrapper, int taskNo, ImportCount totalCount, int currentSize, boolean printTaskLog) {
        this.refreshOption = refreshOption;
        this.clientInterface = errorWrapper.getClientInterface();
        this.datas = datas;
        this.errorWrapper = errorWrapper;
        this.taskNo = taskNo;
        this.currentSize = currentSize;
        this.totalCount = totalCount;
        this.printTaskLog = printTaskLog;
    }

    public static String call(String refreshOption, ClientInterface clientInterface, String datas, ESJDBC esjdbc) {
        TaskCommandImpl taskCommand = new TaskCommandImpl();
        taskCommand.setClientInterface(clientInterface);
        taskCommand.setRefreshOption(refreshOption);
        taskCommand.setDatas(datas);
        taskCommand.setEsjdbc(esjdbc);
        try {
            String data = taskCommand.execute();
            if (esjdbc.getExportResultHandler() != null) {
                esjdbc.getExportResultHandler().handleResult(taskCommand, data);
            }
            return data;
        }
        catch (ElasticSearchException e) {
            esjdbc.getExportResultHandler().handleException(taskCommand, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            esjdbc.getExportResultHandler().handleException(taskCommand, e);
            throw new ElasticSearchException((Throwable)e);
        }
    }

    @Override
    public void run() {
        long totalSize;
        StringBuilder info;
        long start;
        block9: {
            if (!this.errorWrapper.assertCondition()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Task[" + this.taskNo + "] Assert Execute Condition Failed, Ignore");
                }
                return;
            }
            start = System.currentTimeMillis();
            info = null;
            if (this.printTaskLog) {
                info = new StringBuilder();
            }
            totalSize = 0L;
            try {
                if (this.printTaskLog) {
                    info.append("Task[").append(this.taskNo).append("] starting ......");
                    logger.info(info.toString());
                }
                TaskCall.call(this.refreshOption, this.clientInterface, this.datas, this.errorWrapper.getESJDBC());
                totalSize = this.totalCount.increamentTotalCount(this.currentSize);
            }
            catch (Exception e) {
                this.errorWrapper.setError(e);
                if (this.printTaskLog) {
                    long end = System.currentTimeMillis();
                    info.setLength(0);
                    info.append("Task[").append(this.taskNo).append("] failed,take time:").append(end - start).append("ms");
                    logger.info(info.toString());
                }
                if (!this.errorWrapper.getESJDBC().isContinueOnError()) {
                    throw new TaskFailedException("Task[" + this.taskNo + "] Execute Failed", e);
                }
                if (!logger.isErrorEnabled()) break block9;
                logger.error("Task[" + this.taskNo + "] Execute Failed,but continue On Error!", (Throwable)e);
            }
        }
        if (this.printTaskLog) {
            long end = System.currentTimeMillis();
            info.setLength(0);
            info.append("Task[").append(this.taskNo).append("] finish,import ").append(this.currentSize).append(" records,Total import ").append(totalSize).append(" records,Take time:").append(end - start).append("ms");
            logger.debug(info.toString());
        }
    }
}

