/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.ConfigSQLExecutor;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.DBConfig;
import org.frameworkset.elasticsearch.client.ExportResultHandler;
import org.frameworkset.elasticsearch.client.estodb.ESExporterScrollHandler;
import org.frameworkset.elasticsearch.client.estodb.ExportCount;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ES2DB {
    private int batchSize = 5000;
    private Integer insertBatchSize;
    private String sql;
    private String queryUrl;
    private String dslName;
    private String sqlName;
    private String dsl2ndSqlFile;
    private String scrollLiveTime;
    private BatchHandler<Map> batchHandler;
    private DBConfig dbConfig;
    private ConfigSQLExecutor configSQLExecutor;
    private ExportCount exportCount;
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private boolean asyn;
    private boolean sliceQuery;
    private int sliceSize;
    private boolean continueOnError = true;
    private ExportResultHandler exportResultHandler;
    private static Logger logger = LoggerFactory.getLogger(ES2DB.class);
    private Map params;

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getDslName() {
        return this.dslName;
    }

    public void setDslName(String dslName) {
        this.dslName = dslName;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlName) {
        this.sqlName = sqlName;
    }

    public String getDsl2ndSqlFile() {
        return this.dsl2ndSqlFile;
    }

    public void setDsl2ndSqlFile(String dsl2ndSqlFile) {
        this.dsl2ndSqlFile = dsl2ndSqlFile;
    }

    public String getScrollLiveTime() {
        return this.scrollLiveTime;
    }

    public void setScrollLiveTime(String scrollLiveTime) {
        this.scrollLiveTime = scrollLiveTime;
    }

    public BatchHandler getBatchHandler() {
        return this.batchHandler;
    }

    public void setBatchHandler(BatchHandler batchHandler) {
        this.batchHandler = batchHandler;
    }

    public void exportData2DB() {
        Map params = this.getParams() != null ? this.getParams() : new HashMap();
        params.put("size", this.getBatchSize());
        if (this.sliceQuery) {
            params.put("sliceMax", this.sliceSize);
        }
        int insertBatchSize = this.insertBatchSize == null ? this.getBatchSize() : this.insertBatchSize.intValue();
        this.configSQLExecutor = this.getSql() == null ? new ConfigSQLExecutor(this.getDsl2ndSqlFile()) : null;
        this.exportCount = new ExportCount();
        ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.getDsl2ndSqlFile());
        ESExporterScrollHandler esExporterScrollHandler = new ESExporterScrollHandler(this);
        ESDatas response = null;
        response = !this.sliceQuery ? (!this.isParallel() ? clientUtil.scroll(this.getQueryUrl(), this.getDslName(), this.getScrollLiveTime(), params, Map.class, esExporterScrollHandler) : clientUtil.scrollParallel(this.getQueryUrl(), this.getDslName(), this.getScrollLiveTime(), params, Map.class, esExporterScrollHandler)) : clientUtil.scrollSliceParallel(this.getQueryUrl(), this.getDslName(), params, this.getScrollLiveTime(), Map.class, esExporterScrollHandler);
        if (logger.isInfoEnabled()) {
            if (response != null) {
                logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isAsyn() {
        return this.asyn;
    }

    public void setAsyn(boolean asyn) {
        this.asyn = asyn;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public Integer getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public void setInsertBatchSize(Integer insertBatchSize) {
        this.insertBatchSize = insertBatchSize;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public boolean isSliceQuery() {
        return this.sliceQuery;
    }

    public void setSliceQuery(boolean sliceQuery) {
        this.sliceQuery = sliceQuery;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public void setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
    }

    public ConfigSQLExecutor getConfigSQLExecutor() {
        return this.configSQLExecutor;
    }

    public ExportCount getExportCount() {
        return this.exportCount;
    }

    public ExportResultHandler getExportResultHandler() {
        return this.exportResultHandler;
    }

    public void setExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = exportResultHandler;
    }
}

