/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.es;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.tran.BaseDataTranPlugin;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.BaseESExporterScrollHandler;
import org.frameworkset.tran.es.ES2TranResultSet;
import org.frameworkset.tran.es.input.es.ES2ESContext;
import org.frameworkset.tran.es.input.es.ES2ESExporterScrollHandler;
import org.frameworkset.tran.es.input.es.ES2ESOutPutDataTran;

public class ES2ESDataTranPlugin
extends BaseDataTranPlugin
implements DataTranPlugin {
    private ES2ESContext es2esContext;

    @Override
    protected void init(ImportContext importContext) {
        super.init(importContext);
        this.es2esContext = (ES2ESContext)((Object)importContext);
    }

    public ES2ESDataTranPlugin(ImportContext importContext) {
        super(importContext);
    }

    @Override
    public void beforeInit() {
        this.initES(this.importContext.getApplicationPropertiesFile());
        this.initOtherDSes(this.importContext.getConfigs());
    }

    @Override
    public void afterInit() {
    }

    @Override
    public void initStatusTableId() {
        if (this.isIncreamentImport() && this.es2esContext.getDslFile() != null && !this.es2esContext.getDslFile().equals("")) {
            try {
                ClientInterface clientInterface = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.es2esContext.getDslFile());
                ESInfo esInfo = clientInterface.getESInfo(this.es2esContext.getDslName());
                this.importContext.setStatusTableId(esInfo.getTemplate().hashCode());
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    private void commonImportData(BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2esContext.getParams() != null ? this.es2esContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2esContext.isSliceQuery()) {
            params.put("sliceMax", this.es2esContext.getSliceSize());
        }
        this.exportESData(esExporterScrollHandler, params);
    }

    private void exportESData(BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler, Map params) {
        ClientInterface clientUtil = ElasticSearchHelper.getConfigRestClientUtil((String)this.importContext.getSourceElasticsearch(), (String)this.es2esContext.getDslFile());
        ESDatas response = null;
        response = !this.es2esContext.isSliceQuery() ? clientUtil.scroll(this.es2esContext.getQueryUrl(), this.es2esContext.getDslName(), this.es2esContext.getScrollLiveTime(), params, MetaMap.class, esExporterScrollHandler) : clientUtil.scrollSliceParallel(this.es2esContext.getQueryUrl(), this.es2esContext.getDslName(), params, this.es2esContext.getScrollLiveTime(), MetaMap.class, esExporterScrollHandler);
        if (this.logger.isInfoEnabled()) {
            if (response != null) {
                this.logger.info("Export compoleted and export total {} records.", (Object)response.getTotalSize());
            } else {
                this.logger.info("Export compoleted and export no records or failed.");
            }
        }
    }

    private void increamentImportData(BaseESExporterScrollHandler<MetaMap> esExporterScrollHandler) throws Exception {
        Map<String, Integer> params = this.es2esContext.getParams() != null ? this.es2esContext.getParams() : new HashMap();
        params.put("size", this.importContext.getFetchSize());
        if (this.es2esContext.isSliceQuery()) {
            params.put("sliceMax", this.es2esContext.getSliceSize());
        }
        this.putLastParamValue(params);
        this.exportESData(esExporterScrollHandler, params);
    }

    @Override
    public void doImportData() throws ESDataImportException {
        ES2TranResultSet jdbcResultSet = new ES2TranResultSet(this.importContext);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        final ES2ESOutPutDataTran es2DBDataTran = new ES2ESOutPutDataTran(jdbcResultSet, this.importContext, this.es2esContext.getTargetElasticsearch(), countDownLatch);
        ES2ESExporterScrollHandler<MetaMap> esExporterScrollHandler = new ES2ESExporterScrollHandler<MetaMap>(this.importContext, es2DBDataTran);
        try {
            Thread tranThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    es2DBDataTran.tran();
                }
            }, "Elasticsearch-Elasticsearch-Tran");
            tranThread.start();
            if (!this.isIncreamentImport()) {
                this.commonImportData(esExporterScrollHandler);
            } else {
                this.increamentImportData(esExporterScrollHandler);
            }
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
        finally {
            block13: {
                jdbcResultSet.reachEend();
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    if (!this.logger.isErrorEnabled()) break block13;
                    this.logger.error("", (Throwable)e);
                }
            }
        }
    }
}

