/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.frameworkset.tran.AsynTranResultSet;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.util.TranUtil;

public abstract class AsynBaseTranResultSet
extends LastValue
implements AsynTranResultSet {
    private Record record;
    private List records;
    private int pos = 0;
    private int size;
    private volatile int status;
    private BlockingQueue<Data> queue;
    private boolean reachEnd;

    public AsynBaseTranResultSet(ImportContext importContext) {
        this.queue = new ArrayBlockingQueue<Data>(importContext.getTranDataBufferQueue());
        this.importContext = importContext;
    }

    protected abstract Record buildRecord(Object var1);

    @Override
    public Object getKeys() {
        return this.record.getKeys();
    }

    @Override
    public void appendData(Data datas) {
        try {
            this.queue.put(datas);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getValue(String colName) throws ESDataImportException {
        return this.record.getValue(colName);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws ESDataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.record.getMetaValue(fieldName);
    }

    @Override
    public Date getDateTimeValue(String colName) throws ESDataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue(colName, value, this.importContext);
    }

    @Override
    public void stop() {
        this.status = 1;
    }

    @Override
    public void stopTranOnly() {
        this.status = 2;
    }

    public void reachEend() {
        this.reachEnd = true;
    }

    @Override
    public Boolean next() throws ESDataImportException {
        if (this.status == 1) {
            return false;
        }
        if (this.pos < this.size) {
            this.record = this.buildRecord(this.records.get(this.pos));
            ++this.pos;
            return true;
        }
        try {
            Data datas = this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
            if (this.status == 1) {
                return false;
            }
            if (datas != null) {
                this.records = datas.getDatas();
                int n = this.size = this.records != null ? this.records.size() : 0;
            }
            if (datas == null || this.size == 0) {
                block15: {
                    if (this.status == 2 || this.importContext.getDataTranPlugin().isPluginStopAppending()) {
                        return false;
                    }
                    long pollStartTime = System.currentTimeMillis();
                    while (true) {
                        datas = this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
                        if (this.status == 1) {
                            return false;
                        }
                        if (datas == null) {
                            if (!this.reachEnd) {
                                long interval;
                                if (this.status == 2 || this.importContext.getDataTranPlugin().isPluginStopAppending()) {
                                    return false;
                                }
                                if (this.importContext.getFlushInterval() <= 0L || (interval = System.currentTimeMillis() - pollStartTime) <= this.importContext.getFlushInterval()) continue;
                                return null;
                            }
                            break block15;
                        }
                        this.records = datas.getDatas();
                        int n = this.size = this.records != null ? this.records.size() : 0;
                        if (this.size > 0) break block15;
                        if (this.status == 2 || this.importContext.getDataTranPlugin().isPluginStopAppending()) break;
                    }
                    return false;
                }
                if (datas == null && this.reachEnd) {
                    return false;
                }
            }
            this.pos = 0;
            this.record = this.buildRecord(this.records.get(this.pos));
            ++this.pos;
            if (this.status == 1) {
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public TranMeta getMetaData() {
        return new DefaultTranMetaData(this.record.getKeys());
    }

    @Override
    public Object getRecord() {
        return this.record.getData();
    }

    @Override
    public boolean removed() {
        return this.record.removed();
    }

    @Override
    public boolean reachEOFClosed() {
        return this.record.reachEOFClosed();
    }
}

