/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ContextImpl;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataTranPlugin
implements DataTranPlugin {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean increamentImport = true;
    private ExportCount exportCount;
    protected ImportContext importContext;
    protected ImportContext targetImportContext;
    protected volatile Status currentStatus;
    protected volatile Status firstStatus;
    protected String updateSQL;
    protected String updateStatusSQL;
    protected String insertSQL;
    protected String insertHistorySQL;
    protected String createStatusTableSQL;
    protected String createHistoryStatusTableSQL;
    protected String selectSQL;
    protected String deleteSQL;
    protected String selectAllSQL;
    protected String existSQL;
    protected int lastValueType = 0;
    protected Date initLastDate = null;
    protected String statusDbname;
    protected String statusTableName;
    protected String historyStatusTableName;
    protected String statusStorePath;
    protected String lastValueClumnName;
    protected ScheduleService scheduleService;
    protected volatile int status;
    protected volatile boolean hasTran = false;
    private TranErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;

    @Override
    public ExportCount getExportCount() {
        return this.exportCount;
    }

    public boolean isComplete(Status status) {
        return status.getStatus() == 1;
    }

    @Override
    public Context buildContext(TaskContext taskContext, TranResultSet jdbcResultSet, BatchContext batchContext) {
        return new ContextImpl(taskContext, this.importContext, this.targetImportContext, jdbcResultSet, batchContext);
    }

    @Override
    public String getLastValueVarName() {
        return this.importContext.getLastValueColumn();
    }

    @Override
    public Long getTimeRangeLastValue() {
        return null;
    }

    public BaseDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        this.importContext = importContext;
        this.targetImportContext = targetImportContext;
        this.init(importContext, targetImportContext);
        importContext.setDataTranPlugin(this);
        targetImportContext.setDataTranPlugin(this);
    }

    protected void init(ImportContext importContext, ImportContext targetImportContext) {
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    public ImportContext getTargetImportContext() {
        return this.targetImportContext;
    }

    public void setTargetImportContext(ImportContext targetImportContext) {
        this.targetImportContext = targetImportContext;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && this.logger.isInfoEnabled();
    }

    @Override
    public void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (Exception e) {
                this.logger.error("preCall failed:", (Throwable)e);
            }
        }
    }

    @Override
    public void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                this.logger.error("afterCall failed:", (Throwable)e);
            }
        }
    }

    @Override
    public void throwException(TaskContext taskContext, Exception e) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                this.logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    @Override
    public void importData() throws ESDataImportException {
        if (this.scheduleService == null) {
            long importStartTime = System.currentTimeMillis();
            TaskContext taskContext = new TaskContext(this.importContext, this.targetImportContext);
            try {
                this.preCall(taskContext);
                this.doImportData(taskContext);
                this.afterCall(taskContext);
                long importEndTime = System.currentTimeMillis();
                if (this.isPrintTaskLog()) {
                    this.logger.info("Execute job Take " + (importEndTime - importStartTime) + " ms");
                }
            }
            catch (Exception e) {
                this.throwException(taskContext, e);
                this.logger.error("scheduleImportData failed:", (Throwable)e);
            }
        } else {
            try {
                if (!this.importContext.isExternalTimer()) {
                    this.scheduleService.timeSchedule();
                } else {
                    this.scheduleService.externalTimeSchedule();
                }
            }
            catch (ESDataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    public abstract void beforeInit();

    public abstract void afterInit();

    public abstract void initStatusTableId();

    @Override
    public void init() {
        this.exportCount = new ExportCount();
        this.beforeInit();
        this.initSchedule();
        this.initLastValueClumnName();
        this.initStatusStore();
        this.initDatasource();
        if (this.isIncreamentImport() && this.importContext.getStatusTableId() == null) {
            this.initStatusTableId();
        }
        this.initTableAndStatus();
        this.afterInit();
    }

    @Override
    public boolean isMultiTran() {
        return false;
    }

    @Override
    public String getLastValueClumnName() {
        return this.lastValueClumnName;
    }

    @Override
    public boolean isContinueOnError() {
        return this.importContext.isContinueOnError();
    }

    @Override
    public void setHasTran() {
        this.hasTran = true;
    }

    @Override
    public void setNoTran() {
        this.hasTran = false;
        this.status = 3;
    }

    @Override
    public boolean isPluginStopAppending() {
        return this.status == 2;
    }

    public boolean checkTranToStop() {
        return this.status == 2 || this.status == 3 || !this.hasTran;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void destroy(boolean waitTranStop) {
        this.status = 2;
        if (waitTranStop) {
            while (this.status != 3 && this.hasTran) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
        try {
            if (this.statusDbname != null && !this.statusDbname.equals("")) {
                SQLUtil.stopPool((String)this.statusDbname);
            }
        }
        catch (Exception e) {
            this.logger.error("Stop status db pool[" + this.statusDbname + "] failed:", (Throwable)e);
        }
        this.stopDS(this.importContext.getDbConfig());
        this.stopOtherDSES(this.importContext.getConfigs());
    }

    public Object putLastParamValue(Map params) {
        Object lastValue = this.currentStatus.getLastValue();
        if (this.lastValueType == 0) {
            params.put(this.getLastValueVarName(), lastValue);
        } else {
            if (lastValue instanceof Date) {
                params.put(this.getLastValueVarName(), lastValue);
            } else if (lastValue instanceof Long) {
                params.put(this.getLastValueVarName(), new Date((Long)lastValue));
            } else if (lastValue instanceof Integer) {
                params.put(this.getLastValueVarName(), new Date(((Integer)lastValue).longValue()));
            } else if (lastValue instanceof Short) {
                params.put(this.getLastValueVarName(), new Date(((Short)lastValue).longValue()));
            } else {
                params.put(this.getLastValueVarName(), new Date(((Number)lastValue).longValue()));
            }
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(this.getLastValueVarName() + "__endTime", lastOffsetValue);
            }
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + params);
        }
        return lastValue;
    }

    public Map getParamValue() {
        Object lastValue = this.currentStatus.getLastValue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lastValueType == 0) {
            params.put(this.getLastValueVarName(), lastValue);
        } else {
            if (lastValue instanceof Date) {
                params.put(this.getLastValueVarName(), lastValue);
            } else if (lastValue instanceof Long) {
                params.put(this.getLastValueVarName(), new Date((Long)lastValue));
            } else if (lastValue instanceof Integer) {
                params.put(this.getLastValueVarName(), new Date(((Integer)lastValue).longValue()));
            } else if (lastValue instanceof Short) {
                params.put(this.getLastValueVarName(), new Date(((Short)lastValue).longValue()));
            } else {
                params.put(this.getLastValueVarName(), new Date(((Number)lastValue).longValue()));
            }
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(this.getLastValueVarName() + "__endTime", lastOffsetValue);
            }
        }
        if (this.isPrintTaskLog()) {
            this.logger.info("Current values: " + params);
        }
        return params;
    }

    public void initLastValueClumnName() {
        if (this.lastValueClumnName != null) {
            return;
        }
        if (this.importContext.getLastValueColumn() != null) {
            this.lastValueClumnName = this.importContext.getLastValueColumn();
        } else if (this.getLastValueVarName() != null) {
            this.lastValueClumnName = this.getLastValueVarName();
        }
        if (this.lastValueClumnName == null) {
            this.setIncreamentImport(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus;
        block10: {
            block11: {
                block12: {
                    block13: {
                        currentStatus = new Status();
                        currentStatus.setId(this.importContext.getStatusTableId());
                        currentStatus.setTime(new Date().getTime());
                        if (this.lastValueType != 1) break block11;
                        if (this.importContext.getConfigLastValue() == null) break block12;
                        if (!(this.importContext.getConfigLastValue() instanceof Date)) break block13;
                        currentStatus.setLastValue(this.importContext.getConfigLastValue());
                        break block10;
                    }
                    if (this.importContext.getConfigLastValue() instanceof Long) {
                        currentStatus.setLastValue(new Date((Long)this.importContext.getConfigLastValue()));
                        break block10;
                    } else if (this.importContext.getConfigLastValue() instanceof Integer) {
                        currentStatus.setLastValue(new Date(((Integer)this.importContext.getConfigLastValue()).intValue()));
                        break block10;
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("TIMESTAMP TYPE Last Value Illegal:{}", this.importContext.getConfigLastValue());
                        }
                        throw new ESDataImportException("TIMESTAMP TYPE Last Value Illegal:" + this.importContext.getConfigLastValue());
                    }
                }
                currentStatus.setLastValue(this.initLastDate);
                break block10;
            }
            if (this.importContext.getConfigLastValue() != null) {
                currentStatus.setLastValue(this.importContext.getConfigLastValue());
            } else {
                currentStatus.setLastValue(0L);
            }
        }
        currentStatus.setLastValueType(this.lastValueType);
        if (!update) {
            this.addStatus(currentStatus);
        } else {
            this.updateStatus(currentStatus);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = (Status)currentStatus.clone();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Init LastValue Status: {}", (Object)currentStatus.toString());
        }
    }

    protected void handleCompletedTasks(List<Status> completed, boolean needSyn, long registLiveTime) {
        try {
            long now = System.currentTimeMillis();
            long deletedTime = now - registLiveTime;
            for (Status status : completed) {
                long lastTime;
                File file = new File(status.getFilePath());
                if (file.exists() || (lastTime = status.getTime()) > deletedTime) continue;
                SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertHistorySQL, (Object[])new Object[]{SimpleStringUtil.getUUID(), status.getTime(), status.getLastValue(), status.getLastValueType(), status.getFilePath(), status.getFileId(), status.getStatus()});
                SQLExecutor.deleteWithDBName((String)this.statusDbname, (String)this.deleteSQL, (Object[])new Object[]{status.getId()});
            }
        }
        catch (Exception e) {
            this.logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json(completed), (Throwable)e);
        }
    }

    protected void handleOldedTasks(List<Status> olded) {
        try {
            for (Status status : olded) {
                status.setTime(System.currentTimeMillis());
                status.setStatus(1);
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateStatusSQL, (Object[])new Object[]{status.getStatus(), status.getTime(), status.getId()});
            }
        }
        catch (Exception e) {
            this.logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json(olded), (Throwable)e);
        }
    }

    protected void loadCurrentStatus() {
        try {
            this.currentStatus = (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectSQL, (Object[])new Object[]{this.importContext.getStatusTableId()});
            if (this.currentStatus == null) {
                this.initLastValueStatus(false);
            } else if (this.importContext.isFromFirst()) {
                this.initLastValueStatus(true);
            } else if (this.currentStatus.getLastValueType() != this.lastValueType) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("The config lastValueType is {} but from currentStatus lastValueType is {},and use the config lastValueType to releace currentStatus lastValueType.", (Object)this.lastValueType, (Object)this.currentStatus.getLastValueType());
                }
                this.initLastValueStatus(true);
            } else {
                if (this.currentStatus.getLastValueType() == 1) {
                    Object lastValue = this.currentStatus.getLastValue();
                    if (lastValue instanceof Long) {
                        this.currentStatus.setLastValue(new Date((Long)lastValue));
                    } else if (lastValue instanceof Integer) {
                        this.currentStatus.setLastValue(new Date(((Integer)lastValue).longValue()));
                    } else {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("initTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:{},value type is {}", lastValue, (Object)lastValue.getClass().getName());
                        }
                        throw new ESDataImportException("InitTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:" + lastValue + ",value type is " + lastValue.getClass().getName());
                    }
                }
                this.firstStatus = (Status)this.currentStatus.clone();
            }
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    protected void initTableAndStatus() {
        if (this.isIncreamentImport()) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.initLastDate = dateFormat.parse("1970-01-01 00:00:00");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existSQL, (Object[])new Object[0]);
            }
            catch (Exception e) {
                String tsql = this.createStatusTableSQL;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.statusTableName, this.statusTableName, tsql});
                }
                try {
                    SQLExecutor.updateWithDBName((String)this.statusDbname, (String)tsql, (Object[])new Object[0]);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.statusTableName + " create success\uff1a" + tsql + ".");
                    }
                }
                catch (Exception e1) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.statusTableName + " create success\uff1a" + tsql + ".", (Throwable)e1);
                    }
                    throw new ESDataImportException(e1);
                }
                try {
                    SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.createHistoryStatusTableSQL, (Object[])new Object[0]);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.historyStatusTableName + " create success\uff1a" + this.createHistoryStatusTableSQL + ".");
                    }
                }
                catch (Exception e1) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("table " + this.historyStatusTableName + " create success\uff1a" + this.createHistoryStatusTableSQL + ".", (Throwable)e1);
                    }
                    throw new ESDataImportException(e1);
                }
            }
            this.loadCurrentStatus();
        } else {
            try {
                Status currentStatus = new Status();
                currentStatus.setId(this.importContext.getStatusTableId());
                currentStatus.setTime(new Date().getTime());
                this.firstStatus = (Status)currentStatus.clone();
                this.currentStatus = currentStatus;
            }
            catch (Exception e) {
                throw new ESDataImportException(e);
            }
        }
    }

    protected void initStatusStore() {
        if (this.isIncreamentImport()) {
            this.statusTableName = this.importContext.getLastValueStoreTableName();
            if (this.statusTableName == null) {
                this.statusTableName = "increament_tab";
            }
            this.statusStorePath = this.importContext.getLastValueStorePath() == null || this.importContext.getLastValueStorePath().equals("") ? "StatusStoreDB" : this.importContext.getLastValueStorePath();
            this.historyStatusTableName = this.statusTableName + "_his";
        }
    }

    protected void initDatasource() {
        if (this.isIncreamentImport()) {
            if (this.importContext.getStatusDbConfig() == null) {
                this.statusDbname = "_status_datasource";
                String dbJNDIName = "_status_datasource_jndi";
                try {
                    this.createStatusTableSQL = "create table " + this.statusTableName + " (ID number(10)," + "lasttime number(10)," + "lastvalue number(10)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "PRIMARY KEY (ID))";
                    this.createHistoryStatusTableSQL = "create table " + this.historyStatusTableName + " (ID varchar(100)," + "lasttime number(10)," + "lastvalue number(10)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "fileId varchar(500) ," + "statusId number(10) ," + "PRIMARY KEY (ID))";
                    File dbpath = new File(this.statusStorePath);
                    this.logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
                    DBConf tempConf = new DBConf();
                    tempConf.setPoolname(this.statusDbname);
                    tempConf.setDriver("org.sqlite.JDBC");
                    tempConf.setJdbcurl("jdbc:sqlite://" + dbpath.getCanonicalPath());
                    tempConf.setUsername("root");
                    tempConf.setPassword("root");
                    tempConf.setReadOnly((String)null);
                    tempConf.setTxIsolationLevel((String)null);
                    tempConf.setValidationQuery("select 1");
                    tempConf.setJndiName(dbJNDIName);
                    tempConf.setInitialConnections(10);
                    tempConf.setMinimumSize(10);
                    tempConf.setMaximumSize(20);
                    tempConf.setUsepool(true);
                    tempConf.setExternal(false);
                    tempConf.setExternaljndiName((String)null);
                    tempConf.setShowsql(false);
                    tempConf.setEncryptdbinfo(false);
                    tempConf.setQueryfetchsize(null);
                    SQLUtil.startPoolWithDBConf((DBConf)tempConf);
                }
                catch (Exception e) {
                    throw new ESDataImportException(e);
                }
            }
            DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
            this.statusDbname = this.importContext.getStatusDbConfig().getDbName();
            if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                this.statusDbname = "_status_datasource";
            }
            if (statusDBConfig.getDbDriver() != null && !statusDBConfig.getDbDriver().trim().equals("")) {
                String dbJNDIName = this.statusDbname + "_jndi";
                try {
                    DBConf tempConf = new DBConf();
                    tempConf.setPoolname(this.statusDbname);
                    tempConf.setDriver(statusDBConfig.getDbDriver());
                    tempConf.setJdbcurl(statusDBConfig.getDbUrl());
                    tempConf.setUsername(statusDBConfig.getDbUser());
                    tempConf.setPassword(statusDBConfig.getDbPassword());
                    tempConf.setReadOnly((String)null);
                    tempConf.setTxIsolationLevel((String)null);
                    tempConf.setValidationQuery(statusDBConfig.getValidateSQL());
                    tempConf.setJndiName(dbJNDIName);
                    tempConf.setInitialConnections(10);
                    tempConf.setMinimumSize(10);
                    tempConf.setMaximumSize(20);
                    tempConf.setUsepool(true);
                    tempConf.setExternal(false);
                    tempConf.setExternaljndiName((String)null);
                    tempConf.setShowsql(false);
                    tempConf.setEncryptdbinfo(false);
                    tempConf.setQueryfetchsize(null);
                    tempConf.setDbInfoEncryptClass(statusDBConfig.getDbInfoEncryptClass());
                    SQLUtil.startPoolWithDBConf((DBConf)tempConf);
                }
                catch (Exception e) {
                    throw new ESDataImportException(e);
                }
            }
            this.createStatusTableSQL = statusDBConfig.getStatusTableDML();
            if (this.createStatusTableSQL == null) {
                this.createStatusTableSQL = statusDBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
            }
            this.createHistoryStatusTableSQL = statusDBConfig.getCreateHistoryStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
            this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
            this.createHistoryStatusTableSQL = this.createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
            this.lastValueType = this.importContext.getLastValueType() != null ? this.importContext.getLastValueType() : 0;
            this.importContext.setLastValueType(this.lastValueType);
            this.existSQL = "select 1 from " + this.statusTableName;
            this.selectSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,fileId,status from " + this.statusTableName + " where id=?";
            this.selectAllSQL = "select id,lasttime,lastvalue,lastvaluetype,filePath,fileId,status from " + this.statusTableName;
            this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,lastvaluetype= ? , filePath = ?,fileId = ? ,status = ? where id=?";
            this.updateStatusSQL = "update " + this.statusTableName + " set status = ?, lasttime= ?" + " where id=?";
            this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype,filePath,fileId,status) values(?,?,?,?,?,?,?)";
            this.deleteSQL = "delete from " + this.statusTableName + " where id=?";
            this.insertHistorySQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,lastvaluetype,filePath,fileId,status) values(?,?,?,?,?,?,?)";
        }
    }

    public void setIncreamentImport(boolean increamentImport) {
        this.increamentImport = increamentImport;
    }

    public boolean isIncreamentImport() {
        return this.increamentImport;
    }

    @Override
    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLastValue(Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        if (lastValue != null) {
            Status status = currentStatus;
            synchronized (status) {
                Object oldLastValue = currentStatus.getLastValue();
                if (!this.importContext.needUpdate(oldLastValue, lastValue)) {
                    return;
                }
                long time = System.currentTimeMillis();
                currentStatus.setTime(time);
                currentStatus.setLastValue(lastValue);
                if (reachEOFClosed) {
                    currentStatus.setStatus(1);
                }
                if (this.isIncreamentImport()) {
                    this.storeStatus(currentStatus);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceflushLastValue(Status currentStatus) {
        Status status = currentStatus;
        synchronized (status) {
            currentStatus.setStatus(1);
            currentStatus.setTime(System.currentTimeMillis());
            this.storeStatus(currentStatus);
        }
    }

    public void storeStatus(Status currentStatus) {
        try {
            this.updateStatus(currentStatus);
        }
        catch (ESDataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void addStatus(Status currentStatus) throws ESDataImportException {
        Object lastValue = currentStatus.getLastValue();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        if (this.importContext.isLastValueDateType()) {
            if (lastValue instanceof Date) {
                lastValue = ((Date)lastValue).getTime();
            } else {
                throw new ESDataImportException("AddStatus: \u589e\u91cf\u5b57\u6bb5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0cBut the LastValue is not a Date value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},and real last value to sqlite is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        try {
            SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), lastValue, this.lastValueType, currentStatus.getFilePath(), currentStatus.getFileId(), currentStatus.getStatus()});
        }
        catch (SQLException throwables) {
            throw new ESDataImportException("Add Status failed:" + currentStatus.toString(), throwables);
        }
    }

    public void updateStatus(Status currentStatus) throws Exception {
        Object lastValue = currentStatus.getLastValue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        if (this.importContext.isLastValueDateType()) {
            if (lastValue instanceof Date) {
                lastValue = ((Date)lastValue).getTime();
            } else {
                throw new ESDataImportException("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0cBut the LastValue is not a Date value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UpdateStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},and real last value to sqlite is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
        }
        SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateSQL, (Object[])new Object[]{currentStatus.getTime(), lastValue, this.lastValueType, currentStatus.getFilePath(), currentStatus.getFileId(), currentStatus.getStatus(), currentStatus.getId()});
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public TranErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    @Override
    public void setErrorWrapper(TranErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    @Override
    public void setForceStop() {
        this.forceStop = true;
    }

    @Override
    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    protected void initES(String applicationPropertiesFile) {
        if (SimpleStringUtil.isNotEmpty((String)applicationPropertiesFile)) {
            ElasticSearchBoot.boot((String)applicationPropertiesFile);
        }
        if (this.importContext.getESConfig() != null) {
            ElasticSearchBoot.boot(this.importContext.getESConfig().getConfigs());
        }
    }

    public void initSchedule() {
        if (this.importContext.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.init(this.importContext, this.targetImportContext);
        }
    }

    protected void initDS(DBConfig dbConfig) {
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl())) {
            DBConf temConf = new DBConf();
            temConf.setPoolname(dbConfig.getDbName());
            temConf.setDriver(dbConfig.getDbDriver());
            temConf.setJdbcurl(dbConfig.getDbUrl());
            temConf.setUsername(dbConfig.getDbUser());
            temConf.setPassword(dbConfig.getDbPassword());
            temConf.setReadOnly(null);
            temConf.setTxIsolationLevel(null);
            temConf.setValidationQuery(dbConfig.getValidateSQL());
            temConf.setJndiName(dbConfig.getDbName() + "_jndi");
            temConf.setInitialConnections(dbConfig.getInitSize());
            temConf.setMinimumSize(dbConfig.getMinIdleSize());
            temConf.setMaximumSize(dbConfig.getMaxSize());
            temConf.setUsepool(dbConfig.isUsePool());
            temConf.setExternal(false);
            temConf.setExternaljndiName(null);
            temConf.setShowsql(dbConfig.isShowSql());
            temConf.setEncryptdbinfo(false);
            temConf.setQueryfetchsize(Integer.valueOf(dbConfig.getJdbcFetchSize() == null ? 0 : dbConfig.getJdbcFetchSize()));
            temConf.setDbAdaptor(dbConfig.getDbAdaptor());
            temConf.setDbtype(dbConfig.getDbtype());
            temConf.setColumnLableUpperCase(dbConfig.isColumnLableUpperCase());
            temConf.setDbInfoEncryptClass(dbConfig.getDbInfoEncryptClass());
            SQLManager.startPool((DBConf)temConf);
        }
    }

    protected void initOtherDSes(List<DBConfig> dbConfigs) {
        if (dbConfigs != null && dbConfigs.size() > 0) {
            for (DBConfig dbConfig : dbConfigs) {
                this.initDS(dbConfig);
            }
        }
    }

    protected void stopDS(DBConfig dbConfig) {
        block3: {
            if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl())) {
                try {
                    SQLUtil.stopPool((String)dbConfig.getDbName());
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("SQLUtil.stopPool(" + dbConfig.getDbName() + ") failed:", (Throwable)e);
                }
            }
        }
    }

    protected void stopOtherDSES(List<DBConfig> dbConfigs) {
        if (dbConfigs != null && dbConfigs.size() > 0) {
            for (DBConfig dbConfig : dbConfigs) {
                this.stopDS(dbConfig);
            }
        }
    }
}

