/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ESDataImportException;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStream {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ImportContext importContext;
    protected ImportContext targetImportContext;
    protected BaseImportConfig importConfig;
    private DataTranPlugin dataTranPlugin;
    private boolean inited;
    private Lock lock = new ReentrantLock();
    private String configString;

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
        this.dataTranPlugin.init();
    }

    public void setImportConfig(BaseImportConfig importConfig) {
        this.importConfig = importConfig;
    }

    public void setTargetImportContext(ImportContext targetImportContext) {
        this.targetImportContext = targetImportContext;
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    public ImportContext getTargetImportContext() {
        return this.targetImportContext;
    }

    public void execute() throws ESDataImportException {
        try {
            this.init();
            DataTranPlugin dataTranPlugin = this.importContext.getDataTranPlugin();
            if (dataTranPlugin != null) {
                dataTranPlugin.importData();
            }
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean waitTranStopped) {
        if (this.importContext != null) {
            this.importContext.destroy(waitTranStopped);
            this.importContext = null;
            this.logger.info("DataStream stopped.");
        } else {
            this.logger.info("DataStream has stopped.");
        }
    }

    public String getConfigString() {
        return this.configString;
    }

    public void setConfigString(String configString) {
        this.configString = configString;
    }

    public void init() {
        if (this.inited) {
            this.importContext.resume();
            return;
        }
        if (this.importConfig == null) {
            throw new ESDataImportException("import Config is null.");
        }
        try {
            this.lock.lock();
            this.inited = true;
        }
        catch (Exception e) {
            this.inited = true;
            throw new ESDataImportException(e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

