/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.tran.BlockedTaskRejectedExecutionHandler;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DBESThread;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.ESConfig;
import org.frameworkset.tran.es.ESField;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class BaseImportContext
implements ImportContext {
    protected BaseImportConfig baseImportConfig;
    private DataTranPlugin dataTranPlugin;
    private boolean currentStoped = false;
    private AtomicInteger rejectCounts = new AtomicInteger();
    private ExecutorService blockedExecutor;

    @Override
    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
    }

    @Override
    public String[] getExportColumns() {
        return this.baseImportConfig.getExportColumns();
    }

    @Override
    public boolean useFilePointer() {
        return false;
    }

    public BaseImportContext() {
    }

    @Override
    public Integer increamentEndOffset() {
        return this.baseImportConfig.getIncreamentEndOffset();
    }

    @Override
    public Context buildContext(TaskContext taskContext, TranResultSet jdbcResultSet, BatchContext batchContext) {
        return this.dataTranPlugin.buildContext(taskContext, jdbcResultSet, batchContext);
    }

    @Override
    public Long getTimeRangeLastValue() {
        return this.dataTranPlugin.getTimeRangeLastValue();
    }

    @Override
    public ESConfig getESConfig() {
        return this.baseImportConfig.getESConfig();
    }

    @Override
    public long getFlushInterval() {
        return this.baseImportConfig.getFlushInterval();
    }

    @Override
    public boolean isIgnoreNullValueField() {
        return this.baseImportConfig.isIgnoreNullValueField();
    }

    @Override
    public void setEsIdField(ESField esIdField) {
        this.baseImportConfig.setEsIdField(esIdField);
    }

    @Override
    public void setEsIdField(String esIdField) {
        this.baseImportConfig.setEsIdField(new ESField(false, esIdField));
    }

    @Override
    public boolean isSortLastValue() {
        return this.baseImportConfig.isSortLastValue();
    }

    @Override
    public long getAsynResultPollTimeOut() {
        return this.baseImportConfig.getAsynResultPollTimeOut();
    }

    @Override
    public Integer getFetchSize() {
        return this.baseImportConfig.getFetchSize();
    }

    protected void init(BaseImportConfig baseImportConfig) {
    }

    @Override
    public int getTranDataBufferQueue() {
        return this.baseImportConfig.getTranDataBufferQueue();
    }

    public BaseImportContext(BaseImportConfig baseImportConfig) {
        this.baseImportConfig = baseImportConfig;
        this.init(baseImportConfig);
    }

    @Override
    public ExportCount getExportCount() {
        return this.dataTranPlugin.getExportCount();
    }

    @Override
    public void setStatusTableId(int hashCode) {
        this.baseImportConfig.setStatusTableId(hashCode);
    }

    @Override
    public DBConfig getDbConfig() {
        return this.baseImportConfig.getDbConfig();
    }

    @Override
    public DataRefactor getDataRefactor() {
        return this.baseImportConfig.getDataRefactor();
    }

    @Override
    public String getApplicationPropertiesFile() {
        return this.baseImportConfig.getApplicationPropertiesFile();
    }

    @Override
    public List<DBConfig> getConfigs() {
        return this.baseImportConfig.getConfigs();
    }

    @Override
    public boolean isPrintTaskLog() {
        return this.baseImportConfig.isPrintTaskLog();
    }

    @Override
    public void setDataRefactor(DataRefactor dataRefactor) {
        this.baseImportConfig.setDataRefactor(dataRefactor);
    }

    @Override
    public String getTargetElasticsearch() {
        return this.baseImportConfig.getTargetElasticsearch();
    }

    @Override
    public String getSourceElasticsearch() {
        return this.baseImportConfig.getSourceElasticsearch();
    }

    @Override
    public ClientOptions getClientOptions() {
        return this.baseImportConfig.getClientOptions();
    }

    @Override
    public void destroy(boolean waitTranStop) {
        this.dataTranPlugin.destroy(waitTranStop);
        try {
            if (this.blockedExecutor != null) {
                this.blockedExecutor.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentStoped = true;
    }

    @Override
    public boolean isContinueOnError() {
        return this.baseImportConfig.isContinueOnError();
    }

    @Override
    public boolean assertCondition() {
        return this.dataTranPlugin.assertCondition();
    }

    @Override
    public List<CallInterceptor> getCallInterceptors() {
        return this.baseImportConfig.getCallInterceptors();
    }

    @Override
    public boolean isCurrentStoped() {
        return this.currentStoped;
    }

    @Override
    public void doImportData(TaskContext taskContext) {
        if (this.dataTranPlugin != null) {
            this.dataTranPlugin.doImportData(taskContext);
        }
    }

    @Override
    public ScheduleConfig getScheduleConfig() {
        return this.baseImportConfig.getScheduleConfig();
    }

    @Override
    public Boolean getFixedRate() {
        return this.baseImportConfig.getScheduleConfig().getFixedRate();
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.dataTranPlugin.getScheduleService();
    }

    @Override
    public BaseImportConfig getImportConfig() {
        return this.baseImportConfig;
    }

    @Override
    public int getMaxRetry() {
        return this.baseImportConfig.getMaxRetry();
    }

    @Override
    public boolean isAsyn() {
        return this.baseImportConfig.isAsyn();
    }

    @Override
    public boolean isDebugResponse() {
        return this.baseImportConfig.isDebugResponse();
    }

    @Override
    public boolean isDiscardBulkResponse() {
        return this.baseImportConfig.isDiscardBulkResponse();
    }

    @Override
    public WrapedExportResultHandler getExportResultHandler() {
        return this.baseImportConfig.getExportResultHandler();
    }

    @Override
    public void flushLastValue(Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        Long timeLastValue = this.getTimeRangeLastValue();
        if (timeLastValue != null) {
            lastValue = this.max(lastValue, new Date(timeLastValue));
        }
        this.dataTranPlugin.flushLastValue(lastValue, currentStatus, reachEOFClosed);
    }

    @Override
    public boolean isLastValueDateType() {
        return this.baseImportConfig.isLastValueDateType();
    }

    @Override
    public Integer getLastValueType() {
        return this.baseImportConfig.getLastValueType();
    }

    @Override
    public DBConfig getStatusDbConfig() {
        return this.baseImportConfig.getStatusDbConfig();
    }

    @Override
    public boolean isExternalTimer() {
        return this.baseImportConfig.isExternalTimer();
    }

    @Override
    public String getLastValueColumn() {
        return this.baseImportConfig.getLastValueColumn();
    }

    @Override
    public String getLastValueColumnName() {
        return this.dataTranPlugin.getLastValueClumnName();
    }

    @Override
    public Object getConfigLastValue() {
        return this.baseImportConfig.getConfigLastValue();
    }

    @Override
    public String getLastValueStoreTableName() {
        return this.baseImportConfig.getLastValueStoreTableName();
    }

    @Override
    public String getLastValueStorePath() {
        return this.baseImportConfig.getLastValueStorePath();
    }

    @Override
    public DataTranPlugin getDataTranPlugin() {
        return this.dataTranPlugin;
    }

    @Override
    public boolean needUpdate(Object oldValue, Object newValue) {
        boolean e;
        if (newValue == null) {
            return false;
        }
        if (oldValue == null) {
            return true;
        }
        if (this.getLastValueType() == 1) {
            Date newValueDate = (Date)newValue;
            Date oldValueDate = (Date)oldValue;
            return newValueDate.after(oldValueDate);
        }
        if (oldValue instanceof Integer && newValue instanceof Integer) {
            int e2 = ((Integer)oldValue).compareTo((Integer)newValue);
            return e2 < 0;
        }
        if (oldValue instanceof Long || newValue instanceof Long) {
            boolean e3;
            boolean bl = e3 = ((Number)oldValue).longValue() <= ((Number)newValue).longValue();
            return e3;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            int e4 = ((BigDecimal)oldValue).compareTo((BigDecimal)newValue);
            return e4 < 0;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof Integer) {
            boolean e5;
            boolean bl = e5 = ((BigDecimal)oldValue).longValue() > (long)((Integer)newValue).intValue();
            return !e5;
        }
        if (oldValue instanceof Integer && newValue instanceof BigDecimal) {
            boolean e6;
            boolean bl = e6 = ((BigDecimal)newValue).longValue() > (long)((Integer)oldValue).intValue();
            return e6;
        }
        if (oldValue instanceof Double || newValue instanceof Double) {
            int e7 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            return e7 < 0;
        }
        if (oldValue instanceof Float || newValue instanceof Float) {
            int e8 = Float.compare(((Number)oldValue).floatValue(), ((Number)newValue).floatValue());
            return e8 < 0;
        }
        if (oldValue instanceof BigDecimal || newValue instanceof BigDecimal) {
            int e9 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            return e9 < 0;
        }
        boolean bl = e = ((Number)oldValue).intValue() <= ((Number)newValue).intValue();
        return e;
    }

    @Override
    public Object max(Object oldValue, Object newValue) {
        boolean e;
        if (newValue == null) {
            return oldValue;
        }
        if (oldValue == null) {
            return newValue;
        }
        if (this.getLastValueType() == 1) {
            Date newValueDate = (Date)newValue;
            Date oldValueDate = (Date)oldValue;
            if (newValueDate.after(oldValueDate)) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Integer && newValue instanceof Integer) {
            int e2 = ((Integer)oldValue).compareTo((Integer)newValue);
            if (e2 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Long || newValue instanceof Long) {
            boolean e3;
            boolean bl = e3 = ((Number)oldValue).longValue() <= ((Number)newValue).longValue();
            if (e3) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            int e4 = ((BigDecimal)oldValue).compareTo((BigDecimal)newValue);
            if (e4 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof Integer) {
            boolean e5;
            boolean bl = e5 = ((BigDecimal)oldValue).longValue() > (long)((Integer)newValue).intValue();
            if (!e5) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Integer && newValue instanceof BigDecimal) {
            boolean e6;
            boolean bl = e6 = ((BigDecimal)newValue).longValue() > (long)((Integer)oldValue).intValue();
            if (!e6) {
                return oldValue;
            }
            return newValue;
        }
        if (oldValue instanceof Double || newValue instanceof Double) {
            int e7 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            if (e7 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof Float || newValue instanceof Float) {
            int e8 = Float.compare(((Number)oldValue).floatValue(), ((Number)newValue).floatValue());
            if (e8 < 0) {
                return newValue;
            }
            return oldValue;
        }
        if (oldValue instanceof BigDecimal || newValue instanceof BigDecimal) {
            int e9 = Double.compare(((Number)oldValue).doubleValue(), ((Number)newValue).doubleValue());
            if (e9 < 0) {
                return newValue;
            }
            return oldValue;
        }
        boolean bl = e = ((Number)oldValue).intValue() <= ((Number)newValue).intValue();
        if (e) {
            return newValue;
        }
        return oldValue;
    }

    @Override
    public void setLastValueType(int lastValueType) {
        this.baseImportConfig.setLastValueType(lastValueType);
    }

    @Override
    public int getThreadCount() {
        return this.baseImportConfig.getThreadCount();
    }

    @Override
    public boolean isParallel() {
        return this.baseImportConfig.isParallel();
    }

    @Override
    public int getQueue() {
        return this.baseImportConfig.getQueue();
    }

    @Override
    public ESIndexWrapper getEsIndexWrapper() {
        return this.baseImportConfig.getEsIndexWrapper();
    }

    @Override
    public void setEsIndexWrapper(ESIndexWrapper esIndexWrapper) {
        this.baseImportConfig.setEsIndexWrapper(esIndexWrapper);
    }

    @Override
    public void resume() {
        this.currentStoped = false;
    }

    @Override
    public String getDateFormat() {
        return this.baseImportConfig.getDateFormat();
    }

    @Override
    public String getLocale() {
        return this.baseImportConfig.getLocale();
    }

    @Override
    public String getTimeZone() {
        return this.baseImportConfig.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService buildThreadPool() {
        if (this.blockedExecutor != null) {
            return this.blockedExecutor;
        }
        BaseImportContext baseImportContext = this;
        synchronized (baseImportContext) {
            if (this.blockedExecutor == null) {
                this.blockedExecutor = new ThreadPoolExecutor(this.getThreadCount(), this.getThreadCount(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.getQueue()), new ThreadFactory(){
                    private AtomicInteger threadCount = new AtomicInteger(0);

                    @Override
                    public Thread newThread(Runnable r) {
                        int num = this.threadCount.incrementAndGet();
                        return new DBESThread(r, num);
                    }
                }, new BlockedTaskRejectedExecutionHandler(this.rejectCounts));
            }
        }
        return this.blockedExecutor;
    }

    @Override
    public Integer getStoreBatchSize() {
        if (this.baseImportConfig.getScheduleBatchSize() == null) {
            return this.baseImportConfig.getBatchSize();
        }
        return this.baseImportConfig.getScheduleBatchSize();
    }

    @Override
    public Integer getStatusTableId() {
        return this.baseImportConfig.getStatusTableId();
    }

    @Override
    public boolean isFromFirst() {
        return this.baseImportConfig.isFromFirst();
    }

    @Override
    public void setRefreshOption(String refreshOption) {
        this.baseImportConfig.setRefreshOption(refreshOption);
    }

    @Override
    public String getRefreshOption() {
        ClientOptions clientOptions = this.baseImportConfig.getClientOptions();
        return clientOptions != null ? clientOptions.getRefreshOption() : null;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.baseImportConfig.setBatchSize(batchSize);
    }
}

