/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.db.input.es;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.db.DBExportBuilder;
import org.frameworkset.tran.db.DBImportConfig;
import org.frameworkset.tran.db.DBImportContext;
import org.frameworkset.tran.db.input.es.DBDataTranPlugin;
import org.frameworkset.tran.es.ESExportResultHandler;
import org.frameworkset.tran.es.output.ESOutputConfig;
import org.frameworkset.tran.es.output.ESOutputContextImpl;

public class DB2ESImportBuilder
extends DBExportBuilder {
    @JsonIgnore
    private ESOutputConfig esOutputConfig;

    protected DB2ESImportBuilder() {
    }

    @Override
    public DataTranPlugin buildDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        return new DBDataTranPlugin(importContext, targetImportContext);
    }

    @Override
    protected ImportContext buildImportContext(BaseImportConfig importConfig) {
        return new DBImportContext(importConfig);
    }

    public static DB2ESImportBuilder newInstance() {
        return new DB2ESImportBuilder();
    }

    @Override
    protected ImportContext buildTargetImportContext(BaseImportConfig importConfig) {
        ESOutputContextImpl esOutputContext = new ESOutputContextImpl(importConfig);
        return esOutputContext;
    }

    public ESOutputConfig getEsOutputConfig() {
        return this.esOutputConfig;
    }

    public void setEsOutputConfig(ESOutputConfig esOutputConfig) {
        this.esOutputConfig = esOutputConfig;
    }

    @Override
    public DataStream builder() {
        super.builderConfig();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("DB2ES Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DBImportConfig importConfig = new DBImportConfig();
        super.buildImportConfig(importConfig);
        super.buildDBImportConfig(importConfig);
        DataStream dataStream = this.createDataStream();
        dataStream.setImportConfig(importConfig);
        dataStream.setConfigString(this.toString());
        dataStream.setImportContext(this.buildImportContext(importConfig));
        if (this.esOutputConfig != null) {
            if (this.esOutputConfig.getTargetIndex() != null) {
                ESIndexWrapper esIndexWrapper = new ESIndexWrapper(this.esOutputConfig.getTargetIndex(), this.esOutputConfig.getTargetIndexType());
                this.esOutputConfig.setEsIndexWrapper(esIndexWrapper);
            }
            dataStream.setTargetImportContext(this.buildTargetImportContext(this.esOutputConfig));
        } else {
            dataStream.setTargetImportContext(dataStream.getImportContext());
        }
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }

    @Override
    protected WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        ESExportResultHandler db2ESExportResultHandler = new ESExportResultHandler(exportResultHandler);
        return db2ESExportResultHandler;
    }
}

