/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.es.input.es;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.es.input.ESExportBuilder;
import org.frameworkset.tran.es.input.es.ES2ESDataTranPlugin;
import org.frameworkset.tran.es.output.ESOutputConfig;
import org.frameworkset.tran.es.output.ESOutputContextImpl;

public class ES2ESExportBuilder
extends ESExportBuilder {
    @JsonIgnore
    private ESOutputConfig esOutputConfig;

    @Override
    public DataTranPlugin buildDataTranPlugin(ImportContext importContext, ImportContext targetImportContext) {
        return new ES2ESDataTranPlugin(importContext, targetImportContext);
    }

    @Override
    protected ImportContext buildTargetImportContext(BaseImportConfig importConfig) {
        ESOutputContextImpl esOutputContext = new ESOutputContextImpl(importConfig);
        return esOutputContext;
    }

    @Override
    public DataStream builder() {
        DataStream dataStream = super.builder();
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ES2ES Import Configs:");
                this.logger.info(this.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.esOutputConfig != null) {
            if (this.esOutputConfig.getTargetIndex() != null) {
                ESIndexWrapper esIndexWrapper = new ESIndexWrapper(this.esOutputConfig.getTargetIndex(), this.esOutputConfig.getTargetIndexType());
                this.esOutputConfig.setEsIndexWrapper(esIndexWrapper);
            }
            dataStream.setTargetImportContext(this.buildTargetImportContext(this.esOutputConfig));
        } else {
            dataStream.setTargetImportContext(dataStream.getImportContext());
        }
        dataStream.setDataTranPlugin(this.buildDataTranPlugin(dataStream.getImportContext(), dataStream.getTargetImportContext()));
        return dataStream;
    }

    public ESOutputConfig getEsOutputConfig() {
        return this.esOutputConfig;
    }

    public void setEsOutputConfig(ESOutputConfig esOutputConfig) {
        this.esOutputConfig = esOutputConfig;
    }
}

