/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCommand;

public abstract class BaseTaskCommand<DATA, RESULT>
implements TaskCommand<DATA, RESULT> {
    protected ImportCount importCount;
    protected ImportContext importContext;
    protected ImportContext targetImportContext;
    protected TaskMetrics taskMetrics;
    protected TaskContext taskContext;
    protected Object lastValue;
    protected long dataSize;
    protected boolean reachEOFClosed;
    protected Status currentStatus;

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    @Override
    public int getTaskNo() {
        return this.taskMetrics.getTaskNo();
    }

    @Override
    public String getJobNo() {
        return this.taskMetrics.getJobNo();
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void finishTask() {
        this.importContext.flushLastValue(this.lastValue, this.currentStatus, this.reachEOFClosed);
    }

    @Override
    public long getElapsed() {
        if (this.taskMetrics != null && this.taskMetrics.getTaskStartTime() != null && this.taskMetrics.getTaskEndTime() != null) {
            return this.taskMetrics.getTaskEndTime().getTime() - this.taskMetrics.getTaskStartTime().getTime();
        }
        return -1L;
    }

    public BaseTaskCommand(ImportCount importCount, ImportContext importContext, ImportContext targetImportContext, long dataSize, int taskNo, String jobNo, Object lastValue, Status currentStatus, boolean reachEOFClosed) {
        this.importCount = importCount;
        this.importContext = importContext;
        this.targetImportContext = targetImportContext;
        this.dataSize = dataSize;
        this.taskMetrics = new TaskMetrics();
        this.taskMetrics.setTaskNo(taskNo);
        this.taskMetrics.setJobNo(jobNo);
        this.lastValue = lastValue;
        this.currentStatus = currentStatus;
        this.reachEOFClosed = reachEOFClosed;
    }

    @Override
    public ImportCount getImportCount() {
        return this.importCount;
    }
}

