/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.util.HashMap;

public class ActionFactory {
    private static ClassLoader loader = ActionFactory.class.getClassLoader();

    public static void setActionClassLoader(ClassLoader loader) {
        ActionFactory.loader = loader;
    }

    public static ClassLoader getActionClassLoader() {
        return loader;
    }

    public static Action createByClass(String className, HashMap<String, String> params) throws ClassNotFoundException, ReflectionException {
        Action a = null;
        Class<?> c = Class.forName(className, true, loader);
        a = (Action)ClassReflection.newInstance(c);
        if (params != null) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                try {
                    ActionUtils.setParam(a, key, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    EngineLogger.error("Error Setting Action Param - Action:" + className + " Param: " + key + " Value: " + value + " Msg: NOT FOUND " + e.getMessage());
                }
            }
        }
        return a;
    }
}

