/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Stops the named verb if it is in execution.")
public class CancelVerbAction
implements Action {
    @ActionPropertyDescription(value="The target actor. Empty for the current actor.")
    @ActionProperty(type=Param.Type.ACTOR)
    private String actor;
    @ActionProperty
    @ActionPropertyDescription(value="The verb to stop. Empty for the current verb.")
    private String verb;
    @ActionPropertyDescription(value="If the verb is 'use', the target actor")
    @ActionProperty(type=Param.Type.ACTOR)
    private String target;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        VerbRunner v = null;
        if (this.verb == null) {
            v = cb;
        }
        if (v == null && this.actor != null) {
            BaseActor a = this.w.getCurrentScene().getActor(this.actor, true);
            v = ((InteractiveActor)a).getVerb(this.verb, this.target);
        }
        if (v == null) {
            v = this.w.getCurrentScene().getVerb(this.verb);
        }
        if (v == null) {
            v = this.w.getVerbManager().getVerb(this.verb, null, null);
        }
        if (v != null) {
            this.w.getCurrentScene().getTimers().removeTimerWithCb(v);
            v.cancel();
        } else {
            EngineLogger.error("Cannot find VERB: " + this.verb + " for ACTOR: " + this.actor);
        }
        return false;
    }
}

