/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.AbstractControlAction;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import java.util.ArrayList;

@ActionDescription(value="Execute only one action inside the Choose/EndChoose block.")
public class ChooseAction
extends AbstractControlAction
implements Json.Serializable {
    @ActionProperty(required=true, defaultValue="CYCLE")
    @ActionPropertyDescription(value="The action to execute will be selected following this criteria.")
    private ChooseCriteria chooseCriteria = ChooseCriteria.CYCLE;
    int chooseCount = -1;

    @Override
    public void init(World w) {
    }

    @Override
    public boolean run(VerbRunner cb) {
        int startIp = cb.getIP();
        int ip0 = startIp + 1;
        ArrayList<Action> actions = cb.getActions();
        int ip = this.skipControlIdBlock(actions, startIp);
        int numActions = ip - startIp - 1;
        if (numActions <= 0) {
            return false;
        }
        switch (this.chooseCriteria) {
            case ITERATE: {
                ++this.chooseCount;
                break;
            }
            case RANDOM: {
                this.chooseCount = MathUtils.random((int)0, (int)(numActions - 1));
                break;
            }
            case CYCLE: {
                this.chooseCount = (this.chooseCount + 1) % numActions;
            }
        }
        cb.setIP(ip);
        if (this.chooseCount < numActions) {
            return ((Action)actions.get(ip0 + this.chooseCount)).run(cb);
        }
        return false;
    }

    @Override
    public String getControlActionID() {
        return this.caID;
    }

    public void write(Json json) {
        json.writeValue("chooseCount", (Object)this.chooseCount);
    }

    public void read(Json json, JsonValue jsonData) {
        this.chooseCount = (Integer)json.readValue("chooseCount", Integer.TYPE, (Object)0, jsonData);
    }

    public static enum ChooseCriteria {
        ITERATE,
        RANDOM,
        CYCLE;

    }
}

