/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Walks to the selected position")
public class GotoAction
implements Action {
    @ActionPropertyDescription(value="The walking actor")
    @ActionProperty(type=Param.Type.CHARACTER_ACTOR, required=true)
    private String actor;
    @ActionPropertyDescription(value="Walks to this actor")
    @ActionProperty(type=Param.Type.ACTOR)
    private String target;
    @ActionProperty
    @ActionPropertyDescription(value="The absolute position to walk to if no target actor is selected. Relative to target if selected.")
    private Vector2 pos;
    @ActionProperty(required=true, defaultValue="false")
    @ActionPropertyDescription(value="Ignore the walking zone and walk in a straight line.")
    private boolean ignoreWalkZone = false;
    @ActionProperty(required=true, defaultValue="true")
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        CharacterActor actor = (CharacterActor)this.w.getCurrentScene().getActor(this.actor, false);
        float x = actor.getX();
        float y = actor.getY();
        if (this.target != null) {
            BaseActor target = this.w.getCurrentScene().getActor(this.target, false);
            x = target.getX();
            y = target.getY();
            if (target instanceof InteractiveActor && target != actor) {
                Vector2 refPoint = ((InteractiveActor)target).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            if (this.pos != null) {
                float scale = EngineAssetManager.getInstance().getScale();
                x += this.pos.x * scale;
                y += this.pos.y * scale;
            }
        } else if (this.pos != null) {
            float scale = EngineAssetManager.getInstance().getScale();
            x = this.pos.x * scale;
            y = this.pos.y * scale;
        }
        actor.goTo(new Vector2(x, y), this.wait ? cb : null, this.ignoreWalkZone);
        return this.wait;
    }

    private void goNear(CharacterActor player, BaseActor actor, ActionCallback cb) {
        Rectangle rdest = actor.getBBox().getBoundingRectangle();
        Vector2 p0 = new Vector2(player.getX(), player.getY());
        Vector2 p1 = new Vector2(rdest.x, rdest.y);
        Vector2 p2 = new Vector2(rdest.x + rdest.width, rdest.y);
        Vector2 p3 = new Vector2(rdest.x + rdest.width / 2.0f, rdest.y);
        float d1 = p0.dst(p1);
        float d2 = p0.dst(p2);
        float d3 = p0.dst(p3);
        Vector2 pf = d1 < d2 && d1 < d3 ? p1 : (d2 < d1 && d2 < d3 ? p2 : p3);
        player.goTo(pf, cb, this.ignoreWalkZone);
    }

    public static enum Align {
        CENTER,
        LEFT,
        RIGHT;

    }
}

