/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.AbstractIfAction;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.ActionUtils;

@ActionDescription(value="Execute actions inside the If/EndIf if the scene attribute has the specified value.")
public class IfSceneAttrAction
extends AbstractIfAction {
    @ActionPropertyDescription(value="The scene to check its attribute")
    @ActionProperty(type=Param.Type.SCENE)
    private String scene;
    @ActionProperty(required=true, defaultValue="state")
    @ActionPropertyDescription(value="The scene attribute")
    private SceneAttr attr;
    @ActionProperty
    @ActionPropertyDescription(value="The attribute value")
    private String value;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s;
        Scene scene = s = this.scene != null && !this.scene.isEmpty() ? this.w.getScene(this.scene) : this.w.getCurrentScene();
        if (this.attr == SceneAttr.STATE) {
            if (!ActionUtils.compareNullStr(this.value, s.getState())) {
                this.gotoElse(cb);
            }
        } else if (this.attr == SceneAttr.CURRENT_SCENE) {
            String scn = this.w.getCurrentScene().getId();
            if (!ActionUtils.compareNullStr(this.value, scn)) {
                this.gotoElse(cb);
            }
        } else if (this.attr == SceneAttr.PLAYER) {
            String id;
            CharacterActor player = s.getPlayer();
            String string = id = player != null ? player.getId() : null;
            if (!ActionUtils.compareNullStr(this.value, id)) {
                this.gotoElse(cb);
            }
        }
        return false;
    }

    public static enum SceneAttr {
        STATE,
        CURRENT_SCENE,
        PLAYER;

    }
}

