/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Sets the value of an Ink variable.")
public class InkVariable
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Variable name")
    private String name;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Value")
    private String value;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        try {
            this.w.getInkManager().setVariable(this.name, this.value);
        }
        catch (Exception e) {
            EngineLogger.error("Cannot set Ink variable: " + this.name + " " + e.getMessage());
        }
        return false;
    }
}

