/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.MusicManager;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Change the volume of the current playing music.")
public class MusicVolumeAction
implements Action {
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Volume of the music [0-1].")
    private float volume = 1.0f;
    @ActionProperty(required=true, defaultValue="0.0")
    @ActionPropertyDescription(value="For volume fade")
    private float duration;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        MusicManager musicEngine = this.w.getMusicManager();
        if (this.duration == 0.0f) {
            musicEngine.setVolume(this.volume);
            return false;
        }
        this.w.getMusicManager().fade(this.volume, this.duration, this.wait ? cb : null);
        return this.wait;
    }
}

