/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Puts the selected actor in the inventory.")
public class PickUpAction
implements Action {
    @ActionProperty(type=Param.Type.SCENE_SPRITE_ACTOR, required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="The animation/sprite to show while in inventory. If empty, the animation will be 'actorid.inventory'")
    private String animation;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene scn = this.actor.getScene(this.w);
        InteractiveActor actor = (InteractiveActor)scn.getActor(this.actor.getActorId(), false);
        if (actor == null) {
            EngineLogger.error("PickUpAction - Actor not found:" + this.actor.getActorId());
            return false;
        }
        scn.removeActor(actor);
        if (actor instanceof SpriteActor) {
            SpriteActor a = (SpriteActor)actor;
            if (scn != this.w.getCurrentScene() && this.w.getCachedScene(scn.getId()) == null) {
                a.loadAssets();
                EngineAssetManager.getInstance().finishLoading();
                a.retrieveAssets();
            }
            if (a.getRenderer() instanceof AnimationRenderer) {
                if (this.animation != null) {
                    a.startAnimation(this.animation, null);
                } else if (((AnimationRenderer)a.getRenderer()).getAnimations().get(a.getId() + ".inventory") != null) {
                    a.startAnimation(a.getId() + ".inventory", null);
                }
            }
            this.w.getInventory().addItem(a);
        }
        return false;
    }
}

