/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.AbstractControlAction;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Repeats the actions inside the Repeat/EndRepeat actions.")
public class RepeatAction
extends AbstractControlAction
implements Json.Serializable {
    @ActionProperty(required=true, defaultValue="1")
    @ActionPropertyDescription(value="Repeat the actions the specified times. -1 to infinity")
    private int repeat = 1;
    private int currentRepeat = 0;

    @Override
    public void init(World w) {
    }

    @Override
    public boolean run(VerbRunner cb) {
        VerbRunner v = cb;
        ++this.currentRepeat;
        if (this.currentRepeat > this.repeat && this.repeat >= 0) {
            int ip = this.skipControlIdBlock(v.getActions(), v.getIP());
            v.setIP(ip);
            this.currentRepeat = 0;
        }
        return false;
    }

    public void write(Json json) {
        json.writeValue("currentRepeat", (Object)this.currentRepeat);
    }

    public void read(Json json, JsonValue jsonData) {
        this.currentRepeat = (Integer)json.readValue("currentRepeat", Integer.TYPE, (Object)0, jsonData);
    }
}

