/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.anim.SpriteRotateTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.InterpolationMode;

@ActionDescription(name="RotateAnim", value="Sets an actor Rotate animation")
public class RotateAction
implements Action {
    @ActionPropertyDescription(value="The target actor")
    @ActionProperty(type=Param.Type.SPRITE_ACTOR)
    private String actor;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The target rotation")
    private float rotation;
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Duration of the animation in seconds")
    private float speed;
    @ActionProperty
    @ActionPropertyDescription(value="The The times to repeat")
    private int count = 1;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the transition is showed and the action continues inmediatly")
    private boolean wait = true;
    @ActionProperty(required=true, defaultValue="REPEAT")
    @ActionPropertyDescription(value="The repeat mode")
    private Tween.Type repeat = Tween.Type.REPEAT;
    @ActionProperty
    @ActionPropertyDescription(value="The interpolation mode")
    private InterpolationMode interpolation;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        SpriteActor a = (SpriteActor)this.w.getCurrentScene().getActor(this.actor, false);
        SpriteRotateTween t = new SpriteRotateTween();
        t.start(a, this.repeat, this.count, this.rotation, this.speed, this.interpolation, this.wait ? cb : null);
        a.addTween(t);
        return this.wait;
    }
}

