/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.anim.SpriteScaleTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.InterpolationMode;

@ActionDescription(name="ScaleAnimXY", value="Scale animation for sprite actors")
public class ScaleAnimActionXY
implements Action {
    @ActionPropertyDescription(value="The target actor")
    @ActionProperty(type=Param.Type.SPRITE_ACTOR)
    private String actor;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The target scale")
    private Vector2 scale;
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Duration of the animation in seconds")
    private float speed;
    @ActionProperty
    @ActionPropertyDescription(value="The The times to repeat")
    private int count = 1;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the transition is showed and the action continues inmediatly")
    private boolean wait = true;
    @ActionProperty(required=true, defaultValue="REPEAT")
    @ActionPropertyDescription(value="The repeat mode")
    private Tween.Type repeat = Tween.Type.REPEAT;
    @ActionProperty
    @ActionPropertyDescription(value="The interpolation mode")
    private InterpolationMode interpolation;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        SpriteActor a = (SpriteActor)this.w.getCurrentScene().getActor(this.actor, false);
        SpriteScaleTween t = new SpriteScaleTween();
        t.start(a, this.repeat, this.count, this.scale.x, this.scale.y, this.speed, this.interpolation, this.wait ? cb : null);
        a.addTween(t);
        return this.wait;
    }
}

