/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Draw a text in the screen")
public class TextAction
implements Action {
    @ActionPropertyDescription(value="The 'text' to show")
    @ActionProperty(type=Param.Type.SMALL_TEXT)
    private String text;
    @ActionPropertyDescription(value="The 'voice' file to play if selected.")
    @ActionProperty(type=Param.Type.VOICE)
    private String voiceId;
    @ActionPropertyDescription(value="The style to use (an entry in your `ui.json` in the `com.bladecoder.engine.ui.TextManagerUI$TextManagerUIStyle` section)")
    @ActionProperty(type=Param.Type.TEXT_STYLE, required=true, defaultValue="default")
    private String style;
    @ActionPropertyDescription(value="The color to use for the font (RRGGBBAA). If not set, the default color defined in the style is used.")
    @ActionProperty(type=Param.Type.COLOR)
    private Color color;
    @ActionProperty
    @ActionPropertyDescription(value="Obtain the text position from this actor.")
    private SceneActorRef target;
    @ActionProperty
    @ActionPropertyDescription(value="The position of the text. -1 for center. Absolute if no target is selected. Relative if the target is selected.")
    private Vector2 pos;
    @ActionProperty(required=true, defaultValue="SUBTITLE")
    @ActionPropertyDescription(value="The type of the text.")
    private Text.Type type = Text.Type.PLAIN;
    @ActionProperty(defaultValue="false")
    @ActionPropertyDescription(value="Queue the text if other text is showing, or show it immediately.")
    private boolean queue = false;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        if (this.text == null) {
            return false;
        }
        float x = -1.0f;
        float y = -1.0f;
        if (this.target != null) {
            Scene ts = this.target.getScene(this.w);
            BaseActor anchorActor = ts.getActor(this.target.getActorId(), true);
            x = anchorActor.getX();
            y = anchorActor.getY();
            if (anchorActor instanceof InteractiveActor) {
                Vector2 refPoint = ((InteractiveActor)anchorActor).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            if (this.pos != null) {
                float scale = EngineAssetManager.getInstance().getScale();
                x += this.pos.x * scale;
                y += this.pos.y * scale;
            }
        } else if (this.pos != null) {
            float scale = EngineAssetManager.getInstance().getScale();
            if (this.pos.x != -1.0f) {
                x = this.pos.x * scale;
            }
            if (this.pos.y != -1.0f) {
                y = this.pos.y * scale;
            }
        } else if (this.type == Text.Type.SUBTITLE) {
            y = -2.0f;
            x = -2.0f;
        }
        this.w.getCurrentScene().getTextManager().addText(this.text, x, y, this.queue, this.type, this.color, this.style, null, this.voiceId, null, this.wait ? cb : null);
        return this.wait;
    }
}

