/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.Transition;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Sets a transition effect (FADEIN/FADEOUT)")
public class TransitionAction
implements Action {
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Duration of the transition")
    private float time = 1.0f;
    @ActionPropertyDescription(value="The color to fade ('white', 'black' or RRGGBBAA).")
    @ActionProperty(type=Param.Type.COLOR, required=true, defaultValue="black")
    private Color color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    @ActionProperty(required=true, defaultValue="FADE_IN")
    @ActionPropertyDescription(value="The transition type (fadein/fadeout)")
    private Transition.Type type = Transition.Type.FADE_IN;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the transition is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Transition t = this.w.getTransition();
        t.create(this.time, this.color, this.type, this.wait ? cb : null);
        return this.wait;
    }
}

