/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.MusicManager;
import com.bladecoder.engine.util.InterpolationMode;

public class MusicVolumeTween
extends Tween<MusicManager> {
    private float startVolume;
    private float targetVolume;

    public void start(MusicManager mm, float tVolume, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.target = mm;
        this.startVolume = mm.getVolume();
        this.targetVolume = tVolume;
        this.setDuration(duration);
        this.setType(Tween.Type.NO_REPEAT);
        this.setCount(1);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        ((MusicManager)this.target).setVolume(this.startVolume + this.getPercent() * (this.targetVolume - this.startVolume));
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startVolume", (Object)Float.valueOf(this.startVolume));
        json.writeValue("targetVolume", (Object)Float.valueOf(this.targetVolume));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startVolume = ((Float)json.readValue("startVolume", Float.class, (Object)Float.valueOf(1.0f), jsonData)).floatValue();
        this.targetVolume = ((Float)json.readValue("targetVolume", Float.class, (Object)Float.valueOf(1.0f), jsonData)).floatValue();
    }
}

