/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.ResolutionFileResolver;
import com.badlogic.gdx.files.FileHandle;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.FileUtils;

public class EngineResolutionFileResolver
implements FileHandleResolver {
    private final FileHandleResolver baseResolver;
    private ResolutionFileResolver.Resolution[] descriptors;
    private ResolutionFileResolver.Resolution bestDesc;
    private String fixResolution;

    public EngineResolutionFileResolver(FileHandleResolver baseResolver) {
        this.baseResolver = baseResolver;
    }

    public FileHandle resolve(String fileName) {
        FileHandle originalHandle = new FileHandle(fileName);
        FileHandle handle = this.baseResolver.resolve(this.resolve(originalHandle, this.bestDesc.folder));
        if (!FileUtils.exists(handle)) {
            handle = this.baseResolver.resolve(fileName);
        }
        return handle;
    }

    protected String resolve(FileHandle originalHandle, String suffix) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(originalHandle.parent());
        stringBuilder.append("/");
        stringBuilder.append(suffix);
        stringBuilder.append("/");
        stringBuilder.append(originalHandle.name());
        return stringBuilder.toString();
    }

    public boolean exists(String fileName) {
        FileHandle originalHandle = new FileHandle(fileName);
        FileHandle handle = this.baseResolver.resolve(this.resolve(originalHandle, this.bestDesc.folder));
        if (FileUtils.exists(handle)) {
            return true;
        }
        handle = this.baseResolver.resolve(fileName);
        return FileUtils.exists(handle);
    }

    public FileHandleResolver getBaseResolver() {
        return this.baseResolver;
    }

    public FileHandle baseResolve(String fileName) {
        return this.baseResolver.resolve(fileName);
    }

    public ResolutionFileResolver.Resolution[] getResolutions() {
        return this.descriptors;
    }

    public ResolutionFileResolver.Resolution getResolution() {
        return this.bestDesc;
    }

    public void selectResolution() {
        if (this.fixResolution != null) {
            this.selectFixedResolution();
        } else {
            this.selectBestResolution();
        }
    }

    private void selectBestResolution() {
        this.bestDesc = this.descriptors[0];
        int width = Gdx.graphics.getWidth() > Gdx.graphics.getHeight() ? Gdx.graphics.getWidth() : Gdx.graphics.getHeight();
        int bestDist = Math.abs(width - this.bestDesc.portraitWidth);
        for (int i = 1; i < this.descriptors.length; ++i) {
            ResolutionFileResolver.Resolution other = this.descriptors[i];
            int dist = Math.abs(width - other.portraitWidth);
            if (dist >= bestDist) continue;
            this.bestDesc = this.descriptors[i];
            bestDist = dist;
        }
    }

    public void setResolutions(ResolutionFileResolver.Resolution[] resolutions) {
        this.descriptors = resolutions;
    }

    private void selectFixedResolution() {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].folder.equals(this.fixResolution)) continue;
            this.bestDesc = this.descriptors[i];
            return;
        }
        if (this.bestDesc == null) {
            EngineLogger.error("Requested resolution not found: " + this.fixResolution);
            this.selectBestResolution();
        }
    }

    public void setFixedResolution(String suffix) {
        this.fixResolution = suffix;
    }
}

