/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.i18n;

import com.bladecoder.engine.i18n.I18NControl;
import com.bladecoder.engine.util.EngineLogger;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18N {
    public static final char PREFIX = '@';
    public static final String ENCODING = "UTF-8";
    private static ResourceBundle i18nWorld;
    private static ResourceBundle i18nChapter;
    private static Locale locale;
    private static String i18nChapterFilename;
    private static String i18nWorldFilename;

    public static void loadChapter(String i18nChapterFilename) {
        try {
            i18nChapter = I18N.getBundle(i18nChapterFilename, false);
            I18N.i18nChapterFilename = i18nChapterFilename;
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + i18nChapterFilename);
        }
    }

    public static void loadWorld(String i18nWorldFilename) {
        try {
            i18nWorld = I18N.getBundle(i18nWorldFilename, true);
            I18N.i18nWorldFilename = i18nWorldFilename;
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + i18nWorldFilename);
        }
    }

    public static ResourceBundle getBundle(String filename, boolean clearCache) {
        ResourceBundle rb = null;
        try {
            if (clearCache) {
                ResourceBundle.clearCache();
            }
            rb = ResourceBundle.getBundle(filename, locale, new I18NControl(ENCODING));
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + filename);
        }
        return rb;
    }

    public static void setLocale(Locale l) {
        locale = l;
        if (i18nWorld != null) {
            I18N.loadWorld(i18nWorldFilename);
        }
        if (i18nChapter != null) {
            I18N.loadChapter(i18nChapterFilename);
        }
    }

    public static String getString(String key) {
        try {
            return i18nChapter.getString(key);
        }
        catch (Exception e) {
            try {
                return i18nWorld.getString(key);
            }
            catch (Exception e2) {
                EngineLogger.error("MISSING TRANSLATION KEY: " + key);
                return key;
            }
        }
    }

    public static Locale getCurrentLocale() {
        return locale;
    }

    static {
        locale = Locale.getDefault();
        i18nChapterFilename = null;
        i18nWorldFilename = null;
    }
}

