/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionFactory;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.ink.ExternalFunctions;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.ink.runtime.Choice;
import com.bladecoder.ink.runtime.InkList;
import com.bladecoder.ink.runtime.ListDefinition;
import com.bladecoder.ink.runtime.Story;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class InkManager
implements VerbRunner,
Json.Serializable {
    public static final char NAME_VALUE_TAG_SEPARATOR = ':';
    public static final char NAME_VALUE_PARAM_SEPARATOR = '=';
    private static final String PARAM_SEPARATOR = ",";
    public static final char COMMAND_MARK = '>';
    private static ResourceBundle i18n;
    private Story story = null;
    private ExternalFunctions externalFunctions;
    private ActionCallback cb;
    private String sCb;
    private ArrayList<Action> actions;
    private boolean wasInCutmode;
    private String storyName;
    private int ip = -1;
    private final World w;

    public InkManager(World w) {
        this.w = w;
        this.externalFunctions = new ExternalFunctions();
        this.actions = new ArrayList();
    }

    public void newStory(InputStream is) throws Exception {
        String json = this.getJsonString(is);
        this.story = new Story(json);
        this.externalFunctions.bindExternalFunctions(this.w, this);
    }

    public void newStory(final String name) throws Exception {
        new Thread(){

            @Override
            public void run() {
                InkManager.this.loadStory(name, null);
            }
        }.start();
        Thread.yield();
    }

    private synchronized void loadStory(String name, String stateString) {
        FileHandle asset = EngineAssetManager.getInstance().getAsset("model/" + name + ".ink.json");
        try {
            long initTime = System.currentTimeMillis();
            this.newStory(asset.read());
            this.storyName = name;
            this.loadI18NBundle();
            EngineLogger.debug("INK STORY LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
            if (stateString != null) {
                initTime = System.currentTimeMillis();
                this.story.getState().loadJson(stateString);
                EngineLogger.debug("INK SAVED STATE LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
            }
        }
        catch (Exception e) {
            EngineLogger.error("Cannot load Ink Story: " + name + " " + e.getMessage());
            this.story = null;
            this.storyName = null;
        }
    }

    public void loadI18NBundle() {
        if (this.storyName != null && EngineAssetManager.getInstance().getModelFile(this.storyName + "-ink.properties").exists()) {
            i18n = I18N.getBundle("model/" + this.storyName + "-ink", true);
        }
    }

    public String translateLine(String line) {
        if (line.charAt(0) == '@') {
            String key = line.substring(1);
            String[] keys = key.split("@");
            String translated = "";
            for (String k : keys) {
                try {
                    translated = translated + i18n.getString(k);
                }
                catch (Exception e) {
                    EngineLogger.error("MISSING TRANSLATION KEY: " + key);
                    return key;
                }
            }
            translated = translated.replace('_', ' ');
            return translated;
        }
        return line;
    }

    public synchronized String getVariable(String name) {
        return this.story.getVariablesState().get(name).toString();
    }

    public synchronized boolean compareVariable(String name, String value) {
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            return ((InkList)this.story.getVariablesState().get(name)).ContainsItemNamed(value);
        }
        return this.story.getVariablesState().get(name).toString().equals(value);
    }

    public synchronized void setVariable(String name, String value) throws Exception {
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            List names;
            InkList rawList = (InkList)this.story.getVariablesState().get(name);
            if (rawList.getOrigins() == null && (names = rawList.getOriginNames()) != null) {
                ArrayList<ListDefinition> origins = new ArrayList<ListDefinition>();
                for (String n : names) {
                    ListDefinition def = this.story.getListDefinitions().getListDefinition(n);
                    if (origins.contains(def)) continue;
                    origins.add(def);
                }
                rawList.setOrigins(origins);
            }
            rawList.addItem(value);
        } else {
            this.story.getVariablesState().set(name, (Object)value);
        }
    }

    private void continueMaximally() {
        String line = null;
        this.actions.clear();
        HashMap<String, String> currentLineParams = new HashMap<String, String>();
        while (this.story.canContinue()) {
            try {
                line = this.story.Continue();
                currentLineParams.clear();
                if (!line.isEmpty()) {
                    line = line.substring(0, line.length() - 1);
                }
                if (!line.isEmpty()) {
                    if (EngineLogger.debugMode()) {
                        EngineLogger.debug("INK LINE: " + this.translateLine(line));
                    }
                    this.processParams(this.story.getCurrentTags(), currentLineParams);
                    if (line.charAt(0) == '>') {
                        this.processCommand(currentLineParams, line);
                    } else {
                        this.processTextLine(currentLineParams, line);
                    }
                } else {
                    EngineLogger.debug("INK EMPTY LINE!");
                }
            }
            catch (Exception e) {
                EngineLogger.error(e.getMessage(), e);
            }
            if (this.story.getCurrentErrors() == null || this.story.getCurrentErrors().isEmpty()) continue;
            EngineLogger.error((String)this.story.getCurrentErrors().get(0));
        }
        if (this.actions.size() > 0) {
            this.run(null, null);
        } else if (this.hasChoices()) {
            this.wasInCutmode = this.w.inCutMode();
            this.w.setCutMode(false);
            this.w.getListener().dialogOptions();
        } else if (this.cb != null || this.sCb != null) {
            if (this.cb == null) {
                this.cb = ActionCallbackSerializer.find(this.w, this.sCb);
            }
            ActionCallback tmpcb = this.cb;
            this.cb = null;
            tmpcb.resume();
        }
    }

    private void processParams(List<String> input, HashMap<String, String> output) {
        for (String t : input) {
            String value;
            String key;
            int i = t.indexOf(58);
            if (i == -1) {
                i = t.indexOf(61);
            }
            if (i != -1) {
                key = t.substring(0, i).trim();
                value = t.substring(i + 1, t.length()).trim();
            } else {
                key = t.trim();
                value = null;
            }
            EngineLogger.debug("PARAM: " + key + " value: " + value);
            output.put(key, value);
        }
    }

    private void processCommand(HashMap<String, String> params, String line) {
        String commandName = null;
        String[] commandParams = null;
        int i = line.indexOf(58);
        if (i == -1) {
            commandName = line.substring(1).trim();
        } else {
            commandName = line.substring(1, i).trim();
            commandParams = line.substring(i + 1).split(PARAM_SEPARATOR);
            this.processParams(Arrays.asList(commandParams), params);
        }
        if ("leave".equals(commandName)) {
            boolean init = true;
            if (params.get("init") != null) {
                init = Boolean.parseBoolean(params.get("init"));
            }
            this.w.setCurrentScene(params.get("scene"), init);
        } else if ("set".equals(commandName)) {
            this.w.setModelProp(params.get("prop"), params.get("value"));
        } else {
            if ("action".equals(commandName)) {
                commandName = commandParams[0].trim();
                params.remove(commandName);
            }
            if (commandName.length() > 0 && Character.isUpperCase(commandName.charAt(0))) {
                try {
                    Action action = ActionFactory.createByClass("com.bladecoder.engine.actions." + commandName + "Action", params);
                    action.init(this.w);
                    this.actions.add(action);
                }
                catch (ReflectionException | ClassNotFoundException e) {
                    EngineLogger.error(e.getMessage(), (Exception)e);
                }
            } else {
                EngineLogger.error("Ink command not found: " + commandName);
            }
        }
    }

    private void processTextLine(HashMap<String, String> params, String line) {
        int idx;
        if (!params.containsKey("actor") && (idx = line.indexOf(62)) != -1) {
            params.put("actor", line.substring(0, idx).trim());
            line = line.substring(idx + 1).trim();
        }
        if (!params.containsKey("actor") && this.w.getCurrentScene().getPlayer() != null) {
            if (!params.containsKey("type")) {
                params.put("type", Text.Type.SUBTITLE.toString());
            }
        } else if (params.containsKey("actor") && !params.containsKey("type")) {
            params.put("type", Text.Type.TALK.toString());
        } else if (!params.containsKey("type")) {
            params.put("type", Text.Type.SUBTITLE.toString());
        }
        params.put("text", this.translateLine(line));
        try {
            Action action = null;
            action = !params.containsKey("actor") ? ActionFactory.createByClass("com.bladecoder.engine.actions.TextAction", params) : ActionFactory.createByClass("com.bladecoder.engine.actions.SayAction", params);
            action.init(this.w);
            this.actions.add(action);
        }
        catch (ReflectionException | ClassNotFoundException e) {
            EngineLogger.error(e.getMessage(), (Exception)e);
        }
    }

    private void nextStep() {
        if (this.ip < 0) {
            this.continueMaximally();
        } else {
            boolean stop = false;
            while (this.ip < this.actions.size() && !stop) {
                Action a = this.actions.get(this.ip);
                try {
                    if (a.run(this)) {
                        stop = true;
                        continue;
                    }
                    ++this.ip;
                }
                catch (Exception e) {
                    EngineLogger.error("EXCEPTION EXECUTING ACTION: " + a.getClass().getSimpleName(), e);
                    ++this.ip;
                }
            }
            if (this.ip >= this.actions.size() && !stop) {
                this.continueMaximally();
            }
        }
    }

    public Story getStory() {
        return this.story;
    }

    public synchronized void runPath(String path, ActionCallback cb) throws Exception {
        if (this.story == null) {
            EngineLogger.error("Ink Story not loaded!");
            return;
        }
        this.cb = cb;
        this.story.choosePathString(path);
        this.continueMaximally();
    }

    public boolean hasChoices() {
        return this.story != null && this.actions.size() == 0 && this.story.getCurrentChoices().size() > 0;
    }

    public List<String> getChoices() {
        List options = this.story.getCurrentChoices();
        ArrayList<String> choices = new ArrayList<String>(options.size());
        for (Choice o : options) {
            String line = o.getText();
            if (line.isEmpty()) continue;
            int idx = line.indexOf(62);
            if (idx != -1) {
                line = line.substring(idx + 1).trim();
            }
            choices.add(this.translateLine(line));
        }
        return choices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonString(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            if (line != null) {
                line = line.replace('\ufeff', ' ');
            }
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public void resume() {
        ++this.ip;
        this.nextStep();
    }

    public void selectChoice(int i) {
        this.w.setCutMode(this.wasInCutmode);
        try {
            this.story.chooseChoiceIndex(i);
            this.continueMaximally();
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage(), e);
        }
    }

    @Override
    public ArrayList<Action> getActions() {
        return this.actions;
    }

    @Override
    public void run(String currentTarget, ActionCallback cb) {
        this.ip = 0;
        this.nextStep();
    }

    @Override
    public int getIP() {
        return this.ip;
    }

    @Override
    public void setIP(int ip) {
        this.ip = ip;
    }

    @Override
    public void cancel() {
        ArrayList<Action> actions = this.getActions();
        for (Action c : actions) {
            if (!(c instanceof VerbRunner)) continue;
            ((VerbRunner)((Object)c)).cancel();
        }
        this.ip = actions.size();
    }

    @Override
    public String getCurrentTarget() {
        return null;
    }

    public void write(Json json) {
        World w = ((BladeJson)json).getWorld();
        json.writeValue("wasInCutmode", (Object)this.wasInCutmode);
        if (this.cb == null && this.sCb != null) {
            this.cb = ActionCallbackSerializer.find(w, this.sCb);
        }
        if (this.cb != null) {
            json.writeValue("cb", (Object)ActionCallbackSerializer.find(w, this.cb));
        }
        json.writeArrayStart("actions");
        for (Action a : this.actions) {
            ActionUtils.writeJson(a, json);
        }
        json.writeArrayEnd();
        json.writeValue("ip", (Object)this.ip);
        json.writeArrayStart("actionsSer");
        for (Action a : this.actions) {
            if (!(a instanceof Json.Serializable)) continue;
            json.writeObjectStart();
            ((Json.Serializable)a).write(json);
            json.writeObjectEnd();
        }
        json.writeArrayEnd();
        json.writeValue("storyName", (Object)this.storyName);
        if (this.story != null) {
            try {
                json.writeValue("story", (Object)this.story.getState().toJson());
            }
            catch (Exception e) {
                EngineLogger.error(e.getMessage(), e);
            }
        }
    }

    public void read(Json json, JsonValue jsonData) {
        int i;
        this.wasInCutmode = (Boolean)json.readValue("wasInCutmode", Boolean.class, jsonData);
        this.sCb = (String)json.readValue("cb", String.class, jsonData);
        this.actions.clear();
        JsonValue actionsValue = jsonData.get("actions");
        for (i = 0; i < actionsValue.size; ++i) {
            JsonValue aValue = actionsValue.get(i);
            Action a = ActionUtils.readJson(this.w, json, aValue);
            this.actions.add(a);
        }
        this.ip = (Integer)json.readValue("ip", Integer.class, jsonData);
        actionsValue = jsonData.get("actionsSer");
        i = 0;
        for (Action a : this.actions) {
            if (!(a instanceof Json.Serializable) || i >= actionsValue.size) continue;
            if (actionsValue.get(i) == null) break;
            ((Json.Serializable)a).read(json, actionsValue.get(i));
            ++i;
        }
        String storyName = (String)json.readValue("storyName", String.class, jsonData);
        String storyString = (String)json.readValue("story", String.class, jsonData);
        if (storyString != null) {
            this.loadStory(storyName, storyString);
        }
    }
}

