/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.serialization.BladeJson;
import java.util.HashMap;

public abstract class AnimationRenderer
implements ActorRenderer {
    public static final String BACK = "back";
    public static final String FRONT = "front";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String BACKRIGHT = "backright";
    public static final String BACKLEFT = "backleft";
    public static final String FRONTRIGHT = "frontright";
    public static final String FRONTLEFT = "frontleft";
    private static final float DEFAULT_DIM = 200.0f;
    protected HashMap<String, AnimationDesc> fanims = new HashMap();
    protected String initAnimation;
    protected AnimationDesc currentAnimation;
    protected CacheEntry currentSource;
    protected boolean flipX;
    protected final HashMap<String, CacheEntry> sourceCache = new HashMap();
    protected Polygon bbox;
    protected int orgAlign = 8;
    private static final float DIRECTION_ASPECT_TOLERANCE = 3.0f;
    private static final float DIRECTION_ASPECT_TOLERANCE_2 = 3.0f;

    public abstract void startAnimation(String var1, Tween.Type var2, int var3, ActionCallback var4);

    public abstract void startAnimation(String var1, Tween.Type var2, int var3, ActionCallback var4, String var5);

    public abstract void startAnimation(String var1, Tween.Type var2, int var3, ActionCallback var4, Vector2 var5, Vector2 var6);

    public abstract String[] getInternalAnimations(AnimationDesc var1);

    public AnimationDesc getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Override
    public float getWidth() {
        return 200.0f;
    }

    @Override
    public float getHeight() {
        return 200.0f;
    }

    public static float getAlignDx(float width, int align) {
        if ((align & 8) != 0) {
            return 0.0f;
        }
        if ((align & 0x10) != 0) {
            return -width;
        }
        if ((align & 1) != 0) {
            return -width / 2.0f;
        }
        return -width / 2.0f;
    }

    public static float getAlignDy(float height, int align) {
        if ((align & 4) != 0) {
            return 0.0f;
        }
        if ((align & 2) != 0) {
            return -height;
        }
        if ((align & 1) != 0) {
            return -height / 2.0f;
        }
        return 0.0f;
    }

    public String getCurrentAnimationId() {
        if (this.currentAnimation == null) {
            return null;
        }
        String id = this.currentAnimation.id;
        if (this.flipX) {
            id = AnimationRenderer.getFlipId(id);
        }
        return id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  Anims:");
        for (String v : this.fanims.keySet()) {
            sb.append(" ").append(v);
        }
        if (this.currentAnimation != null) {
            sb.append("\n  Current Anim: ").append(this.currentAnimation.id);
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void updateBboxFromRenderer(Polygon bbox) {
        this.bbox = bbox;
        this.computeBbox();
    }

    protected void computeBbox() {
        if (this.bbox == null) {
            return;
        }
        if (this.bbox.getVertices() == null || this.bbox.getVertices().length != 8) {
            this.bbox.setVertices(new float[8]);
        }
        float dx = AnimationRenderer.getAlignDx(this.getWidth(), this.orgAlign);
        float dy = AnimationRenderer.getAlignDy(this.getHeight(), this.orgAlign);
        float[] verts = this.bbox.getVertices();
        verts[0] = dx;
        verts[1] = dy;
        verts[2] = dx;
        verts[3] = this.getHeight() + dy;
        verts[4] = this.getWidth() + dx;
        verts[5] = this.getHeight() + dy;
        verts[6] = this.getWidth() + dx;
        verts[7] = dy;
        this.bbox.dirty();
    }

    public void addAnimation(AnimationDesc fa) {
        if (this.initAnimation == null) {
            this.initAnimation = fa.id;
        }
        this.fanims.put(fa.id, fa);
    }

    public HashMap<String, AnimationDesc> getAnimations() {
        return this.fanims;
    }

    public void setInitAnimation(String fa) {
        this.initAnimation = fa;
    }

    public String getInitAnimation() {
        return this.initAnimation;
    }

    @Override
    public int getOrgAlign() {
        return this.orgAlign;
    }

    @Override
    public void setOrgAlign(int align) {
        this.orgAlign = align;
    }

    protected AnimationDesc getAnimation(String id) {
        AnimationDesc fa = this.fanims.get(id);
        this.flipX = false;
        if (fa == null && id.indexOf(46) != -1) {
            String flipId = AnimationRenderer.getFlipId(id);
            fa = this.fanims.get(flipId);
            if (fa != null) {
                this.flipX = true;
            } else {
                StringBuilder sb = new StringBuilder();
                if (id.endsWith(FRONTLEFT)) {
                    sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                    sb.append(LEFT);
                } else if (id.endsWith(FRONTRIGHT)) {
                    sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                    sb.append(RIGHT);
                } else if (id.endsWith(BACKLEFT) || id.endsWith(BACKRIGHT)) {
                    sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                    sb.append(BACK);
                } else if (id.endsWith(LEFT)) {
                    sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                    sb.append(FRONTLEFT);
                } else if (id.endsWith(RIGHT)) {
                    sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                    sb.append(FRONTRIGHT);
                }
                String s = sb.toString();
                fa = this.fanims.get(s);
                if (fa == null) {
                    flipId = AnimationRenderer.getFlipId(s);
                    fa = this.fanims.get(flipId);
                    if (fa != null) {
                        this.flipX = true;
                    } else if (s.endsWith(FRONT) || s.endsWith(BACK)) {
                        if (id.endsWith(LEFT)) {
                            sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                            sb.append(LEFT);
                        } else {
                            sb.append(id.substring(0, id.lastIndexOf(46) + 1));
                            sb.append(RIGHT);
                        }
                        s = sb.toString();
                        fa = this.fanims.get(s);
                        if (fa == null && (fa = this.fanims.get(flipId = AnimationRenderer.getFlipId(s))) != null) {
                            this.flipX = true;
                        }
                    }
                }
            }
        }
        return fa;
    }

    public static String getFlipId(String id) {
        StringBuilder sb = new StringBuilder();
        if (id.endsWith(LEFT)) {
            sb.append(id.substring(0, id.length() - LEFT.length()));
            sb.append(RIGHT);
        } else if (id.endsWith(RIGHT)) {
            sb.append(id.substring(0, id.length() - RIGHT.length()));
            sb.append(LEFT);
        }
        return sb.toString();
    }

    protected String getDirectionString(Vector2 p0, Vector2 pf, int numDirs) {
        if (numDirs == 0 || numDirs == -1) {
            return null;
        }
        float dx = pf.x - p0.x;
        float dy = pf.y - p0.y;
        float ratio = Math.abs(dx / dy);
        float ratio2 = ratio;
        if ((double)ratio2 < 1.0) {
            ratio2 = 1.0f / ratio;
        }
        if (ratio2 < 3.0f && numDirs > 4) {
            if (dy > 0.0f) {
                if (dx > 0.0f) {
                    return BACKRIGHT;
                }
                return BACKLEFT;
            }
            if (dx > 0.0f) {
                return FRONTRIGHT;
            }
            return FRONTLEFT;
        }
        if (ratio > 3.0f || numDirs < 4) {
            if (dx > 0.0f) {
                return RIGHT;
            }
            return LEFT;
        }
        if (dy > 0.0f) {
            return BACK;
        }
        return FRONT;
    }

    protected int getDirs(String base, HashMap<String, AnimationDesc> fanims) {
        String basePoint = base + ".";
        if (fanims.containsKey(basePoint + FRONTRIGHT) || fanims.containsKey(basePoint + FRONTLEFT)) {
            return 8;
        }
        if (fanims.containsKey(basePoint + BACK)) {
            return 4;
        }
        if (fanims.containsKey(basePoint + LEFT) || fanims.containsKey(basePoint + RIGHT)) {
            return 2;
        }
        if (fanims.containsKey(base)) {
            return 0;
        }
        return -1;
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("fanims", this.fanims, HashMap.class, null);
            json.writeValue("initAnimation", (Object)this.initAnimation);
            json.writeValue("orgAlign", (Object)this.orgAlign);
        } else {
            String currentAnimationId = null;
            if (this.currentAnimation != null) {
                currentAnimationId = this.currentAnimation.id;
            }
            json.writeValue("currentAnimation", (Object)currentAnimationId);
            json.writeValue("flipX", (Object)this.flipX);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.initAnimation = (String)json.readValue("initAnimation", String.class, jsonData);
            this.orgAlign = (Integer)json.readValue("orgAlign", Integer.TYPE, (Object)4, jsonData);
        } else {
            String currentAnimationId = (String)json.readValue("currentAnimation", String.class, jsonData);
            if (currentAnimationId != null) {
                this.currentAnimation = this.fanims.get(currentAnimationId);
            }
            this.flipX = (Boolean)json.readValue("flipX", Boolean.class, jsonData);
        }
    }

    public class CacheEntry {
        public int refCounter;
    }
}

