/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.anim.AtlasAnimationDesc;
import com.bladecoder.engine.anim.FATween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.util.ArrayList;
import java.util.HashMap;

public class AtlasRenderer
extends AnimationRenderer {
    private TextureAtlas.AtlasRegion tex;
    private FATween faTween;
    private int currentFrameIndex;

    @Override
    public String[] getInternalAnimations(AnimationDesc anim) {
        this.retrieveSource(anim.source);
        TextureAtlas atlas = EngineAssetManager.getInstance().getTextureAtlas(anim.source);
        Array animations = atlas.getRegions();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < animations.size; ++i) {
            TextureAtlas.AtlasRegion a = (TextureAtlas.AtlasRegion)animations.get(i);
            if (l.contains(a.name)) continue;
            l.add(a.name);
        }
        return l.toArray(new String[l.size()]);
    }

    @Override
    public void update(float delta) {
        if (this.faTween != null) {
            this.faTween.update(delta);
            if (this.faTween.isComplete()) {
                this.faTween = null;
                this.computeBbox();
            }
        }
    }

    public void setFrame(int i) {
        this.currentFrameIndex = i;
        this.tex = (TextureAtlas.AtlasRegion)((AtlasAnimationDesc)this.currentAnimation).regions.get(i);
    }

    @Override
    public void draw(SpriteBatch batch, float x, float y, float scaleX, float scaleY, float rotation, Color tint) {
        float dx = AtlasRenderer.getAlignDx(this.getWidth(), this.orgAlign);
        float dy = AtlasRenderer.getAlignDy(this.getHeight(), this.orgAlign);
        if (this.tex == null) {
            RectangleRenderer.draw((Batch)batch, x + dx * scaleX, y + dy * scaleY, this.getWidth() * scaleX, this.getHeight() * scaleY, Color.RED);
            return;
        }
        x = x + this.tex.offsetX + dx;
        y = y + this.tex.offsetY + dy;
        if (tint != null) {
            batch.setColor(tint);
        }
        batch.draw((TextureRegion)this.tex, x, y, -dx - this.tex.offsetX, -dy - this.tex.offsetY, (float)this.tex.packedWidth, (float)this.tex.packedHeight, this.flipX ? -scaleX : scaleX, scaleY, rotation);
        if (tint != null) {
            batch.setColor(Color.WHITE);
        }
    }

    @Override
    public float getWidth() {
        if (this.tex == null) {
            return super.getWidth();
        }
        return this.tex.originalWidth;
    }

    @Override
    public float getHeight() {
        if (this.tex == null) {
            return super.getHeight();
        }
        return this.tex.originalHeight;
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb) {
        AtlasAnimationDesc fa;
        if (id == null) {
            id = this.initAnimation;
        }
        if ((fa = (AtlasAnimationDesc)this.getAnimation(id)) == null) {
            EngineLogger.error("AnimationDesc not found: " + id);
            return;
        }
        if (this.currentAnimation != null && this.currentAnimation.disposeWhenPlayed) {
            this.disposeSource(this.currentAnimation.source);
            ((AtlasAnimationDesc)this.currentAnimation).regions = null;
        }
        this.currentAnimation = fa;
        if (fa.regions == null) {
            this.retrieveFA(fa);
            if (fa.regions == null || fa.regions.size == 0) {
                EngineLogger.error(this.currentAnimation.id + " has no regions in ATLAS " + this.currentAnimation.source);
                this.fanims.remove(this.currentAnimation.id);
            }
        }
        if (fa.regions.size == 1 || (double)fa.duration == 0.0) {
            this.setFrame(0);
            this.computeBbox();
            if (cb != null) {
                ActionCallback tmpcb = cb;
                cb = null;
                tmpcb.resume();
            }
            return;
        }
        if (repeatType == Tween.Type.SPRITE_DEFINED) {
            repeatType = this.currentAnimation.animationType;
            count = this.currentAnimation.count;
        }
        this.faTween = new FATween();
        this.faTween.start(this, repeatType, count, this.currentAnimation.duration, cb);
        if (repeatType == Tween.Type.REVERSE) {
            this.setFrame(this.getNumFrames() - 1);
        } else {
            this.setFrame(0);
        }
        this.computeBbox();
    }

    public int getNumFrames() {
        return ((AtlasAnimationDesc)this.currentAnimation).regions.size;
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, String direction) {
        StringBuilder sb = new StringBuilder(id);
        if (direction == null) {
            int idx = this.getCurrentAnimationId().indexOf(46);
            if (idx != -1) {
                String dir = this.getCurrentAnimationId().substring(idx);
                sb.append(dir);
            }
        } else {
            sb.append('.');
            sb.append(direction);
        }
        String anim = sb.toString();
        if (this.getAnimation(anim) == null) {
            anim = id;
        }
        this.startAnimation(anim, repeatType, count, null);
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, Vector2 p0, Vector2 pf) {
        this.startAnimation(id, repeatType, count, cb, this.getDirectionString(p0, pf, this.getDirs(id, this.fanims)));
    }

    private void loadSource(String source) {
        AnimationRenderer.CacheEntry entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        if (entry == null) {
            entry = new AnimationRenderer.CacheEntry();
            this.sourceCache.put(source, entry);
        }
        if (entry.refCounter == 0) {
            EngineAssetManager.getInstance().loadAtlas(source);
        }
        ++entry.refCounter;
    }

    private void retrieveFA(AtlasAnimationDesc fa) {
        this.retrieveSource(fa.source);
        fa.regions = EngineAssetManager.getInstance().getRegions(fa.source, fa.id);
    }

    private void retrieveSource(String source) {
        AnimationRenderer.CacheEntry entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        if (entry == null || entry.refCounter < 1) {
            this.loadSource(source);
            EngineAssetManager.getInstance().finishLoading();
        }
    }

    private void disposeSource(String source) {
        AnimationRenderer.CacheEntry entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        if (entry.refCounter == 1) {
            EngineAssetManager.getInstance().disposeAtlas(source);
        }
        --entry.refCounter;
    }

    @Override
    public void loadAssets() {
        for (AnimationDesc fa : this.fanims.values()) {
            if (!fa.preload) continue;
            this.loadSource(fa.source);
        }
        if (this.currentAnimation != null && !this.currentAnimation.preload) {
            this.loadSource(this.currentAnimation.source);
        } else if (this.currentAnimation == null && this.initAnimation != null) {
            AnimationDesc fa;
            String a = this.initAnimation;
            if (this.flipX) {
                a = AtlasRenderer.getFlipId(a);
            }
            if ((fa = (AnimationDesc)this.fanims.get(a)) != null && !fa.preload) {
                this.loadSource(fa.source);
            }
        }
    }

    @Override
    public void retrieveAssets() {
        for (AnimationDesc fa : this.fanims.values()) {
            if (!fa.preload) continue;
            this.retrieveFA((AtlasAnimationDesc)fa);
        }
        if (this.currentAnimation != null && !this.currentAnimation.preload) {
            this.retrieveFA((AtlasAnimationDesc)this.currentAnimation);
        } else if (this.currentAnimation == null && this.initAnimation != null) {
            AnimationDesc fa;
            String a = this.initAnimation;
            if (this.flipX) {
                a = AtlasRenderer.getFlipId(a);
            }
            if ((fa = (AtlasAnimationDesc)this.fanims.get(a)) != null && !((AtlasAnimationDesc)fa).preload) {
                this.retrieveFA((AtlasAnimationDesc)fa);
            }
        }
        if (this.currentAnimation != null) {
            this.setFrame(this.currentFrameIndex);
        } else if (this.initAnimation != null) {
            this.startAnimation(this.initAnimation, Tween.Type.SPRITE_DEFINED, 1, null);
        }
        this.computeBbox();
    }

    public void dispose() {
        for (String key : this.sourceCache.keySet()) {
            if (((AnimationRenderer.CacheEntry)this.sourceCache.get((Object)key)).refCounter <= 0) continue;
            EngineAssetManager.getInstance().disposeAtlas(key);
        }
        this.sourceCache.clear();
    }

    @Override
    public void write(Json json) {
        super.write(json);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() != BladeJson.Mode.MODEL) {
            json.writeValue("currentFrameIndex", (Object)this.currentFrameIndex);
            if (this.faTween != null) {
                json.writeValue("faTween", (Object)this.faTween);
            }
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.fanims = (HashMap)json.readValue("fanims", HashMap.class, AtlasAnimationDesc.class, jsonData);
        } else {
            this.currentFrameIndex = (Integer)json.readValue("currentFrameIndex", Integer.class, jsonData);
            this.faTween = (FATween)json.readValue("faTween", FATween.class, jsonData);
            if (this.faTween != null) {
                this.faTween.setTarget(this);
            }
        }
    }
}

