/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Timer;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.MusicVolumeTween;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.MusicDesc;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.InterpolationMode;

public class MusicManager
implements Json.Serializable,
AssetConsumer {
    private MusicDesc desc = null;
    private Music music = null;
    private float currentMusicDelay = 0.0f;
    private boolean isPlayingSer = false;
    private float musicPosSer = 0.0f;
    private transient boolean isPaused = false;
    private MusicVolumeTween volumeTween;
    public static float VOLUME_MULTIPLIER = 1.0f;
    private final Timer.Task backgroundLoadingTask = new Timer.Task(){

        public void run() {
            if (!EngineAssetManager.getInstance().isLoading()) {
                this.cancel();
                MusicManager.this.retrieveAssets();
            }
        }
    };

    public void playMusic() {
        if (this.music != null && !this.music.isPlaying()) {
            try {
                this.music.play();
                this.music.setLooping(this.desc.isLoop());
                this.music.setVolume(this.desc.getVolume() * VOLUME_MULTIPLIER);
            }
            catch (Exception e) {
                if (Gdx.app.getType() == Application.ApplicationType.Desktop && e.getMessage().contains("40963")) {
                    EngineLogger.debug("!!!!!!!!!!!!!!!!!!!!!!!ERROR playing music trying again...!!!!!!!!!!!!!!!");
                    this.setMusic(this.desc);
                    return;
                }
                EngineLogger.error("Error Playing music: " + this.desc.getFilename(), e);
            }
        }
    }

    public void pauseMusic() {
        if (this.music != null && this.music.isPlaying()) {
            this.music.pause();
            this.isPaused = true;
        }
    }

    public void resumeMusic() {
        if (this.music != null && this.isPaused) {
            this.music.play();
            this.isPaused = false;
        }
    }

    public void stopMusic() {
        if (this.music != null) {
            this.music.stop();
        }
    }

    public void setMusic(MusicDesc d) {
        if (this.desc != null && d != null && d.getFilename() != null && d.getFilename().equals(this.desc.getFilename())) {
            EngineLogger.debug(">>>NOT SETTING MUSIC: This music file is already playing.");
            return;
        }
        EngineLogger.debug(">>>SETTING MUSIC.");
        this.stopMusic();
        this.volumeTween = null;
        this.currentMusicDelay = 0.0f;
        if (d != null) {
            if (this.desc != null) {
                this.dispose();
            }
            this.desc = new MusicDesc(d);
            this.loadTask();
        } else {
            this.dispose();
            this.desc = null;
        }
    }

    private void loadTask() {
        this.loadAssets();
        this.backgroundLoadingTask.cancel();
        Timer.schedule((Timer.Task)this.backgroundLoadingTask, (float)0.0f, (float)0.0f);
    }

    public void setVolume(float volume) {
        if (this.desc != null) {
            this.desc.setVolume(volume);
        }
        if (this.music != null && this.music.isPlaying()) {
            this.music.setVolume(volume);
        }
    }

    public float getVolume() {
        if (this.desc != null) {
            return this.desc.getVolume();
        }
        return 1.0f;
    }

    public void leaveScene(MusicDesc newMusicDesc) {
        if (this.desc != null && !this.desc.isStopWhenLeaving() && (newMusicDesc == null || newMusicDesc.getFilename().equals(this.desc.getFilename()))) {
            return;
        }
        if (this.desc != null) {
            this.currentMusicDelay = 0.0f;
            this.stopMusic();
            this.dispose();
        }
        this.desc = newMusicDesc != null ? new MusicDesc(newMusicDesc) : null;
    }

    public void update(float delta) {
        if (this.music != null) {
            if (!this.music.isPlaying()) {
                boolean initialTime = false;
                if (this.currentMusicDelay <= this.desc.getInitialDelay()) {
                    initialTime = true;
                }
                this.currentMusicDelay += delta;
                if (initialTime) {
                    if (this.currentMusicDelay > this.desc.getInitialDelay()) {
                        this.playMusic();
                    }
                } else if (this.desc.getRepeatDelay() >= 0.0f && this.currentMusicDelay > this.desc.getRepeatDelay() + this.desc.getInitialDelay()) {
                    this.currentMusicDelay = this.desc.getInitialDelay();
                    this.playMusic();
                }
            }
            if (this.volumeTween != null) {
                this.volumeTween.update(delta);
                if (this.volumeTween != null && this.volumeTween.isComplete()) {
                    this.volumeTween = null;
                }
            }
        }
    }

    public void dispose() {
        if (this.music != null) {
            EngineLogger.debug("DISPOSING MUSIC: " + this.desc.getFilename());
            EngineAssetManager.getInstance().disposeMusic(this.desc.getFilename());
            this.music = null;
            this.desc = null;
            this.volumeTween = null;
        }
    }

    @Override
    public void loadAssets() {
        if (this.music == null && this.desc != null) {
            EngineLogger.debug("LOADING MUSIC: " + this.desc.getFilename());
            EngineAssetManager.getInstance().loadMusic(this.desc.getFilename());
        }
    }

    @Override
    public void retrieveAssets() {
        if (this.music == null && this.desc != null) {
            if (!EngineAssetManager.getInstance().isLoaded("music/" + this.desc.getFilename())) {
                this.loadTask();
                return;
            }
            EngineLogger.debug("RETRIEVING MUSIC: " + this.desc.getFilename());
            this.music = EngineAssetManager.getInstance().getMusic(this.desc.getFilename());
            if (this.isPlayingSer) {
                this.playMusic();
                if (this.music != null) {
                    this.music.setPosition(this.musicPosSer);
                    this.musicPosSer = 0.0f;
                }
                this.isPlayingSer = false;
            }
        }
    }

    public void fade(float volume, float duration, ActionCallback cb) {
        if (this.music != null) {
            this.volumeTween = new MusicVolumeTween();
            this.volumeTween.start(this, volume, duration, InterpolationMode.FADE, cb);
        } else if (cb != null) {
            cb.resume();
        }
    }

    public void write(Json json) {
        json.writeValue("desc", (Object)this.desc);
        json.writeValue("currentMusicDelay", (Object)Float.valueOf(this.currentMusicDelay));
        json.writeValue("isPlaying", (Object)(this.music != null && (this.music.isPlaying() || this.isPaused) ? 1 : 0));
        json.writeValue("musicPos", (Object)Float.valueOf(this.music != null && (this.music.isPlaying() || this.isPaused) ? this.music.getPosition() : 0.0f));
        if (this.volumeTween != null) {
            json.writeValue("volumeTween", (Object)this.volumeTween);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.desc = (MusicDesc)json.readValue("desc", MusicDesc.class, jsonData);
        this.currentMusicDelay = ((Float)json.readValue("currentMusicDelay", Float.TYPE, jsonData)).floatValue();
        this.isPlayingSer = (Boolean)json.readValue("isPlaying", Boolean.TYPE, jsonData);
        this.musicPosSer = ((Float)json.readValue("musicPos", Float.TYPE, jsonData)).floatValue();
        this.volumeTween = (MusicVolumeTween)json.readValue("volumeTween", MusicVolumeTween.class, jsonData);
        if (this.volumeTween != null) {
            this.volumeTween.setTarget(this);
        }
    }
}

