/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.PolygonUtils;

public class ObstacleActor
extends BaseActor {
    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.scene != null && this.scene.getPolygonalNavGraph() != null) {
            if (visible) {
                this.scene.getPolygonalNavGraph().addDinamicObstacle(this.bbox);
            } else {
                this.scene.getPolygonalNavGraph().removeDinamicObstacle(this.bbox);
            }
        }
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void setPosition(float x, float y) {
        boolean inNavGraph = false;
        if (this.scene != null && this.scene.getPolygonalNavGraph() != null) {
            inNavGraph = this.scene.getPolygonalNavGraph().removeDinamicObstacle(this.bbox);
        }
        this.bbox.setPosition(x, y);
        if (inNavGraph) {
            this.scene.getPolygonalNavGraph().addDinamicObstacle(this.bbox);
        }
    }

    @Override
    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            PolygonUtils.ensureClockWise(this.bbox.getVertices(), 0, this.bbox.getVertices().length);
            this.bbox.dirty();
        }
        super.write(json);
    }
}

