/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.RectangleRenderer;

public class ParticleRenderer
implements ActorRenderer {
    private static final float DEFAULT_DIM = 100.0f;
    private final ParticleEffect effect = new ParticleEffect();
    private float lastAnimationTime = 0.0f;
    private Polygon bbox;
    private String particleName;
    private String atlasName;
    private TextureAtlas atlasTex;
    private float tmpPosX = 0.0f;
    private float tmpPosY = 0.0f;
    private static final Matrix4 tmp = new Matrix4();
    private int orgAlign = 4;

    public void reset() {
        this.tmpPosY = 0.0f;
        this.tmpPosX = 0.0f;
        this.effect.reset();
    }

    @Override
    public int getOrgAlign() {
        return this.orgAlign;
    }

    @Override
    public void setOrgAlign(int align) {
        this.orgAlign = align;
    }

    @Override
    public void update(float delta) {
        try {
            this.effect.update(delta);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void draw(SpriteBatch batch, float x, float y, float scaleX, float scaleY, float rotation, Color tint) {
        float finalScaleX = EngineAssetManager.getInstance().getScale() * scaleX;
        float finalScaleY = EngineAssetManager.getInstance().getScale() * scaleY;
        if (this.effect.getEmitters().size > 0) {
            Matrix4 tm = batch.getTransformMatrix();
            tmp.set(tm);
            if (this.tmpPosX != x / finalScaleX || this.tmpPosY != y / finalScaleY) {
                this.tmpPosX = x / finalScaleX;
                this.tmpPosY = y / finalScaleY;
                this.effect.setPosition(this.tmpPosX, this.tmpPosY);
            }
            tm.rotate(0.0f, 0.0f, 1.0f, rotation).scale(finalScaleX, finalScaleY, 1.0f);
            batch.setTransformMatrix(tm);
            if (tint != null) {
                batch.setColor(tint);
            }
            this.effect.draw((Batch)batch);
            if (tint != null) {
                batch.setColor(Color.WHITE);
            }
            batch.setTransformMatrix(tmp);
        } else {
            RectangleRenderer.draw((Batch)batch, x -= this.getWidth() / 2.0f * finalScaleX, y, this.getWidth() * finalScaleX, this.getHeight() * finalScaleY, Color.RED);
        }
    }

    @Override
    public float getWidth() {
        return 100.0f;
    }

    @Override
    public float getHeight() {
        return 100.0f;
    }

    public String getParticleName() {
        return this.particleName;
    }

    public void setParticleName(String particleName) {
        this.particleName = particleName;
    }

    public String getAtlasName() {
        return this.atlasName;
    }

    public void setAtlasName(String atlasName) {
        this.atlasName = atlasName;
    }

    @Override
    public void updateBboxFromRenderer(Polygon bbox) {
        this.bbox = bbox;
        this.computeBbox();
    }

    private void computeBbox() {
        if (this.bbox == null) {
            return;
        }
        if (this.bbox.getVertices() == null || this.bbox.getVertices().length != 8) {
            this.bbox.setVertices(new float[8]);
        }
        float[] verts = this.bbox.getVertices();
        verts[0] = -this.getWidth() / 2.0f;
        verts[1] = 0.0f;
        verts[2] = -this.getWidth() / 2.0f;
        verts[3] = this.getHeight();
        verts[4] = this.getWidth() / 2.0f;
        verts[5] = this.getHeight();
        verts[6] = this.getWidth() / 2.0f;
        verts[7] = 0.0f;
        this.bbox.dirty();
    }

    @Override
    public void loadAssets() {
        EngineAssetManager.getInstance().loadAtlas(this.getAtlasName());
    }

    @Override
    public void retrieveAssets() {
        if (!EngineAssetManager.getInstance().isAtlasLoaded(this.atlasName)) {
            this.loadAssets();
            EngineAssetManager.getInstance().finishLoading();
        }
        this.atlasTex = EngineAssetManager.getInstance().getTextureAtlas(this.getAtlasName());
        this.effect.load(EngineAssetManager.getInstance().getParticle(this.getParticleName()), this.atlasTex);
        this.effect.start();
        this.tmpPosX = Float.MAX_VALUE;
        this.effect.update(this.lastAnimationTime);
        this.computeBbox();
    }

    public void dispose() {
        EngineAssetManager.getInstance().disposeAtlas(this.getAtlasName());
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("atlasName", (Object)this.getAtlasName());
            json.writeValue("particleName", (Object)this.getParticleName());
            json.writeValue("orgAlign", (Object)this.orgAlign);
        } else {
            json.writeValue("lastAnimationTime", (Object)Float.valueOf(this.lastAnimationTime));
        }
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.setAtlasName((String)json.readValue("atlasName", String.class, jsonData));
            this.setParticleName((String)json.readValue("particleName", String.class, jsonData));
            this.orgAlign = (Integer)json.readValue("orgAlign", Integer.TYPE, (Object)4, jsonData);
        } else {
            this.lastAnimationTime = ((Float)json.readValue("lastAnimationTime", Float.class, jsonData)).floatValue();
        }
    }
}

