/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.SpriteActor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SceneLayer {
    private String name;
    private boolean visible = true;
    private boolean dynamic;
    private float parallax = 1.0f;
    private final transient List<InteractiveActor> actors = new ArrayList<InteractiveActor>();

    public void update() {
        if (this.dynamic && this.visible) {
            Collections.sort(this.actors);
        }
    }

    public void draw(SpriteBatch spriteBatch) {
        if (!this.visible) {
            return;
        }
        for (BaseActor baseActor : this.actors) {
            if (!(baseActor instanceof SpriteActor)) continue;
            ((SpriteActor)baseActor).draw(spriteBatch);
        }
    }

    public void add(InteractiveActor actor) {
        this.actors.add(actor);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public List<InteractiveActor> getActors() {
        return this.actors;
    }

    public void orderByZIndex() {
        Collections.sort(this.actors, new Comparator<InteractiveActor>(){

            @Override
            public int compare(InteractiveActor a1, InteractiveActor a2) {
                return (int)(a1.getZIndex() - a2.getZIndex());
            }
        });
    }

    public boolean remove(BaseActor actor) {
        return this.actors.remove(actor);
    }

    public float getParallaxMultiplier() {
        return this.parallax;
    }

    public void setParallaxMultiplier(float parallaxMultiplier) {
        this.parallax = parallaxMultiplier;
    }
}

