/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VoiceManager;
import com.bladecoder.engine.util.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;

public class TextManager
implements Json.Serializable {
    public static final float POS_CENTER = -1.0f;
    public static final float POS_SUBTITLE = -2.0f;
    public static final float RECT_MARGIN = 18.0f;
    public static final float RECT_BORDER = 2.0f;
    public static final boolean AUTO_HIDE_TEXTS = Config.getProperty("auto_hide_texts", true);
    private float inScreenTime;
    private Text currentText = null;
    private final VoiceManager voiceManager = new VoiceManager(this);
    private Queue<Text> fifo = new LinkedList<Text>();
    private Scene scene;
    private String previousCharacterAnim = null;

    public TextManager(Scene s) {
        this.scene = s;
    }

    public void addText(String str, float x, float y, boolean queue, Text.Type type, Color color, String font, String actorId, String voiceId, String talkAnimation, ActionCallback cb) {
        if (str.charAt(0) == '@') {
            str = I18N.getString(str.substring(1));
        }
        String s = str.replace("\\n", "\n");
        if (type == Text.Type.UI && this.scene.getWorld().getListener() != null) {
            Text t = new Text(s, x, y, 0.0f, type, color, font, actorId, voiceId, talkAnimation, null);
            this.scene.getWorld().getListener().text(t);
            if (cb != null) {
                ActionCallback tmpcb = cb;
                cb = null;
                tmpcb.resume();
            }
            return;
        }
        String[] text = s.split("\n\n");
        int nQueued = this.fifo.size();
        String lineVoiceId = voiceId;
        for (int i = 0; i < text.length; ++i) {
            String cutStr = text[i];
            float duration = 0.0f;
            String finalStr = cutStr;
            int idx = cutStr.indexOf(35);
            if (idx != -1) {
                String prefix = cutStr.substring(0, idx);
                if (prefix.charAt(0) == 'v') {
                    lineVoiceId = prefix.substring(1).trim();
                } else {
                    duration = Float.parseFloat(prefix);
                }
                finalStr = cutStr.substring(idx + 1);
            }
            Text sub = new Text(finalStr, x, y, duration, type, color, font, actorId, lineVoiceId, talkAnimation, i == text.length - 1 ? cb : null);
            lineVoiceId = null;
            this.fifo.add(sub);
        }
        if (!queue) {
            this.clear(nQueued);
        }
        if (!queue || this.currentText == null) {
            if (this.currentText != null) {
                this.next();
            } else {
                this.setCurrentText(this.fifo.poll());
            }
        }
    }

    public VoiceManager getVoiceManager() {
        return this.voiceManager;
    }

    public Text getCurrentText() {
        return this.currentText;
    }

    private void setCurrentText(Text t) {
        CharacterActor a;
        if (this.currentText != null && this.currentText.type == Text.Type.TALK && this.currentText.actorId != null) {
            a = (CharacterActor)this.scene.getActor(this.currentText.actorId, false);
            a.startAnimation(this.previousCharacterAnim, Tween.Type.SPRITE_DEFINED, 0, null);
            this.previousCharacterAnim = null;
        }
        this.inScreenTime = 0.0f;
        this.currentText = t;
        if (t != null) {
            this.voiceManager.play(t.voiceId);
            if (t.type == Text.Type.TALK && t.actorId != null) {
                a = (CharacterActor)this.scene.getActor(t.actorId, false);
                this.previousCharacterAnim = ((AnimationRenderer)a.getRenderer()).getCurrentAnimationId();
                if (t.animation != null) {
                    a.startAnimation(t.animation, Tween.Type.SPRITE_DEFINED, 0, null);
                } else {
                    a.talk();
                }
            }
        } else {
            this.voiceManager.stop();
        }
        if (this.scene.getWorld().getListener() != null) {
            this.scene.getWorld().getListener().text(t);
        }
    }

    public void update(float delta) {
        if (this.currentText == null) {
            return;
        }
        this.inScreenTime += delta;
        if (this.inScreenTime > this.currentText.time && AUTO_HIDE_TEXTS) {
            this.next();
        }
    }

    public void next() {
        if (this.currentText != null) {
            Text t = this.currentText;
            this.setCurrentText(this.fifo.poll());
            t.callCb();
        }
    }

    private void clear(int n) {
        for (int i = 0; i < n; ++i) {
            this.next();
        }
        this.inScreenTime = 0.0f;
        this.voiceManager.stop();
    }

    public void reset() {
        this.fifo.clear();
        this.setCurrentText(null);
    }

    public void write(Json json) {
        json.writeValue("inScreenTime", (Object)Float.valueOf(this.inScreenTime));
        if (this.currentText != null) {
            json.writeValue("currentText", (Object)this.currentText);
        }
        json.writeValue("fifo", new ArrayList<Text>(this.fifo), ArrayList.class, Text.class);
        json.writeValue("voiceManager", (Object)this.voiceManager);
        if (this.previousCharacterAnim != null) {
            json.writeValue("previousAnim", (Object)this.previousCharacterAnim);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.inScreenTime = ((Float)json.readValue("inScreenTime", Float.class, jsonData)).floatValue();
        this.currentText = (Text)json.readValue("currentText", Text.class, jsonData);
        this.fifo = new LinkedList<Text>((Collection)json.readValue("fifo", ArrayList.class, Text.class, jsonData));
        this.previousCharacterAnim = (String)json.readValue("previousAnim", String.class, jsonData);
        JsonValue jsonValue = jsonData.get("voiceManager");
        if (jsonValue != null) {
            this.voiceManager.read(json, jsonValue);
        }
    }
}

