/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.RectangleRenderer;

public class Transition
implements Json.Serializable {
    private float time;
    private float currentTime;
    private ActionCallback cb;
    private Color c;
    private Type type = Type.NONE;

    public void update(float delta) {
        if (this.isFinish()) {
            if (this.type == Type.FADE_IN) {
                this.reset();
            }
            if (this.cb != null) {
                ActionCallback tmpcb = this.cb;
                this.cb = null;
                tmpcb.resume();
            }
        } else {
            this.currentTime += delta;
        }
    }

    public void reset() {
        this.type = Type.NONE;
    }

    public void draw(SpriteBatch batch, float width, float height) {
        if (this.type == Type.NONE) {
            return;
        }
        switch (this.type) {
            case FADE_IN: {
                this.c.a = MathUtils.clamp((float)Interpolation.fade.apply(1.0f - this.currentTime / this.time), (float)0.0f, (float)1.0f);
                break;
            }
            case FADE_OUT: {
                this.c.a = MathUtils.clamp((float)Interpolation.fade.apply(this.currentTime / this.time), (float)0.0f, (float)1.0f);
                break;
            }
        }
        RectangleRenderer.draw((Batch)batch, 0.0f, 0.0f, width, height, this.c);
    }

    public void create(float time, Color color, Type type, ActionCallback cb) {
        this.currentTime = 0.0f;
        this.c = color.cpy();
        this.type = type;
        this.time = time;
        this.cb = cb;
    }

    public boolean isFinish() {
        return this.currentTime > this.time || this.type == Type.NONE;
    }

    public void write(Json json) {
        json.writeValue("currentTime", (Object)Float.valueOf(this.currentTime));
        json.writeValue("time", (Object)Float.valueOf(this.time));
        json.writeValue("color", (Object)this.c);
        json.writeValue("type", (Object)this.type);
        if (this.cb != null) {
            json.writeValue("cb", (Object)ActionCallbackSerializer.find(((BladeJson)json).getWorld(), this.cb));
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.currentTime = ((Float)json.readValue("currentTime", Float.class, jsonData)).floatValue();
        this.time = ((Float)json.readValue("time", Float.class, jsonData)).floatValue();
        this.c = (Color)json.readValue("color", Color.class, jsonData);
        this.type = (Type)((Object)json.readValue("type", Type.class, jsonData));
        this.cb = ActionCallbackSerializer.find(((BladeJson)json).getWorld(), (String)json.readValue("cb", String.class, jsonData));
    }

    public static enum Type {
        NONE,
        FADE_IN,
        FADE_OUT;

    }
}

