/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SceneCamera;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.World;
import java.util.ArrayList;
import java.util.List;

public class UIActors
implements AssetConsumer,
Json.Serializable {
    private ArrayList<InteractiveActor> actors = new ArrayList(0);
    private transient boolean disposed = true;
    private SceneCamera cam;
    private World w;
    private final Vector3 unprojectTmp = new Vector3();

    public UIActors(World w) {
        this.w = w;
    }

    public void addActor(InteractiveActor a) {
        this.actors.add(a);
    }

    public InteractiveActor removeActor(String id) {
        for (int i = 0; i < this.actors.size(); ++i) {
            InteractiveActor a = this.actors.get(i);
            if (!a.getId().equals(id)) continue;
            this.actors.remove(i);
            return a;
        }
        return null;
    }

    public InteractiveActor get(String actorId) {
        for (InteractiveActor a : this.actors) {
            if (!a.getId().equals(actorId)) continue;
            return a;
        }
        return null;
    }

    public List<InteractiveActor> getActors() {
        return this.actors;
    }

    public void update(float delta) {
        for (InteractiveActor a : this.actors) {
            a.update(delta);
        }
    }

    public void draw(SpriteBatch batch) {
        batch.setProjectionMatrix(this.cam.combined);
        batch.begin();
        for (InteractiveActor a : this.actors) {
            if (!(a instanceof SpriteActor) || !a.isVisible() || ((SpriteActor)a).getScale() == 0.0f) continue;
            ((SpriteActor)a).getRenderer().draw(batch, a.getX(), a.getY(), ((SpriteActor)a).getScaleX(), ((SpriteActor)a).getScaleY(), ((SpriteActor)a).getRot(), ((SpriteActor)a).getTint());
        }
        batch.end();
    }

    public InteractiveActor getActorAtInput(Viewport v) {
        this.cam.getInputUnProject(v, this.unprojectTmp);
        for (InteractiveActor uia : this.actors) {
            if (!uia.canInteract() || !uia.hit(this.unprojectTmp.x, this.unprojectTmp.y)) continue;
            return uia;
        }
        return null;
    }

    @Override
    public void loadAssets() {
        for (InteractiveActor a : this.actors) {
            if (!(a instanceof SpriteActor)) continue;
            ((AssetConsumer)((Object)a)).loadAssets();
        }
    }

    @Override
    public void retrieveAssets() {
        for (InteractiveActor a : this.actors) {
            if (!(a instanceof SpriteActor)) continue;
            ((AssetConsumer)((Object)a)).retrieveAssets();
        }
        this.cam = new SceneCamera();
        this.cam.create(this.w.getWidth(), this.w.getHeight());
        this.disposed = false;
    }

    public void dispose() {
        for (InteractiveActor a : this.actors) {
            if (!(a instanceof SpriteActor)) continue;
            ((Disposable)a).dispose();
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void write(Json json) {
        json.writeObjectStart("actors");
        for (InteractiveActor a : this.actors) {
            SceneActorRef actorRef = new SceneActorRef(a.getInitScene(), a.getId());
            json.writeValue(actorRef.toString(), (Object)a);
        }
        json.writeObjectEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        SceneActorRef actorRef;
        JsonValue jsonValueAct;
        int i;
        this.actors.clear();
        JsonValue jsonValueActors = jsonData.get("actors");
        for (i = 0; i < jsonValueActors.size; ++i) {
            jsonValueAct = jsonValueActors.get(i);
            actorRef = new SceneActorRef(jsonValueAct.name);
            Scene sourceScn = this.w.getScene(actorRef.getSceneId());
            BaseActor actor = sourceScn.getActor(actorRef.getActorId(), false);
            sourceScn.removeActor(actor);
            this.addActor((InteractiveActor)actor);
        }
        for (i = 0; i < jsonValueActors.size; ++i) {
            jsonValueAct = jsonValueActors.get(i);
            actorRef = new SceneActorRef(jsonValueAct.name);
            InteractiveActor actor = this.actors.get(i);
            actor.read(json, jsonValueAct);
        }
    }
}

