/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.serialization;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.ink.InkManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.UIActors;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

public class ActionCallbackSerializer {
    private static final String SEPARATION_SYMBOL = "#";
    private static final String INK_MANAGER_TAG = "INK_MANAGER";
    private static final String UIACTORS_TAG = "UIACTORS";
    private static final String INVENTORY_TAG = "INVENTORY";
    private static final String DEFAULT_VERB_TAG = "DEFAULT_VERB";

    private static String find(ActionCallback cb, Verb v) {
        String id = v.getHashKey();
        if (cb == v) {
            return id;
        }
        int pos = 0;
        for (Action a : v.getActions()) {
            if (cb == a) {
                StringBuilder stringBuilder = new StringBuilder(id);
                stringBuilder.append(SEPARATION_SYMBOL).append(pos);
                return stringBuilder.toString();
            }
            ++pos;
        }
        return null;
    }

    private static String find(ActionCallback cb, InteractiveActor a) {
        if (a == null) {
            return null;
        }
        String id = a.getId();
        for (Verb v : a.getVerbManager().getVerbs().values()) {
            String result = ActionCallbackSerializer.find(cb, v);
            if (result == null) continue;
            StringBuilder stringBuilder = new StringBuilder(id);
            stringBuilder.append(SEPARATION_SYMBOL).append(result);
            return stringBuilder.toString();
        }
        return null;
    }

    private static String find(ActionCallback cb, Scene s) {
        if (s == null) {
            return null;
        }
        String id = s.getId();
        for (Verb v : s.getVerbManager().getVerbs().values()) {
            String result = ActionCallbackSerializer.find(cb, v);
            if (result == null) continue;
            StringBuilder stringBuilder = new StringBuilder(id);
            stringBuilder.append(SEPARATION_SYMBOL).append(result);
            return stringBuilder.toString();
        }
        return null;
    }

    private static String find(ActionCallback cb, InkManager im) {
        if (im == null) {
            return null;
        }
        if (cb instanceof InkManager) {
            return INK_MANAGER_TAG;
        }
        int pos = 0;
        for (Action a : im.getActions()) {
            if (cb == a) {
                StringBuilder stringBuilder = new StringBuilder(INK_MANAGER_TAG);
                stringBuilder.append(SEPARATION_SYMBOL).append(pos);
                return stringBuilder.toString();
            }
            ++pos;
        }
        return null;
    }

    private static String find(ActionCallback cb, UIActors uia) {
        if (uia == null) {
            return null;
        }
        for (InteractiveActor a : uia.getActors()) {
            String id = ActionCallbackSerializer.find(cb, a);
            if (id == null) continue;
            StringBuilder stringBuilder = new StringBuilder(UIACTORS_TAG);
            stringBuilder.append(SEPARATION_SYMBOL).append(id);
            return stringBuilder.toString();
        }
        return null;
    }

    private static String find(ActionCallback cb, Inventory inv) {
        for (int i = 0; i < inv.getNumItems(); ++i) {
            SpriteActor a = inv.get(i);
            String id = ActionCallbackSerializer.find(cb, a);
            if (id == null) continue;
            StringBuilder stringBuilder = new StringBuilder(INVENTORY_TAG);
            stringBuilder.append(SEPARATION_SYMBOL).append(id);
            return stringBuilder.toString();
        }
        return null;
    }

    public static String find(World w, ActionCallback cb) {
        String id = null;
        if (cb == null) {
            return null;
        }
        id = ActionCallbackSerializer.find(cb, w.getUIActors());
        if (id != null) {
            return id;
        }
        id = ActionCallbackSerializer.find(cb, w.getInventory());
        if (id != null) {
            return id;
        }
        id = ActionCallbackSerializer.find(cb, w.getInkManager());
        if (id != null) {
            return id;
        }
        Scene s = w.getCurrentScene();
        id = ActionCallbackSerializer.find(cb, s);
        if (id != null) {
            return id;
        }
        id = ActionCallbackSerializer.find(cb, s.getPlayer());
        if (id != null) {
            return id;
        }
        for (BaseActor a : s.getActors().values()) {
            if (!(a instanceof InteractiveActor) || (id = ActionCallbackSerializer.find(cb, (InteractiveActor)a)) == null) continue;
            return id;
        }
        for (Verb v : w.getVerbManager().getVerbs().values()) {
            id = ActionCallbackSerializer.find(cb, v);
            if (id == null) continue;
            StringBuilder stringBuilder = new StringBuilder(DEFAULT_VERB_TAG);
            stringBuilder.append(SEPARATION_SYMBOL).append(id);
            return stringBuilder.toString();
        }
        return null;
    }

    public static ActionCallback find(World w, String id) {
        String verbId;
        String actorId;
        if (id == null) {
            return null;
        }
        Scene s = w.getCurrentScene();
        String[] split = id.split(SEPARATION_SYMBOL);
        if (id.startsWith(INK_MANAGER_TAG)) {
            if (split.length == 1) {
                return w.getInkManager();
            }
            int actionPos = Integer.parseInt(split[1]);
            Action action = w.getInkManager().getActions().get(actionPos);
            if (action instanceof ActionCallback) {
                return (ActionCallback)((Object)action);
            }
        }
        if (split.length < 2) {
            return null;
        }
        int actionPos = -1;
        if (id.startsWith(UIACTORS_TAG) || id.startsWith(INVENTORY_TAG)) {
            actorId = split[1];
            verbId = split[2];
            if (split.length > 3) {
                actionPos = Integer.parseInt(split[3]);
            }
        } else {
            actorId = split[0];
            verbId = split[1];
            if (split.length > 2) {
                actionPos = Integer.parseInt(split[2]);
            }
        }
        Verb v = null;
        if (actorId.equals(DEFAULT_VERB_TAG)) {
            v = w.getVerbManager().getVerb(verbId, null, null);
        } else if (actorId.equals(s.getId())) {
            v = s.getVerbManager().getVerbs().get(verbId);
        } else {
            InteractiveActor a = (InteractiveActor)s.getActor(actorId, true);
            if (a == null) {
                EngineLogger.error("ActionCallbackSerialization - Actor not found: " + actorId + " cb: " + id);
                return null;
            }
            v = a.getVerbManager().getVerbs().get(verbId);
        }
        if (v == null) {
            EngineLogger.error("ActionCallbackSerialization - Verb not found: " + verbId + " cb: " + id);
            return null;
        }
        if (actionPos == -1) {
            return v;
        }
        Action action = v.getActions().get(actionPos);
        if (action instanceof ActionCallback) {
            return (ActionCallback)((Object)action);
        }
        EngineLogger.error("ActionCallbackSerialization - CB not found: " + id);
        return null;
    }
}

