/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Timer;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.DPIUtils;
import java.util.List;

public class DialogUI
extends ScrollPane {
    public static final String DIALOG_END_COMMAND = "dialog_end";
    private DialogUIStyle style;
    private Recorder recorder;
    private Table panel;
    private Button up;
    private Button down;
    private List<String> choices;
    private final UI ui;

    public DialogUI(UI ui) {
        super((Actor)new Table(ui.getSkin()), ui.getSkin());
        this.ui = ui;
        this.setFadeScrollBars(true);
        this.setOverscroll(false, false);
        this.up = new Button(ui.getSkin(), "dialog-up");
        this.down = new Button(ui.getSkin(), "dialog-down");
        this.panel = (Table)this.getActor();
        this.style = (DialogUIStyle)ui.getSkin().get(DialogUIStyle.class);
        this.recorder = ui.getRecorder();
        if (this.style.background != null) {
            this.panel.setBackground(this.style.background);
        }
        this.panel.top().left();
        this.panel.pad(DPIUtils.getMarginSize());
        this.setVisible(false);
        this.panel.defaults().expandX().fillX().top().left().padBottom(DPIUtils.getSpacing());
        this.addListener(new EventListener(){

            public boolean handle(Event event) {
                DialogUI.this.setUpDownVisibility();
                return false;
            }
        });
        this.up.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                DialogUI.this.setScrollY(DialogUI.this.getScrollY() - DPIUtils.getPrefButtonSize());
            }
        });
        this.down.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                DialogUI.this.setScrollY(DialogUI.this.getScrollY() + DPIUtils.getPrefButtonSize());
            }
        });
    }

    private void setUpDownVisibility() {
        if (this.isScrollY()) {
            if (this.getScrollPercentY() > 0.0f && !this.up.isVisible()) {
                this.up.setVisible(true);
            } else if (this.getScrollPercentY() == 0.0f && this.up.isVisible()) {
                this.up.setVisible(false);
            }
            if (this.getScrollPercentY() < 1.0f && !this.down.isVisible()) {
                this.down.setVisible(true);
            } else if (this.getScrollPercentY() == 1.0f && this.down.isVisible()) {
                this.down.setVisible(false);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getParent() != null) {
                this.show();
            }
        } else {
            this.up.remove();
            this.down.remove();
        }
    }

    private void show() {
        this.choices = this.ui.getWorld().getDialogOptions();
        if (this.choices.size() == 0) {
            return;
        }
        if (this.style.autoselect && this.choices.size() == 1) {
            Timer.post((Timer.Task)new Timer.Task(){

                public void run() {
                    DialogUI.this.select(0);
                }
            });
            return;
        }
        this.panel.clear();
        for (int i = 0; i < this.choices.size(); ++i) {
            String str = this.choices.get(i);
            if (str.charAt(0) == '@') {
                str = I18N.getString(str.substring(1));
            }
            TextButton ob = new TextButton(str, this.style.textButtonStyle);
            ob.setUserObject((Object)i);
            this.panel.row();
            this.panel.add((Actor)ob);
            ob.getLabel().setWrap(true);
            ob.getLabel().setAlignment(8);
            ob.addListener((EventListener)new ClickListener(){

                public void clicked(InputEvent event, float x, float y) {
                    int i = (Integer)event.getListenerActor().getUserObject();
                    DialogUI.this.select(i);
                }
            });
        }
        this.panel.pack();
        this.setWidth(this.getStage().getViewport().getScreenWidth());
        this.setHeight(Math.min(this.panel.getHeight(), (float)(this.getStage().getViewport().getScreenHeight() / 2)));
        float size = DPIUtils.getPrefButtonSize() * 0.8f;
        float margin = DPIUtils.getSpacing();
        this.getStage().addActor((Actor)this.up);
        this.up.setSize(size, size);
        this.up.setPosition(this.getX() + this.getWidth() - size - margin, this.getY() + this.getHeight() - margin - size);
        this.up.setVisible(false);
        this.getStage().addActor((Actor)this.down);
        this.down.setSize(size, size);
        this.down.setPosition(this.getX() + this.getWidth() - size - margin, this.getY() + margin);
        this.down.setVisible(false);
        this.setUpDownVisibility();
    }

    private void select(int i) {
        if (this.recorder.isRecording()) {
            this.recorder.add(i);
        }
        this.ui.getWorld().selectDialogOption(i);
        this.setVisible(false);
    }

    public static class DialogUIStyle {
        public Drawable background;
        public TextButton.TextButtonStyle textButtonStyle;
        public boolean autoselect = true;

        public DialogUIStyle() {
        }

        public DialogUIStyle(DialogUIStyle style) {
            this.background = style.background;
            this.textButtonStyle = style.textButtonStyle;
            this.autoselect = style.autoselect;
        }
    }
}

