/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.PagedScrollPane;
import com.bladecoder.engine.ui.Pointer;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class LoadSaveScreen
extends ScreenAdapter
implements BladeScreen {
    private static final int ROW_SLOTS = 3;
    private static final int COL_SLOTS = 2;
    private UI ui;
    private Stage stage;
    private Texture bgTexFile = null;
    private boolean loadScreenMode = true;
    private int slotWidth = 0;
    private int slotHeight = 0;
    private final ArrayList<Texture> textureList = new ArrayList();
    private Pointer pointer;
    private ClickListener loadClickListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            final World world = LoadSaveScreen.this.ui.getWorld();
            final String filename = event.getListenerActor().getName() + ".gamestate.v13";
            if (world.savedGameExists()) {
                Dialog d = new Dialog("", LoadSaveScreen.this.ui.getSkin()){

                    protected void result(Object object) {
                        if (((Boolean)object).booleanValue()) {
                            try {
                                world.loadGameState(filename);
                                LoadSaveScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                            }
                            catch (IOException e) {
                                EngineLogger.error(e.getMessage());
                            }
                        }
                    }
                };
                d.pad(DPIUtils.getMarginSize());
                d.getButtonTable().padTop(DPIUtils.getMarginSize());
                d.getButtonTable().defaults().padLeft(DPIUtils.getMarginSize()).padRight(DPIUtils.getMarginSize());
                Label l = new Label((CharSequence)I18N.getString("ui.override_load"), LoadSaveScreen.this.ui.getSkin(), "ui-dialog");
                l.setWrap(true);
                l.setAlignment(1);
                d.getContentTable().add((Actor)l).prefWidth((float)Gdx.graphics.getWidth() * 0.7f);
                d.button(I18N.getString("ui.yes"), (Object)true, (TextButton.TextButtonStyle)LoadSaveScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
                d.button(I18N.getString("ui.no"), (Object)false, (TextButton.TextButtonStyle)LoadSaveScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
                d.key(66, (Object)true).key(131, (Object)false);
                d.show(LoadSaveScreen.this.stage);
            } else {
                try {
                    world.loadGameState(filename);
                    LoadSaveScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
                catch (IOException e) {
                    EngineLogger.error(e.getMessage());
                }
            }
        }
    };
    private ClickListener removeClickListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            final Actor listenerActor = event.getListenerActor();
            Dialog d = new Dialog("", LoadSaveScreen.this.ui.getSkin()){

                protected void result(Object object) {
                    if (((Boolean)object).booleanValue()) {
                        World world = LoadSaveScreen.this.ui.getWorld();
                        String filename = listenerActor.getName() + ".gamestate.v13";
                        try {
                            world.removeGameState(filename);
                            listenerActor.getParent().getParent().getParent().removeActor((Actor)listenerActor.getParent().getParent());
                        }
                        catch (IOException e) {
                            EngineLogger.error(e.getMessage());
                        }
                    }
                }
            };
            d.pad(DPIUtils.getMarginSize());
            d.getButtonTable().padTop(DPIUtils.getMarginSize());
            d.getButtonTable().defaults().padLeft(DPIUtils.getMarginSize()).padRight(DPIUtils.getMarginSize());
            Label l = new Label((CharSequence)I18N.getString("ui.remove"), LoadSaveScreen.this.ui.getSkin(), "ui-dialog");
            l.setWrap(true);
            l.setAlignment(1);
            d.getContentTable().add((Actor)l).prefWidth((float)Gdx.graphics.getWidth() * 0.7f);
            d.button(I18N.getString("ui.yes"), (Object)true, (TextButton.TextButtonStyle)LoadSaveScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
            d.button(I18N.getString("ui.no"), (Object)false, (TextButton.TextButtonStyle)LoadSaveScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
            d.key(66, (Object)true).key(131, (Object)false);
            d.show(LoadSaveScreen.this.stage);
        }
    };
    private ClickListener saveClickListener = new ClickListener(){

        public void clicked(InputEvent event, float x, float y) {
            World world = LoadSaveScreen.this.ui.getWorld();
            String filename = event.getListenerActor().getName() + ".gamestate.v13";
            try {
                world.getSerializer().saveGameState(filename);
                LoadSaveScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
            catch (IOException e) {
                EngineLogger.error(e.getMessage());
            }
        }
    };

    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.pointer.resize();
    }

    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
            this.stage = null;
            if (this.bgTexFile != null) {
                this.bgTexFile.dispose();
            }
            this.bgTexFile = null;
            for (Texture t : this.textureList) {
                t.dispose();
            }
        }
    }

    public void show() {
        float size = DPIUtils.getPrefButtonSize();
        float pad = DPIUtils.getMarginSize();
        Skin skin = this.ui.getSkin();
        final World world = this.ui.getWorld();
        this.loadScreenMode = world.getCurrentScene() == null;
        this.stage = new Stage((Viewport)new ScreenViewport());
        this.slotWidth = (int)(this.stage.getViewport().getWorldWidth() / 4.0f - 2.0f * pad);
        this.slotHeight = this.slotWidth * this.stage.getViewport().getScreenHeight() / this.stage.getViewport().getScreenWidth();
        LoadSaveScreenStyle style = (LoadSaveScreenStyle)skin.get(LoadSaveScreenStyle.class);
        Drawable bg = style.background;
        if (bg == null && style.bgFile != null) {
            this.bgTexFile = new Texture(EngineAssetManager.getInstance().getResAsset(style.bgFile));
            this.bgTexFile.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            bg = new TextureRegionDrawable(new TextureRegion(this.bgTexFile));
        }
        Table table = new Table(skin);
        table.setFillParent(true);
        table.center();
        table.pad(pad);
        Label title = new Label((CharSequence)(this.loadScreenMode ? I18N.getString("ui.load") : I18N.getString("ui.save")), skin, "title");
        Button back = new Button(skin, "back");
        back.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                LoadSaveScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
        });
        Table header = new Table();
        Container cont = new Container((Actor)back);
        cont.size(size);
        header.add((Actor)cont);
        header.add((Actor)title).fillX().expandX().left();
        table.add((Actor)header).fillX().expandX().left();
        if (bg != null) {
            table.setBackground(bg);
        }
        table.addListener((EventListener)new InputListener(){

            public boolean keyUp(InputEvent event, int keycode) {
                if ((keycode == 131 || keycode == 4) && world.getCurrentScene() != null) {
                    LoadSaveScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
                return true;
            }
        });
        PagedScrollPane scroll = new PagedScrollPane();
        scroll.setFlingTime(0.1f);
        scroll.setPageSpacing(0.0f);
        Table slots = new Table().pad(pad);
        slots.defaults().pad(pad).size((float)this.slotWidth + pad, (float)this.slotHeight + pad * 2.0f).top();
        int c = 0;
        if (!this.loadScreenMode) {
            slots.add((Actor)this.getSlotButton(Long.toString(new Date().getTime()))).fill().expand();
            ++c;
        }
        List<String> sl = this.getSlots();
        Collections.sort(sl);
        for (int j = sl.size() - 1; j >= 0; --j) {
            String s = sl.get(j);
            if (c % 3 == 0 && c % 6 != 0) {
                slots.row();
            }
            if (c != 0 && c % 6 == 0) {
                scroll.addPage((Actor)slots);
                slots = new Table().pad(pad);
                slots.defaults().pad(pad).size((float)this.slotWidth + pad, (float)this.slotHeight + pad * 2.0f).top();
            }
            Button removeButton = new Button(skin, "delete_game");
            removeButton.setName(s);
            removeButton.addListener((EventListener)this.removeClickListener);
            Container container = new Container((Actor)removeButton);
            container.size(DPIUtils.getPrefButtonSize() * 0.75f);
            container.align(18);
            slots.stack(new Actor[]{this.getSlotButton(s), container}).fill().expand();
            ++c;
        }
        if (slots.getCells().size > 0) {
            scroll.addPage((Actor)slots);
        }
        table.row();
        if (this.loadScreenMode && sl.size() == 0) {
            Label lbl = new Label((CharSequence)I18N.getString("ui.noSavedGames"), skin, "title");
            lbl.setAlignment(1);
            lbl.setWrap(true);
            table.add((Actor)lbl).expand().fill();
        } else {
            table.add((Actor)scroll).expand().fill();
        }
        table.pack();
        this.stage.setKeyboardFocus((Actor)table);
        this.stage.addActor((Actor)table);
        this.pointer = new Pointer(this.ui.getSkin());
        this.stage.addActor((Actor)this.pointer);
        Gdx.input.setInputProcessor((InputProcessor)this.stage);
    }

    private boolean slotExists(String slot) {
        String filename = slot + ".gamestate.v13";
        return this.ui.getWorld().savedGameExists(filename);
    }

    private Button getSlotButton(String slot) {
        Skin skin = this.ui.getSkin();
        Button button = new Button(new Button.ButtonStyle());
        Button.ButtonStyle style = button.getStyle();
        style.up = style.down = skin.getDrawable("black");
        String textLabel = I18N.getString("ui.newSlot");
        button.setSize((float)this.slotWidth, (float)this.slotHeight);
        if (this.slotExists(slot)) {
            button.add((Actor)this.getScreenshot(slot)).maxSize((float)this.slotWidth * 0.95f, (float)this.slotHeight * 0.95f);
            try {
                long l = Long.parseLong(slot);
                Date d = new Date(l);
                textLabel = new SimpleDateFormat().format(d);
            }
            catch (Exception e) {
                textLabel = slot;
            }
            button.addListener((EventListener)this.loadClickListener);
        } else {
            Image fg = new Image(skin.getDrawable("plus"));
            button.add((Actor)fg).maxSize((float)(this.slotHeight / 2), (float)(this.slotHeight / 2));
            button.addListener((EventListener)this.saveClickListener);
        }
        button.row();
        Label label = new Label((CharSequence)textLabel, skin);
        label.setAlignment(1);
        button.add((Actor)label).fillX();
        button.setName(slot);
        return button;
    }

    private List<String> getSlots() {
        FileHandle[] list;
        ArrayList<String> al = new ArrayList<String>();
        for (FileHandle file : list = EngineAssetManager.getInstance().getUserFolder().list()) {
            String name;
            if (!file.name().endsWith(".gamestate.v13") || (name = file.name().substring(0, file.name().indexOf(".gamestate.v13"))).equals("default")) continue;
            al.add(name);
        }
        if (EngineLogger.debugMode()) {
            String[] list2;
            for (String file : list2 = EngineAssetManager.getInstance().listAssetFiles("tests")) {
                if (!file.endsWith(".gamestate.v13")) continue;
                String name = file.substring(0, file.indexOf(".gamestate.v13"));
                al.add(name);
            }
        }
        return al;
    }

    private Image getScreenshot(String slot) {
        String filename = slot + ".gamestate.v13" + ".png";
        FileHandle savedFile = null;
        if (EngineAssetManager.getInstance().getUserFile(filename).exists()) {
            savedFile = EngineAssetManager.getInstance().getUserFile(filename);
        } else if (EngineAssetManager.getInstance().assetExists("tests/" + filename)) {
            savedFile = EngineAssetManager.getInstance().getAsset("tests/" + filename);
        } else {
            Drawable d = this.ui.getSkin().getDrawable("black");
            return new Image(d);
        }
        Texture t = new Texture(savedFile);
        this.textureList.add(t);
        return new Image(t);
    }

    public void hide() {
        this.dispose();
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }

    public static class LoadSaveScreenStyle {
        public Drawable background;
        public String bgFile;
        public String textButtonStyle;

        public LoadSaveScreenStyle() {
        }

        public LoadSaveScreenStyle(LoadSaveScreenStyle style) {
            this.background = style.background;
            this.bgFile = style.bgFile;
            this.textButtonStyle = style.textButtonStyle;
        }
    }
}

