/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.DebugScreen;
import com.bladecoder.engine.ui.Pointer;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;

public class MenuScreen
extends ScreenAdapter
implements BladeScreen {
    private UI ui;
    private Stage stage;
    private Texture bgTexFile = null;
    private Texture titleTexFile = null;
    private Pointer pointer;
    private Button credits;
    private Button help;
    private Button debug;
    private final Table menuButtonTable = new Table();
    private final Table iconStackTable = new Table();
    private Music music;

    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.pointer.resize();
        float size = DPIUtils.getPrefButtonSize();
        this.credits.setSize(size, size);
        this.help.setSize(size, size);
        this.debug.setSize(size, size);
    }

    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
            this.stage = null;
            if (this.bgTexFile != null) {
                this.bgTexFile.dispose();
                this.bgTexFile = null;
            }
            if (this.titleTexFile != null) {
                this.titleTexFile.dispose();
                this.titleTexFile = null;
            }
            if (this.music != null) {
                this.music.stop();
                this.music.dispose();
                this.music = null;
            }
        }
    }

    public void show() {
        this.stage = new Stage((Viewport)new ScreenViewport());
        final Skin skin = this.ui.getSkin();
        final World world = this.ui.getWorld();
        final MenuScreenStyle style = this.getStyle();
        BitmapFont f = ((TextButton.TextButtonStyle)skin.get((String)style.textButtonStyle, TextButton.TextButtonStyle.class)).font;
        float buttonWidth = f.getCapHeight() * 15.0f;
        Drawable bg = style.background;
        float scale = 1.0f;
        if (bg == null && style.bgFile != null) {
            this.bgTexFile = new Texture(EngineAssetManager.getInstance().getResAsset(style.bgFile));
            this.bgTexFile.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            scale = (float)this.bgTexFile.getHeight() / (float)this.stage.getViewport().getScreenHeight();
            int width = (int)((float)this.stage.getViewport().getScreenWidth() * scale);
            int x0 = (this.bgTexFile.getWidth() - width) / 2;
            bg = new TextureRegionDrawable(new TextureRegion(this.bgTexFile, x0, 0, width, this.bgTexFile.getHeight()));
        }
        this.menuButtonTable.clear();
        if (bg != null) {
            this.menuButtonTable.setBackground(bg);
        }
        this.menuButtonTable.addListener((EventListener)new InputListener(){

            public boolean keyUp(InputEvent event, int keycode) {
                if ((keycode == 131 || keycode == 4) && world.getCurrentScene() != null) {
                    MenuScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
                return true;
            }
        });
        this.menuButtonTable.align(this.getAlign());
        this.menuButtonTable.pad(DPIUtils.getMarginSize() * 2.0f);
        this.menuButtonTable.defaults().pad(DPIUtils.getSpacing()).width(buttonWidth).align(this.getAlign());
        this.stage.setKeyboardFocus((Actor)this.menuButtonTable);
        if (style.showTitle && style.titleStyle != null) {
            Label title = new Label((CharSequence)Config.getProperty("title", "Adventure Blade Engine"), skin, style.titleStyle);
            title.setAlignment(this.getAlign());
            this.menuButtonTable.add((Actor)title).padBottom(DPIUtils.getMarginSize() * 2.0f);
            this.menuButtonTable.row();
        }
        if (style.titleFile != null) {
            this.titleTexFile = new Texture(EngineAssetManager.getInstance().getResAsset(style.titleFile));
            this.titleTexFile.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image img = new Image(this.titleTexFile);
            this.menuButtonTable.add((Actor)img).width((float)this.titleTexFile.getWidth() / scale).height((float)this.titleTexFile.getHeight() / scale).padBottom(DPIUtils.getMarginSize() * 2.0f);
            this.menuButtonTable.row();
        }
        if (world.savedGameExists() || world.getCurrentScene() != null) {
            TextButton continueGame = new TextButton(I18N.getString("ui.continue"), skin, style.textButtonStyle);
            continueGame.getLabel().setAlignment(this.getAlign());
            continueGame.addListener((EventListener)new ClickListener(){

                public void clicked(InputEvent event, float x, float y) {
                    if (world.getCurrentScene() == null) {
                        try {
                            world.load();
                        }
                        catch (Exception e) {
                            Gdx.app.exit();
                        }
                    }
                    MenuScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
            });
            this.menuButtonTable.add((Actor)continueGame);
            this.menuButtonTable.row();
        }
        TextButton newGame = new TextButton(I18N.getString("ui.new"), skin, style.textButtonStyle);
        newGame.getLabel().setAlignment(this.getAlign());
        newGame.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                if (world.savedGameExists()) {
                    Dialog d = new Dialog("", skin){

                        protected void result(Object object) {
                            if (((Boolean)object).booleanValue()) {
                                try {
                                    world.newGame();
                                    MenuScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                                }
                                catch (Exception e) {
                                    EngineLogger.error("IN NEW GAME", e);
                                    Gdx.app.exit();
                                }
                            }
                        }
                    };
                    d.pad(DPIUtils.getMarginSize());
                    d.getButtonTable().padTop(DPIUtils.getMarginSize());
                    d.getButtonTable().defaults().padLeft(DPIUtils.getMarginSize()).padRight(DPIUtils.getMarginSize());
                    Label l = new Label((CharSequence)I18N.getString("ui.override"), MenuScreen.this.ui.getSkin(), "ui-dialog");
                    l.setWrap(true);
                    l.setAlignment(1);
                    d.getContentTable().add((Actor)l).prefWidth((float)Gdx.graphics.getWidth() * 0.7f);
                    d.button(I18N.getString("ui.yes"), (Object)true, (TextButton.TextButtonStyle)MenuScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
                    d.button(I18N.getString("ui.no"), (Object)false, (TextButton.TextButtonStyle)MenuScreen.this.ui.getSkin().get("ui-dialog", TextButton.TextButtonStyle.class));
                    d.key(66, (Object)true).key(131, (Object)false);
                    d.show(MenuScreen.this.stage);
                } else {
                    try {
                        world.newGame();
                        MenuScreen.this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                    }
                    catch (Exception e) {
                        EngineLogger.error("IN NEW GAME", e);
                        Gdx.app.exit();
                    }
                }
            }
        });
        this.menuButtonTable.add((Actor)newGame);
        this.menuButtonTable.row();
        TextButton loadGame = new TextButton(I18N.getString("ui.load"), skin, style.textButtonStyle);
        loadGame.getLabel().setAlignment(this.getAlign());
        loadGame.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MenuScreen.this.ui.setCurrentScreen(UI.Screens.LOAD_GAME_SCREEN);
            }
        });
        this.menuButtonTable.add((Actor)loadGame);
        this.menuButtonTable.row();
        TextButton quit = new TextButton(I18N.getString("ui.quit"), skin, style.textButtonStyle);
        quit.getLabel().setAlignment(this.getAlign());
        quit.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                Gdx.app.exit();
            }
        });
        this.menuButtonTable.add((Actor)quit);
        this.menuButtonTable.row();
        this.menuButtonTable.pack();
        this.stage.addActor((Actor)this.menuButtonTable);
        this.credits = new Button(skin, "credits");
        this.credits.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MenuScreen.this.ui.setCurrentScreen(UI.Screens.CREDIT_SCREEN);
            }
        });
        this.help = new Button(skin, "help");
        this.help.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MenuScreen.this.ui.setCurrentScreen(UI.Screens.HELP_SCREEN);
            }
        });
        this.debug = new Button(skin, "debug");
        this.debug.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                DebugScreen debugScr = new DebugScreen();
                debugScr.setUI(MenuScreen.this.ui);
                MenuScreen.this.ui.setCurrentScreen(debugScr);
            }
        });
        this.iconStackTable.clear();
        this.iconStackTable.defaults().pad(DPIUtils.getSpacing()).size(DPIUtils.getPrefButtonSize(), DPIUtils.getPrefButtonSize());
        this.iconStackTable.pad(DPIUtils.getMarginSize() * 2.0f);
        if (EngineLogger.debugMode() && world.getCurrentScene() != null) {
            this.iconStackTable.add((Actor)this.debug);
            this.iconStackTable.row();
        }
        this.iconStackTable.add((Actor)this.help);
        this.iconStackTable.row();
        this.iconStackTable.add((Actor)this.credits);
        this.iconStackTable.bottom().right();
        this.iconStackTable.setFillParent(true);
        this.iconStackTable.pack();
        this.stage.addActor((Actor)this.iconStackTable);
        Label version = new Label((CharSequence)("v" + Config.getProperty("version", " unspecified")), skin);
        version.setPosition(DPIUtils.getMarginSize(), DPIUtils.getMarginSize());
        version.addListener((EventListener)new ClickListener(){
            int count = 0;
            long time = System.currentTimeMillis();

            public void clicked(InputEvent event, float x, float y) {
                this.count = System.currentTimeMillis() - this.time < 500L ? ++this.count : 0;
                this.time = System.currentTimeMillis();
                if (this.count == 4) {
                    EngineLogger.toggle();
                    if (MenuScreen.this.ui.getWorld().isDisposed()) {
                        return;
                    }
                    if (EngineLogger.debugMode()) {
                        MenuScreen.this.iconStackTable.row();
                        MenuScreen.this.iconStackTable.add((Actor)MenuScreen.this.debug);
                    } else {
                        Cell cell = MenuScreen.this.iconStackTable.getCell((Actor)MenuScreen.this.debug);
                        MenuScreen.this.iconStackTable.removeActor((Actor)MenuScreen.this.debug);
                        cell.reset();
                    }
                }
            }
        });
        this.stage.addActor((Actor)version);
        this.debug.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                DebugScreen debugScr = new DebugScreen();
                debugScr.setUI(MenuScreen.this.ui);
                MenuScreen.this.ui.setCurrentScreen(debugScr);
            }
        });
        this.pointer = new Pointer(skin);
        this.stage.addActor((Actor)this.pointer);
        Gdx.input.setInputProcessor((InputProcessor)this.stage);
        if (style.musicFile != null) {
            new Thread(){

                @Override
                public void run() {
                    MenuScreen.this.music = Gdx.audio.newMusic(EngineAssetManager.getInstance().getAsset(style.musicFile));
                    MenuScreen.this.music.setLooping(true);
                    MenuScreen.this.music.play();
                }
            }.start();
        }
    }

    protected Table getMenuButtonTable() {
        return this.menuButtonTable;
    }

    protected Table getIconStackTable() {
        return this.iconStackTable;
    }

    protected UI getUI() {
        return this.ui;
    }

    protected MenuScreenStyle getStyle() {
        return (MenuScreenStyle)this.ui.getSkin().get(MenuScreenStyle.class);
    }

    private int getAlign() {
        if (this.getStyle().align == null || "center".equals(this.getStyle().align)) {
            return 1;
        }
        if ("top".equals(this.getStyle().align)) {
            return 2;
        }
        if ("bottom".equals(this.getStyle().align)) {
            return 4;
        }
        if ("left".equals(this.getStyle().align)) {
            return 8;
        }
        if ("right".equals(this.getStyle().align)) {
            return 16;
        }
        return 1;
    }

    public void hide() {
        this.dispose();
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
        this.menuButtonTable.setFillParent(true);
        this.menuButtonTable.center();
    }

    public static class MenuScreenStyle {
        public Drawable background;
        public String bgFile;
        public String titleFile;
        public String textButtonStyle;
        public String titleStyle;
        public boolean showTitle;
        public String musicFile;
        public String align;

        public MenuScreenStyle() {
        }

        public MenuScreenStyle(MenuScreenStyle style) {
            this.background = style.background;
            this.bgFile = style.bgFile;
            this.titleFile = style.titleFile;
            this.textButtonStyle = style.textButtonStyle;
            this.showTitle = style.showTitle;
            this.titleStyle = style.titleStyle;
            this.musicFile = style.musicFile;
            this.align = style.align;
        }
    }
}

