/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.RectangleRenderer;

public class PieMenu2
extends Group {
    private static final int NUM_VERBS = 10;
    private BitmapFont font;
    private Button[] buttons;
    private Vector2[] endPositions;
    private float x = 0.0f;
    private float y = 0.0f;
    private float distance = 100.0f;
    private float minAngle = 0.0f;
    private float maxAngle = 360.0f;
    private float startAngle = 0.0f;
    private InteractiveActor iActor = null;
    private final SceneScreen sceneScreen;
    private int viewportWidth;
    private int viewportHeight;
    private final GlyphLayout layout = new GlyphLayout();
    private String desc = null;

    public PieMenu2(SceneScreen scr) {
        this.sceneScreen = scr;
        this.font = scr.getUI().getSkin().getFont("desc");
        this.buttons = new Button[10];
        this.endPositions = new Vector2[10];
        for (int i = 0; i < 10; ++i) {
            this.buttons[i] = new Button(scr.getUI().getSkin(), "pie_lookat");
            this.endPositions[i] = new Vector2();
            this.addActor((Actor)this.buttons[i]);
            this.buttons[i].addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (PieMenu2.this.iActor != null) {
                        PieMenu2.this.sceneScreen.runVerb(PieMenu2.this.iActor, "lookat", null);
                    }
                    PieMenu2.this.hide();
                }
            });
        }
    }

    public void draw(Batch batch, float alpha) {
        super.draw(batch, alpha);
        String desc = this.iActor.getDesc();
        if (desc != null) {
            float margin = DPIUtils.UI_SPACE;
            float textX = this.x - this.layout.width / 2.0f;
            float textY = this.y - this.layout.height - DPIUtils.UI_SPACE;
            if (textX < 0.0f) {
                textX = 0.0f;
            }
            RectangleRenderer.draw(batch, textX - margin, textY - this.layout.height - margin, this.layout.width + margin * 2.0f, this.layout.height + margin * 2.0f, Color.BLACK);
            this.font.draw(batch, this.layout, textX, textY);
        }
    }

    public void hide() {
        this.setVisible(false);
        this.iActor = null;
    }

    public void show(InteractiveActor a, float x, float y) {
        this.setVisible(true);
        this.x = x;
        this.y = y;
        this.iActor = a;
        this.desc = this.iActor.getDesc();
        if (this.desc != null) {
            if (this.desc.charAt(0) == '@') {
                this.desc = I18N.getString(this.desc.substring(1));
            }
            this.layout.setText(this.font, (CharSequence)this.desc);
        }
        float margin = DPIUtils.getMarginSize();
        if (x < this.distance + this.buttons[0].getWidth() / 2.0f + margin) {
            this.x = this.distance + this.buttons[0].getWidth() / 2.0f + margin;
        } else if (x > (float)this.viewportWidth - this.distance - this.buttons[0].getWidth() / 2.0f - margin) {
            this.x = (float)this.viewportWidth - this.distance - this.buttons[0].getWidth() / 2.0f - margin;
        }
        if (y < this.distance + this.buttons[0].getHeight() / 2.0f + margin) {
            this.y = this.distance + this.buttons[0].getHeight() / 2.0f + margin;
        } else if (y > (float)this.viewportHeight - this.distance - this.buttons[0].getHeight() / 2.0f - margin) {
            this.y = (float)this.viewportHeight - this.distance - this.buttons[0].getHeight() / 2.0f - margin;
        }
        float offsetAngle = (this.maxAngle - this.minAngle) / 9.0f;
        float angle = this.startAngle;
        for (int i = 0; i < 10; ++i) {
            this.endPositions[i].x = (float)Math.cos(Math.toRadians(angle)) * this.distance + this.x;
            this.endPositions[i].y = (float)Math.sin(Math.toRadians(angle)) * this.distance + this.y;
            this.buttons[i].setPosition(this.x - this.buttons[i].getWidth() / 2.0f, this.y - this.buttons[i].getHeight() / 2.0f);
            this.buttons[i].addAction((Action)Actions.moveTo((float)(this.endPositions[i].x - this.buttons[i].getWidth() / 2.0f), (float)(this.endPositions[i].y - this.buttons[i].getWidth() / 2.0f), (float)0.1f));
            angle += offsetAngle;
        }
    }

    public void resize(int width, int height) {
        this.viewportWidth = width;
        this.viewportHeight = height;
        this.setBounds(0.0f, 0.0f, width, height);
    }

    public static class PieMenu2Style {
        public ImageButton.ImageButtonStyle buttonStyle;
        public float distance;
        public float minAngle;
        public float maxAngle;
        public float startAngle;

        public PieMenu2Style() {
        }

        public PieMenu2Style(PieMenu2Style style) {
            this.buttonStyle = style.buttonStyle;
            this.distance = style.distance;
            this.minAngle = style.minAngle;
            this.maxAngle = style.maxAngle;
            this.startAngle = style.startAngle;
        }
    }
}

