/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class Recorder {
    private static final String DEFAULT_RECORD_FILENAME = "record";
    public static final String RECORD_EXT = ".verbs.rec";
    public static final String GAMESTATE_REC_EXT = ".gamestate.rec";
    private static final float WAITING_TIME = 0.5f;
    private ArrayList<TimeVerb> list = new ArrayList();
    private boolean playing = false;
    private boolean recording = false;
    private float time;
    private int pos;
    private String fileName = "record";
    private final World w;

    public Recorder(World w) {
        this.w = w;
    }

    public void update(float delta) {
        if (this.w.isPaused()) {
            return;
        }
        if (this.recording) {
            this.time += delta;
        } else if (this.playing) {
            this.time += delta;
            if (this.pos >= this.list.size()) {
                this.setPlaying(false);
                return;
            }
            TimeVerb v = this.list.get(this.pos);
            Scene s = this.w.getCurrentScene();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RECORDER - ");
            if (this.playing && v.time < this.time && !this.w.inCutMode()) {
                if (v.verb == null) {
                    if (v.pos == null) {
                        this.w.selectDialogOption(v.dialogOption);
                        stringBuilder.append(" SELECT DIALOG OPTION: ").append(v.dialogOption);
                    } else {
                        s.getPlayer().goTo(v.pos, null, false);
                        stringBuilder.append(" GOTO ").append(v.pos.x).append(',').append(v.pos.y);
                    }
                } else {
                    stringBuilder.append(v.verb);
                    if (v.verb.equals("SAVEGAME")) {
                        stringBuilder.append(v.target);
                        try {
                            this.w.getSerializer().saveGameState(v.target);
                        }
                        catch (IOException e) {
                            EngineLogger.error("Couldn't save game: " + v.target + " : " + e.getMessage());
                        }
                    } else {
                        InteractiveActor a = (InteractiveActor)s.getActor(v.actorId, true);
                        if (a != null) {
                            stringBuilder.append(' ').append(v.actorId);
                            if (v.target != null) {
                                stringBuilder.append(" with ").append(v.target);
                            }
                            a.runVerb(v.verb, v.target);
                        } else {
                            EngineLogger.error("PLAYING ERROR: BaseActor not found: " + v.actorId);
                        }
                    }
                }
                EngineLogger.debug(stringBuilder.toString());
                this.time = 0.0f;
                ++this.pos;
                if (this.pos >= this.list.size()) {
                    this.setPlaying(false);
                } else {
                    TimeVerb timeVerb = this.list.get(this.pos);
                }
            }
        }
    }

    public void add(String actorId, String verb, String target) {
        if (this.recording) {
            this.time += 0.5f;
            TimeVerb v = new TimeVerb();
            v.time = this.time;
            v.verb = verb;
            v.target = target;
            v.actorId = actorId;
            this.list.add(v);
            this.time = 0.0f;
        }
    }

    public void add(int dialogOption) {
        if (this.recording) {
            TimeVerb v = new TimeVerb();
            this.time += 0.5f;
            v.time = this.time;
            if (this.w.hasDialogOptions()) {
                v.dialogOption = dialogOption;
            }
            this.list.add(v);
            this.time = 0.0f;
        }
    }

    public void add(Vector2 pos) {
        if (this.recording) {
            TimeVerb v = new TimeVerb();
            this.time += 0.5f;
            v.time = this.time;
            v.pos = pos;
            this.list.add(v);
            this.time = 0.0f;
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
        this.time = 0.0f;
        this.pos = 0;
        if (recording) {
            EngineLogger.debug("RECORDING...");
            try {
                this.w.getSerializer().saveGameState(this.fileName + GAMESTATE_REC_EXT);
            }
            catch (IOException e) {
                EngineLogger.error(e.getMessage());
            }
        } else {
            this.save();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean p) {
        if (p) {
            EngineLogger.debug("PLAYING...");
        } else {
            EngineLogger.debug("STOP PLAYING...");
        }
        this.playing = p;
        this.recording = false;
        this.time = 0.0f;
        this.pos = 0;
    }

    public void draw(SpriteBatch batch) {
        if (this.recording && (int)this.time % 2 == 0) {
            RectangleRenderer.draw((Batch)batch, 10.0f, 10.0f, 20.0f, 20.0f, Color.RED);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFilename(String name) {
        this.fileName = name != null && !name.trim().isEmpty() ? name : DEFAULT_RECORD_FILENAME;
    }

    public void load() {
        String gameStateFileName = this.fileName + GAMESTATE_REC_EXT;
        String recordFileName = this.fileName + RECORD_EXT;
        FileHandle verbsFile = EngineAssetManager.getInstance().getUserFile(recordFileName);
        if (!verbsFile.exists()) {
            verbsFile = EngineAssetManager.getInstance().getAsset("tests/" + recordFileName);
        }
        if (verbsFile.exists()) {
            FileHandle gameStateFile = EngineAssetManager.getInstance().getUserFile(gameStateFileName);
            if (!gameStateFile.exists()) {
                gameStateFile = EngineAssetManager.getInstance().getAsset("tests/" + gameStateFileName);
            }
            if (gameStateFile.exists()) {
                try {
                    this.w.getSerializer().loadGameState(gameStateFile);
                }
                catch (IOException e) {
                    EngineLogger.error(e.getMessage());
                }
            } else {
                EngineLogger.debug("LOADING RECORD: no saved file exists");
            }
            this.list = (ArrayList)new Json().fromJson(ArrayList.class, TimeVerb.class, verbsFile.reader("UTF-8"));
        } else {
            EngineLogger.error("LOADING RECORD: no record file exists");
        }
    }

    public void save() {
        Json json = new Json();
        String s = json.toJson(this.list, ArrayList.class, TimeVerb.class);
        s = json.prettyPrint(s);
        Writer w = EngineAssetManager.getInstance().getUserFile(this.fileName + RECORD_EXT).writer(false, "UTF-8");
        try {
            w.write(s);
            w.close();
        }
        catch (IOException e) {
            EngineLogger.error("ERROR SAVING RECORD", e);
        }
    }

    static class TimeVerb {
        float time;
        String verb;
        String target;
        String actorId;
        int dialogOption;
        Vector2 pos;

        TimeVerb() {
        }
    }
}

