/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.util.EngineLogger;

public class SceneExtendViewport
extends Viewport {
    private float minWorldWidth;
    private float minWorldHeight;
    private float maxWorldWidth;
    private float maxWorldHeight;

    public SceneExtendViewport() {
        this.setCamera((Camera)new OrthographicCamera());
    }

    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        float worldWidth = this.minWorldWidth;
        float worldHeight = this.minWorldHeight;
        Vector2 scaled = Scaling.fit.apply(worldWidth, worldHeight, (float)screenWidth, (float)screenHeight);
        int viewportWidth = Math.round(scaled.x);
        int viewportHeight = Math.round(scaled.y);
        if (viewportWidth < screenWidth) {
            float toViewportSpace = (float)viewportHeight / worldHeight;
            float toWorldSpace = worldHeight / (float)viewportHeight;
            float lengthen = (float)(screenWidth - viewportWidth) * toWorldSpace;
            if (this.maxWorldWidth > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldWidth - this.minWorldWidth);
            }
            worldWidth += lengthen;
            viewportWidth += Math.round(lengthen * toViewportSpace);
        } else if (viewportHeight < screenHeight) {
            float toViewportSpace = (float)viewportWidth / worldWidth;
            float toWorldSpace = worldWidth / (float)viewportWidth;
            float lengthen = (float)(screenHeight - viewportHeight) * toWorldSpace;
            if (this.maxWorldHeight > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldHeight - this.minWorldHeight);
            }
            worldHeight += lengthen;
            viewportHeight += Math.round(lengthen * toViewportSpace);
        }
        super.setWorldSize(worldWidth, worldHeight);
        this.setScreenBounds((screenWidth - viewportWidth) / 2, (screenHeight - viewportHeight) / 2, viewportWidth, viewportHeight);
        this.apply(centerCamera);
        EngineLogger.debug("SCREEN VIEWPORT: " + this.getScreenWidth() + "x" + this.getScreenHeight());
        EngineLogger.debug("SCREEN WORLD: " + this.getWorldWidth() + "x" + this.getWorldHeight());
    }

    public void apply(boolean centerCamera) {
        HdpiUtils.glViewport((int)this.getScreenX(), (int)this.getScreenY(), (int)this.getScreenWidth(), (int)this.getScreenHeight());
        this.getCamera().viewportWidth = this.getScreenWidth();
        this.getCamera().viewportHeight = this.getScreenHeight();
        if (centerCamera) {
            this.getCamera().position.set((float)(this.getScreenWidth() / 2), (float)(this.getScreenHeight() / 2), 0.0f);
        }
        this.getCamera().update();
    }

    public void setWorldSize(float worldWidth, float worldHeight) {
        super.setWorldSize(worldWidth, worldHeight);
        this.minWorldWidth = Math.min(worldHeight * 4.0f / 3.0f, worldWidth);
        this.minWorldHeight = Math.min(worldWidth * 9.0f / 16.0f, worldHeight);
        this.maxWorldWidth = worldWidth;
        this.maxWorldHeight = worldHeight;
    }

    public Vector2 unproject(Vector2 out) {
        super.unproject(out);
        out.x = MathUtils.clamp((float)out.x, (float)0.0f, (float)(this.getScreenWidth() - 1));
        out.y = MathUtils.clamp((float)out.y, (float)0.0f, (float)(this.getScreenHeight() - 1));
        return out;
    }

    public Vector3 unproject(Vector3 out) {
        super.unproject(out);
        out.x = MathUtils.clamp((float)out.x, (float)0.0f, (float)(this.getScreenWidth() - 1));
        out.y = MathUtils.clamp((float)out.y, (float)0.0f, (float)(this.getScreenHeight() - 1));
        return out;
    }
}

