/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;

public class SceneFitViewport
extends Viewport {
    public SceneFitViewport() {
        this.setCamera((Camera)new OrthographicCamera());
    }

    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        Vector2 scaled = Scaling.fit.apply(this.getWorldWidth(), this.getWorldHeight(), (float)screenWidth, (float)screenHeight);
        this.setScreenSize(Math.round(scaled.x), Math.round(scaled.y));
        this.setScreenPosition((screenWidth - this.getScreenWidth()) / 2, (screenHeight - this.getScreenHeight()) / 2);
        this.apply(centerCamera);
    }

    public void apply(boolean centerCamera) {
        HdpiUtils.glViewport((int)this.getScreenX(), (int)this.getScreenY(), (int)this.getScreenWidth(), (int)this.getScreenHeight());
        this.getCamera().viewportWidth = this.getScreenWidth();
        this.getCamera().viewportHeight = this.getScreenHeight();
        if (centerCamera) {
            this.getCamera().position.set((float)(this.getScreenWidth() / 2), (float)(this.getScreenHeight() / 2), 0.0f);
        }
        this.getCamera().update();
    }

    public Vector2 unproject(Vector2 out) {
        super.unproject(out);
        out.x = MathUtils.clamp((float)out.x, (float)0.0f, (float)(this.getScreenWidth() - 1));
        out.y = MathUtils.clamp((float)out.y, (float)0.0f, (float)(this.getScreenHeight() - 1));
        return out;
    }

    public Vector3 unproject(Vector3 out) {
        super.unproject(out);
        out.x = MathUtils.clamp((float)out.x, (float)0.0f, (float)(this.getScreenWidth() - 1));
        out.y = MathUtils.clamp((float)out.y, (float)0.0f, (float)(this.getScreenHeight() - 1));
        return out;
    }
}

