/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.BladeSkin;
import com.bladecoder.engine.ui.CreditsScreen;
import com.bladecoder.engine.ui.DialogUI;
import com.bladecoder.engine.ui.HelpScreen;
import com.bladecoder.engine.ui.InitScreen;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.ui.LoadSaveScreen;
import com.bladecoder.engine.ui.LoadingScreen;
import com.bladecoder.engine.ui.MenuScreen;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.TesterBot;
import com.bladecoder.engine.ui.TextManagerUI;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.ui.retro.VerbUI;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import com.bladecoder.engine.util.Utils3D;

public class UI {
    private static final String SKIN_FILENAME = "ui/ui.json";
    private final Recorder recorder;
    private final TesterBot testerBot;
    private boolean fullscreen = false;
    private BladeScreen screen;
    private SpriteBatch batch;
    private Skin skin;
    private final World w;
    private final BladeScreen[] screens;

    public UI(World w) {
        this.w = w;
        this.recorder = new Recorder(w);
        this.testerBot = new TesterBot(w);
        this.batch = new SpriteBatch();
        this.screens = new BladeScreen[Screens.values().length];
        Gdx.input.setCatchMenuKey(true);
        this.loadAssets();
        this.screens[Screens.INIT_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.INIT_SCREEN.toString(), InitScreen.class);
        this.screens[Screens.SCENE_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.SCENE_SCREEN.toString(), DefaultSceneScreen.class);
        this.screens[Screens.LOADING_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.LOADING_SCREEN.toString(), LoadingScreen.class);
        this.screens[Screens.MENU_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.MENU_SCREEN.toString(), MenuScreen.class);
        this.screens[Screens.HELP_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.HELP_SCREEN.toString(), HelpScreen.class);
        this.screens[Screens.CREDIT_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.CREDIT_SCREEN.toString(), CreditsScreen.class);
        this.screens[Screens.LOAD_GAME_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.LOAD_GAME_SCREEN.toString(), LoadSaveScreen.class);
        this.screens[Screens.SAVE_GAME_SCREEN.ordinal()] = this.getCustomScreenInstance(Screens.SAVE_GAME_SCREEN.toString(), LoadSaveScreen.class);
        for (BladeScreen s : this.screens) {
            s.setUI(this);
        }
        this.setCurrentScreen(Screens.INIT_SCREEN);
    }

    public World getWorld() {
        return this.w;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public TesterBot getTesterBot() {
        return this.testerBot;
    }

    private BladeScreen getCustomScreenInstance(String prop, Class<?> defaultClass) {
        String clsName = Config.getProperty(prop, null);
        Class instanceClass = defaultClass;
        if (clsName != null && !clsName.isEmpty()) {
            try {
                instanceClass = ClassReflection.forName((String)clsName);
                return (BladeScreen)ClassReflection.newInstance((Class)instanceClass);
            }
            catch (Exception e) {
                EngineLogger.error("Error instancing screen. " + e.getMessage());
                instanceClass = defaultClass;
            }
        }
        try {
            return (BladeScreen)ClassReflection.newInstance(instanceClass);
        }
        catch (Exception e) {
            EngineLogger.error("Error instancing screen", e);
            return null;
        }
    }

    public BladeScreen getScreen(Screens state) {
        return this.screens[state.ordinal()];
    }

    public void setScreen(Screens state, BladeScreen s) {
        this.screens[state.ordinal()] = s;
    }

    public SpriteBatch getBatch() {
        return this.batch;
    }

    public BladeScreen getCurrentScreen() {
        return this.screen;
    }

    public void setCurrentScreen(Screens s) {
        EngineLogger.debug("Setting SCREEN: " + s.name());
        this.setCurrentScreen(this.screens[s.ordinal()]);
    }

    public void setCurrentScreen(BladeScreen s) {
        if (this.screen != null) {
            this.screen.hide();
        }
        this.screen = s;
        this.screen.show();
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public TextureAtlas getUIAtlas() {
        return this.skin.getAtlas();
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void render() {
        float delta = Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f);
        this.screen.render(delta);
    }

    private void loadAssets() {
        FileHandle skinFile = EngineAssetManager.getInstance().getAsset(SKIN_FILENAME);
        TextureAtlas atlas = new TextureAtlas(EngineAssetManager.getInstance().getResAsset(SKIN_FILENAME.substring(0, SKIN_FILENAME.lastIndexOf(46)) + ".atlas"));
        this.skin = new BladeSkin(atlas);
        ((BladeSkin)this.skin).addStyleTag(VerbUI.VerbUIStyle.class);
        ((BladeSkin)this.skin).addStyleTag(TextManagerUI.TextManagerUIStyle.class);
        ((BladeSkin)this.skin).addStyleTag(DialogUI.DialogUIStyle.class);
        ((BladeSkin)this.skin).addStyleTag(InventoryUI.InventoryUIStyle.class);
        ((BladeSkin)this.skin).addStyleTag(CreditsScreen.CreditScreenStyle.class);
        ((BladeSkin)this.skin).addStyleTag(LoadSaveScreen.LoadSaveScreenStyle.class);
        ((BladeSkin)this.skin).addStyleTag(MenuScreen.MenuScreenStyle.class);
        this.skin.load(skinFile);
        if (!Config.getProperty("character_icon_atlas", "").equals("")) {
            EngineAssetManager.getInstance().loadAtlas(Config.getProperty("character_icon_atlas", null));
            EngineAssetManager.getInstance().finishLoading();
        }
    }

    public void resize(int width, int height) {
        if (this.screen != null) {
            this.screen.resize(width, height);
        }
    }

    public void toggleFullScreen() {
        if (!this.fullscreen) {
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
            this.fullscreen = true;
        } else {
            Gdx.graphics.setWindowedMode(this.w.getWidth(), this.w.getHeight());
            this.fullscreen = false;
        }
    }

    public void dispose() {
        this.screen.hide();
        this.batch.dispose();
        this.skin.dispose();
        RectangleRenderer.dispose();
        Utils3D.dispose();
        if (!Config.getProperty("character_icon_atlas", "").equals("")) {
            EngineAssetManager.getInstance().disposeAtlas(Config.getProperty("character_icon_atlas", null));
        }
        for (BladeScreen s : this.screens) {
            s.dispose();
        }
        EngineAssetManager.getInstance().dispose();
    }

    public void resume() {
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            RectangleRenderer.dispose();
        }
        if (this.screen != null) {
            this.screen.resume();
        }
    }

    public void pause() {
        if (this.screen != null) {
            this.screen.pause();
        }
    }

    public static enum Screens {
        INIT_SCREEN,
        SCENE_SCREEN,
        LOADING_SCREEN,
        MENU_SCREEN,
        HELP_SCREEN,
        CREDIT_SCREEN,
        LOAD_GAME_SCREEN,
        SAVE_GAME_SCREEN;

    }
}

