/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.AnchorActor;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.TextManager;
import com.bladecoder.engine.model.Transition;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.model.WorldListener;
import com.bladecoder.engine.ui.DialogUI;
import com.bladecoder.engine.ui.ITextManagerUI;
import com.bladecoder.engine.ui.InventoryButton;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.ui.PieMenu;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.SceneExtendViewport;
import com.bladecoder.engine.ui.SceneFitViewport;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.TesterBot;
import com.bladecoder.engine.ui.TextManagerUI;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.ScenePointer;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.io.IOException;
import java.util.Locale;

public class DefaultSceneScreen
implements SceneScreen {
    private static final float LOADING_WAIT_TIME_MS = 500.0f;
    private UI ui;
    private Stage stage;
    private PieMenu pie;
    private InventoryUI inventoryUI;
    private Actor dialogUI;
    private Actor textManagerUI;
    private ShapeRenderer renderer;
    private InventoryButton inventoryButton;
    private Button menuButton;
    private UIModes uiMode = UIModes.TWO_BUTTONS;
    private Recorder recorder;
    private TesterBot testerBot;
    private final Viewport viewport;
    private final Vector3 unprojectTmp = new Vector3();
    private final Vector2 unproject2Tmp = new Vector2();
    private final StringBuilder sbTmp = new StringBuilder();
    private InteractiveActor currentActor = null;
    private boolean drawHotspots = false;
    private final boolean showDesc;
    private final boolean fastLeave;
    private float speed = 1.0f;
    private ScenePointer pointer;
    private boolean uiEnabled = true;
    private final GlyphLayout textLayout = new GlyphLayout();
    private final GestureDetector inputProcessor = new GestureDetector((GestureDetector.GestureListener)new GestureDetector.GestureAdapter(){

        public boolean touchDown(float x, float y, int pointer, int button) {
            return true;
        }

        public boolean tap(float x, float y, int count, int button) {
            EngineLogger.debug("Event TAP button: " + button + " count: " + count);
            World w = DefaultSceneScreen.this.ui.getWorld();
            if (w.isPaused() || DefaultSceneScreen.this.recorder.isPlaying() || DefaultSceneScreen.this.testerBot.isEnabled()) {
                return true;
            }
            if (DefaultSceneScreen.this.pie.isVisible()) {
                DefaultSceneScreen.this.pie.hide();
            }
            if (DefaultSceneScreen.this.drawHotspots) {
                DefaultSceneScreen.this.drawHotspots = false;
            } else {
                DefaultSceneScreen.this.getInputUnProject(DefaultSceneScreen.this.unprojectTmp);
                if (w.inCutMode() || !w.inCutMode() && !TextManager.AUTO_HIDE_TEXTS && DefaultSceneScreen.this.textManagerUI.isVisible()) {
                    if (DefaultSceneScreen.this.recorder.isRecording()) {
                        return true;
                    }
                    w.getCurrentScene().getTextManager().next();
                } else if (DefaultSceneScreen.this.inventoryUI.isVisible()) {
                    DefaultSceneScreen.this.inventoryUI.hide();
                } else if (!w.hasDialogOptions()) {
                    if (button == 2) {
                        if (!DefaultSceneScreen.this.inventoryUI.isVisible()) {
                            DefaultSceneScreen.this.inventoryUI.show();
                        }
                    } else {
                        DefaultSceneScreen.this.sceneClick(button, count);
                    }
                }
            }
            return true;
        }

        public boolean longPress(float x, float y) {
            EngineLogger.debug("Event LONG PRESS");
            if (DefaultSceneScreen.this.uiEnabled && !DefaultSceneScreen.this.ui.getWorld().hasDialogOptions()) {
                DefaultSceneScreen.this.drawHotspots = true;
            }
            return false;
        }

        public boolean pan(float x, float y, float deltaX, float deltaY) {
            return true;
        }

        public boolean panStop(float x, float y, int pointer, int button) {
            this.tap(x, y, 1, button);
            return true;
        }
    }){

        public boolean keyUp(int keycode) {
            switch (keycode) {
                case 4: 
                case 82: 
                case 131: {
                    DefaultSceneScreen.this.showMenu();
                    break;
                }
                case 32: {
                    if (!UIUtils.ctrl()) break;
                    EngineLogger.toggle();
                    break;
                }
                case 62: {
                    if (!DefaultSceneScreen.this.drawHotspots) break;
                    DefaultSceneScreen.this.drawHotspots = false;
                }
            }
            return true;
        }

        public boolean keyTyped(char character) {
            switch (character) {
                case '1': {
                    EngineLogger.setDebugLevel(0);
                    break;
                }
                case '2': {
                    EngineLogger.setDebugLevel(1);
                    break;
                }
                case '3': {
                    EngineLogger.setDebugLevel(2);
                    break;
                }
                case 'f': {
                    break;
                }
                case 's': {
                    if (!EngineLogger.debugMode()) break;
                    try {
                        DefaultSceneScreen.this.ui.getWorld().saveGameState();
                    }
                    catch (IOException e) {
                        EngineLogger.error(e.getMessage());
                    }
                    break;
                }
                case 'l': {
                    if (!EngineLogger.debugMode()) break;
                    try {
                        DefaultSceneScreen.this.ui.getWorld().loadGameState();
                    }
                    catch (IOException e) {
                        EngineLogger.error(e.getMessage());
                    }
                    break;
                }
                case 't': {
                    if (!EngineLogger.debugMode()) break;
                    DefaultSceneScreen.this.testerBot.setEnabled(!DefaultSceneScreen.this.testerBot.isEnabled());
                    DefaultSceneScreen.this.updateUI();
                    break;
                }
                case '.': {
                    if (!EngineLogger.debugMode()) break;
                    if (DefaultSceneScreen.this.recorder.isRecording()) {
                        DefaultSceneScreen.this.recorder.setRecording(false);
                    } else {
                        DefaultSceneScreen.this.recorder.setRecording(true);
                    }
                    DefaultSceneScreen.this.updateUI();
                    break;
                }
                case ',': {
                    if (!EngineLogger.debugMode()) break;
                    if (DefaultSceneScreen.this.recorder.isPlaying()) {
                        DefaultSceneScreen.this.recorder.setPlaying(false);
                    } else {
                        DefaultSceneScreen.this.recorder.load();
                        DefaultSceneScreen.this.recorder.setPlaying(true);
                    }
                    DefaultSceneScreen.this.updateUI();
                    break;
                }
                case 'p': {
                    if (DefaultSceneScreen.this.ui.getWorld().isPaused()) {
                        DefaultSceneScreen.this.resume();
                        break;
                    }
                    DefaultSceneScreen.this.pause();
                    break;
                }
                case ' ': {
                    if (!DefaultSceneScreen.this.uiEnabled || DefaultSceneScreen.this.ui.getWorld().hasDialogOptions()) break;
                    DefaultSceneScreen.this.drawHotspots = true;
                }
            }
            return false;
        }

        public boolean scrolled(int amount) {
            if (DefaultSceneScreen.this.uiEnabled && !DefaultSceneScreen.this.ui.getWorld().hasDialogOptions() && DefaultSceneScreen.this.ui.getWorld().getInventory().isVisible()) {
                boolean fromDown;
                boolean bl = fromDown = DefaultSceneScreen.this.inventoryUI.getInventoryPos() == InventoryUI.InventoryPos.CENTER || DefaultSceneScreen.this.inventoryUI.getInventoryPos() == InventoryUI.InventoryPos.DOWN;
                if ((amount > 0 && fromDown || amount < 0 && !fromDown) && DefaultSceneScreen.this.inventoryUI.isVisible()) {
                    DefaultSceneScreen.this.inventoryUI.hide();
                } else if ((amount > 0 && !fromDown || amount < 0 && fromDown) && !DefaultSceneScreen.this.inventoryUI.isVisible()) {
                    if (DefaultSceneScreen.this.uiMode == UIModes.PIE && DefaultSceneScreen.this.pie.isVisible()) {
                        DefaultSceneScreen.this.pie.hide();
                    }
                    DefaultSceneScreen.this.inventoryUI.show();
                }
            }
            return true;
        }
    };
    private final WorldListener worldListener = new WorldListener(){

        @Override
        public void text(Text t) {
            if (t != null && t.type == Text.Type.UI) {
                DefaultSceneScreen.this.showUIText(t);
            } else {
                ((ITextManagerUI)DefaultSceneScreen.this.textManagerUI).setText(t);
            }
        }

        @Override
        public void dialogOptions() {
            DefaultSceneScreen.this.updateUI();
        }

        @Override
        public void cutMode(boolean value) {
            DefaultSceneScreen.this.updateUI();
        }

        @Override
        public void inventoryEnabled(boolean value) {
            DefaultSceneScreen.this.inventoryUI.hide();
            DefaultSceneScreen.this.inventoryButton.setVisible(value);
        }

        @Override
        public void pause(boolean value) {
            DefaultSceneScreen.this.updateUI();
        }
    };

    public DefaultSceneScreen() {
        this.viewport = Config.getProperty("extend_viewport", true) ? new SceneExtendViewport() : new SceneFitViewport();
        this.showDesc = Config.getProperty("show_desc", true);
        this.fastLeave = Config.getProperty("fast_leave", false);
    }

    @Override
    public UI getUI() {
        return this.ui;
    }

    private void showUIText(Text t) {
        String style = t.style == null ? "ui-text" : t.style;
        Label msg = new Label((CharSequence)t.str, this.getUI().getSkin(), style);
        msg.setWrap(true);
        msg.setAlignment(1, 1);
        msg.setColor(t.color);
        msg.setSize(msg.getWidth() + DPIUtils.getMarginSize() * 2.0f, msg.getHeight() + DPIUtils.getMarginSize() * 2.0f);
        this.stage.addActor((Actor)msg);
        this.unprojectTmp.set(t.x, t.y, 0.0f);
        this.ui.getWorld().getSceneCamera().scene2screen(this.getStage().getViewport(), this.unprojectTmp);
        float posx = t.x == -1.0f ? ((float)this.getStage().getViewport().getScreenWidth() - msg.getWidth()) / 2.0f : (t.y == -2.0f ? DPIUtils.getMarginSize() : this.unprojectTmp.x);
        float posy = t.y == -1.0f ? ((float)this.getStage().getViewport().getScreenHeight() - msg.getHeight()) / 2.0f : (t.y == -2.0f ? (float)this.getStage().getViewport().getScreenHeight() - msg.getHeight() - DPIUtils.getMarginSize() * 3.0f : this.unprojectTmp.y);
        msg.setPosition(posx, posy);
        msg.getColor().a = 0.0f;
        msg.addAction((Action)Actions.sequence((Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.delay((float)t.time, (Action)Actions.sequence((Action)Actions.fadeOut((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.removeActor()))));
    }

    private void updateUI() {
        World w = this.ui.getWorld();
        if (this.uiMode == UIModes.PIE && this.pie.isVisible()) {
            this.pie.hide();
        }
        this.currentActor = null;
        this.pointer.reset();
        if (w.isPaused() || w.inCutMode() || this.testerBot.isEnabled() || this.recorder.isPlaying()) {
            this.inventoryUI.hide();
            this.inventoryButton.setVisible(false);
            this.dialogUI.setVisible(false);
            this.inventoryUI.cancelDragging();
            this.uiEnabled = false;
        } else {
            if (this.ui.getWorld().hasDialogOptions()) {
                this.inventoryUI.hide();
                this.inventoryButton.setVisible(false);
                this.dialogUI.setVisible(true);
                this.inventoryUI.cancelDragging();
            } else {
                this.inventoryUI.hide();
                this.dialogUI.setVisible(false);
                this.inventoryButton.setVisible(w.getInventory().isVisible());
            }
            this.uiEnabled = true;
        }
    }

    @Override
    public void setSpeed(float s) {
        this.speed = s;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    private void update(float delta) {
        World world = this.ui.getWorld();
        if (!world.isDisposed()) {
            world.update(delta * this.speed);
            if (world.isDisposed()) {
                return;
            }
        }
        World.AssetState assetState = world.getAssetState();
        if (world.getAssetState() != World.AssetState.LOADED) {
            long t0;
            this.resetUI();
            if (assetState == World.AssetState.LOAD_ASSETS || assetState == World.AssetState.LOAD_ASSETS_AND_INIT_SCENE) {
                world.update(0.0f);
            }
            long t = t0 = System.currentTimeMillis();
            while (EngineAssetManager.getInstance().isLoading() && (float)(t - t0) < 500.0f) {
                t = System.currentTimeMillis();
            }
            if ((float)(t - t0) >= 500.0f) {
                this.ui.setCurrentScreen(UI.Screens.LOADING_SCREEN);
            } else {
                world.resize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
                world.update(0.0f);
            }
            return;
        }
        this.stage.act(delta);
        if (world.isPaused()) {
            return;
        }
        this.recorder.update(delta * this.speed);
        this.testerBot.update(delta * this.speed);
        InteractiveActor actorUnderCursor = null;
        if (this.uiEnabled && !world.hasDialogOptions()) {
            if (this.inventoryUI.isVisible()) {
                this.unproject2Tmp.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
                this.inventoryUI.screenToLocalCoordinates(this.unproject2Tmp);
                actorUnderCursor = this.inventoryUI.getItemAt(this.unproject2Tmp.x, this.unproject2Tmp.y);
            } else {
                float tolerance = this.inventoryUI.isDragging() ? DPIUtils.getTouchMinSize() : (Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) ? DPIUtils.getTouchMinSize() / 2.0f : 0.0f);
                actorUnderCursor = world.getInteractiveActorAtInput(this.viewport, tolerance);
            }
            if (!this.pie.isVisible() && actorUnderCursor != this.currentActor) {
                this.currentActor = actorUnderCursor;
                if (this.currentActor != null) {
                    if (this.showDesc) {
                        this.pointer.setDesc(this.currentActor.getDesc());
                    }
                    Verb leaveVerb = this.currentActor.getVerb("leave");
                    TextureAtlas.AtlasRegion r = null;
                    if (leaveVerb != null) {
                        if (leaveVerb.getIcon() != null && (r = this.getUI().getSkin().getAtlas().findRegion(leaveVerb.getIcon())) != null) {
                            this.pointer.setIcon((TextureRegion)r);
                        } else {
                            this.pointer.setLeaveIcon(this.calcLeaveArrowRotation(this.currentActor));
                        }
                    } else {
                        Verb actionVerb = this.currentActor.getVerb("action");
                        if (actionVerb != null && actionVerb.getIcon() != null && (r = this.getUI().getSkin().getAtlas().findRegion(actionVerb.getIcon())) != null) {
                            this.pointer.setIcon((TextureRegion)r);
                        } else {
                            this.pointer.setHotspotIcon();
                        }
                    }
                } else {
                    this.pointer.setDefaultIcon();
                }
            } else if (this.pie.isVisible()) {
                this.currentActor = actorUnderCursor;
            }
        }
    }

    private float calcLeaveArrowRotation(InteractiveActor actor) {
        Verb verb = actor.getVerb("leave");
        if (verb == null || verb.getIcon() == null) {
            actor.getBBox().getBoundingRectangle().getCenter(this.unproject2Tmp);
            if (this.unproject2Tmp.x < this.stage.getViewport().getWorldWidth() / 3.0f) {
                return 180.0f;
            }
            if (this.unproject2Tmp.x > this.stage.getViewport().getWorldWidth() / 3.0f * 2.0f) {
                return 0.0f;
            }
            if (this.unproject2Tmp.y < this.stage.getViewport().getWorldHeight() / 5.0f) {
                return -90.0f;
            }
            return 90.0f;
        }
        String dir = verb.getIcon();
        if (dir.equals("left")) {
            return 180.0f;
        }
        if (dir.equals("right")) {
            return 0.0f;
        }
        if (dir.equals("down")) {
            return -90.0f;
        }
        return 90.0f;
    }

    public void render(float delta) {
        World world = this.ui.getWorld();
        this.update(delta);
        if (world.getAssetState() != World.AssetState.LOADED) {
            return;
        }
        SpriteBatch batch = this.ui.getBatch();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        world.draw();
        if (EngineLogger.debugMode() && EngineLogger.getDebugLevel() == 1) {
            this.renderer.setProjectionMatrix(world.getSceneCamera().combined);
            world.getCurrentScene().drawBBoxLines(this.renderer);
            this.renderer.end();
        }
        this.stage.draw();
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        if (!(world.inCutMode() || this.recorder.isPlaying() || this.testerBot.isEnabled())) {
            this.pointer.draw(batch, this.viewport);
        }
        Transition t = world.getTransition();
        t.draw(batch, this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.recorder.draw(batch);
        this.testerBot.draw(batch);
        if (this.drawHotspots) {
            this.drawHotspots(batch);
        }
        if (EngineLogger.debugMode()) {
            this.drawDebugText(batch);
        }
        batch.end();
    }

    private void drawDebugText(SpriteBatch batch) {
        Color color;
        World w = this.ui.getWorld();
        w.getSceneCamera().getInputUnProject(this.viewport, this.unprojectTmp);
        this.sbTmp.setLength(0);
        if (EngineLogger.lastError != null) {
            this.sbTmp.append(EngineLogger.lastError);
            color = Color.RED;
        } else {
            this.sbTmp.append(" ");
            long millis = w.getTimeOfGame();
            long second = millis / 1000L % 60L;
            long minute = millis / 60000L % 60L;
            long hour = millis / 3600000L;
            String time = String.format("%02d:%02d:%02d", hour, minute, second);
            this.sbTmp.append(time);
            color = Color.WHITE;
        }
        String strDebug = this.sbTmp.toString();
        this.textLayout.setText(this.ui.getSkin().getFont("debug"), (CharSequence)strDebug, color, (float)this.viewport.getScreenWidth(), 8, true);
        RectangleRenderer.draw((Batch)batch, 0.0f, (float)this.viewport.getScreenHeight() - this.textLayout.height - 10.0f, this.textLayout.width, this.textLayout.height + 10.0f, Color.BLACK);
        this.ui.getSkin().getFont("debug").draw((Batch)batch, this.textLayout, 0.0f, (float)(this.viewport.getScreenHeight() - 5));
        if (EngineLogger.getDebugLevel() == 1) {
            for (BaseActor a : w.getCurrentScene().getActors().values()) {
                if (a instanceof AnchorActor) continue;
                Rectangle r = a.getBBox().getBoundingRectangle();
                this.sbTmp.setLength(0);
                this.sbTmp.append(a.getId());
                if (a instanceof InteractiveActor && ((InteractiveActor)a).getState() != null) {
                    this.sbTmp.append(".").append(((InteractiveActor)a).getState());
                }
                this.unprojectTmp.set(r.getX(), r.getY(), 0.0f);
                w.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
                this.ui.getSkin().getFont("debug").draw((Batch)batch, (CharSequence)this.sbTmp.toString(), this.unprojectTmp.x, this.unprojectTmp.y);
            }
        }
    }

    private void drawHotspots(SpriteBatch batch) {
        World world = this.ui.getWorld();
        for (BaseActor a : world.getCurrentScene().getActors().values()) {
            InteractiveActor ia;
            if (!(a instanceof InteractiveActor) || !a.isVisible() || a == world.getCurrentScene().getPlayer() || !(ia = (InteractiveActor)a).canInteract()) continue;
            Polygon p = a.getBBox();
            if (p == null) {
                EngineLogger.error("ERROR DRAWING HOTSPOT FOR: " + a.getId());
            }
            Rectangle r = a.getBBox().getBoundingRectangle();
            this.unprojectTmp.set(r.getX() + r.getWidth() / 2.0f, r.getY() + r.getHeight() / 2.0f, 0.0f);
            world.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
            if (!this.showDesc || ia.getDesc() == null) {
                Drawable drawable;
                float size = DPIUtils.ICON_SIZE * DPIUtils.getSizeMultiplier();
                if (ia.getVerb("leave") != null) {
                    drawable = (TransformDrawable)this.getUI().getSkin().getDrawable("leave");
                    drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size / 2.0f, size / 2.0f, size, size, 1.0f, 1.0f, this.calcLeaveArrowRotation(ia));
                    continue;
                }
                drawable = this.getUI().getSkin().getDrawable("hotspot");
                if (drawable == null) continue;
                drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size, size);
                continue;
            }
            BitmapFont font = this.getUI().getSkin().getFont("desc");
            String desc = ia.getDesc();
            if (desc.charAt(0) == '@') {
                desc = I18N.getString(desc.substring(1));
            }
            this.textLayout.setText(font, (CharSequence)desc);
            float textX = this.unprojectTmp.x - this.textLayout.width / 2.0f;
            float textY = this.unprojectTmp.y + this.textLayout.height;
            RectangleRenderer.draw((Batch)batch, textX - 8.0f, textY - this.textLayout.height - 8.0f, this.textLayout.width + 16.0f, this.textLayout.height + 16.0f, Color.BLACK);
            font.draw((Batch)batch, this.textLayout, textX, textY);
        }
    }

    public void resize(int width, int height) {
        World world = this.ui.getWorld();
        if (!world.isDisposed()) {
            this.viewport.setWorldSize((float)world.getWidth(), (float)world.getHeight());
            this.viewport.update(width, height, true);
            world.resize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
        } else {
            this.viewport.setWorldSize((float)width, (float)height);
            this.viewport.update(width, height, true);
        }
        this.resetUI();
        this.pie.resize(this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.inventoryUI.resize(this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.inventoryButton.resize(width, height);
        this.pointer.resize(width, height);
        float size = DPIUtils.getPrefButtonSize();
        float margin = DPIUtils.getMarginSize();
        this.menuButton.setSize(size, size);
        this.menuButton.setPosition((float)this.stage.getViewport().getScreenWidth() - this.menuButton.getWidth() - margin, (float)this.stage.getViewport().getScreenHeight() - this.menuButton.getHeight() - margin);
    }

    public void dispose() {
        this.renderer.dispose();
        this.stage.dispose();
    }

    private void retrieveAssets(TextureAtlas atlas) {
        this.renderer = new ShapeRenderer();
        this.inventoryUI.retrieveAssets(atlas);
    }

    private void sceneClick(int button, int count) {
        World w = this.ui.getWorld();
        w.getSceneCamera().getInputUnProject(this.viewport, this.unprojectTmp);
        Scene s = w.getCurrentScene();
        CharacterActor player = s.getPlayer();
        if (this.currentActor != null) {
            if (EngineLogger.debugMode()) {
                EngineLogger.debug(this.currentActor.toString());
            }
            if (count > 1) {
                if (count == 2 && this.fastLeave && !this.recorder.isRecording() && player != null && this.currentActor.getVerb("leave") != null) {
                    player.fastWalk();
                }
                return;
            }
            this.actorClick(this.currentActor, button);
        } else if (player != null) {
            if (count > 1) {
                return;
            }
            if (s.getPlayer().getVerb("goto") != null) {
                this.runVerb(s.getPlayer(), "goto", null);
            } else {
                Vector2 pos = new Vector2(this.unprojectTmp.x, this.unprojectTmp.y);
                if (this.recorder.isRecording()) {
                    this.recorder.add(pos);
                }
                player.goTo(pos, null, false);
            }
        }
    }

    @Override
    public void actorClick(InteractiveActor a, int button) {
        boolean lookatButton;
        boolean bl = lookatButton = button == 1;
        if (a.getVerb("leave") != null) {
            this.runVerb(a, "leave", null);
        } else if (a.getVerb("action") != null) {
            this.runVerb(a, "action", null);
        } else if (this.uiMode == UIModes.SINGLE_CLICK) {
            String verb = "talkto";
            if (a.getVerb(verb) == null) {
                verb = "pickup";
            }
            if (a.getVerb(verb) == null) {
                verb = "lookat";
            }
            this.runVerb(a, verb, null);
        } else if (this.uiMode == UIModes.TWO_BUTTONS) {
            String verb = "lookat";
            if (!lookatButton) {
                verb = a.getVerb("talkto") != null ? "talkto" : "pickup";
            }
            this.runVerb(a, verb, null);
        } else if (this.uiMode == UIModes.PIE) {
            this.getInputUnProject(this.unprojectTmp);
            this.pie.show(a, this.unprojectTmp.x, this.unprojectTmp.y);
            this.pointer.reset();
        }
    }

    private void getInputUnProject(Vector3 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY(), 0.0f);
        this.viewport.unproject(out);
    }

    @Override
    public void runVerb(InteractiveActor a, String verb, String target) {
        if (this.recorder.isRecording()) {
            this.recorder.add(a.getId(), verb, target);
        }
        a.runVerb(verb, target);
    }

    private void showMenu() {
        this.pause();
        this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
    }

    private void resetUI() {
        if (this.pie.isVisible()) {
            this.pie.hide();
        }
        this.pointer.reset();
        this.inventoryUI.cancelDragging();
        this.currentActor = null;
    }

    public InventoryUI getInventoryUI() {
        return this.inventoryUI;
    }

    public Actor getTextManagerUI() {
        return this.textManagerUI;
    }

    public Actor getDialogUI() {
        return this.dialogUI;
    }

    public void setTextManagerUI(Actor a) {
        if (a instanceof ITextManagerUI) {
            this.textManagerUI.remove();
            this.textManagerUI = a;
            this.stage.addActor(this.textManagerUI);
        } else {
            EngineLogger.error("ERROR setTextManagerUI: actor is not a ITextManagerUI");
            this.dispose();
            Gdx.app.exit();
        }
    }

    public void setDialogUI(Actor a) {
        this.dialogUI.remove();
        this.dialogUI = a;
        this.stage.addActor(this.dialogUI);
    }

    public Stage getStage() {
        return this.stage;
    }

    public Button getMenuButton() {
        return this.menuButton;
    }

    public void show() {
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor((InputProcessor)this.stage);
        multiplexer.addProcessor((InputProcessor)this.inputProcessor);
        Gdx.input.setInputProcessor((InputProcessor)multiplexer);
        if (this.ui.getWorld().isDisposed()) {
            try {
                this.ui.getWorld().load();
            }
            catch (Exception e) {
                EngineLogger.error("ERROR LOADING GAME", e);
                this.dispose();
                Gdx.app.exit();
            }
        }
        this.ui.getWorld().setListener(this.worldListener);
        this.ui.getWorld().resume();
        this.updateUI();
    }

    public void hide() {
        this.ui.getWorld().pause();
        this.resetUI();
    }

    public void pause() {
        this.ui.getWorld().pause();
    }

    public void resume() {
        this.ui.getWorld().resume();
        if (EngineLogger.lastError != null && EngineLogger.debugMode()) {
            EngineLogger.lastError = null;
            EngineLogger.lastException = null;
        }
    }

    @Override
    public Viewport getViewport() {
        return this.viewport;
    }

    @Override
    public InteractiveActor getCurrentActor() {
        return this.currentActor;
    }

    @Override
    public void setUI(final UI ui) {
        this.ui = ui;
        this.recorder = ui.getRecorder();
        this.testerBot = ui.getTesterBot();
        this.pie = new PieMenu(this);
        this.textManagerUI = new TextManagerUI(ui);
        this.menuButton = new Button(ui.getSkin(), "menu");
        this.dialogUI = new DialogUI(ui);
        this.pointer = new ScenePointer(ui.getSkin());
        this.inventoryUI = new InventoryUI(this, this.pointer);
        this.inventoryButton = new InventoryButton(ui, this.inventoryUI);
        this.uiMode = UIModes.valueOf(Config.getProperty("ui_mode", "TWO_BUTTONS").toUpperCase(Locale.ENGLISH));
        if (Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) && this.uiMode == UIModes.TWO_BUTTONS) {
            this.uiMode = UIModes.PIE;
        }
        this.pie.setVisible(false);
        this.menuButton.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
        });
        this.retrieveAssets(ui.getUIAtlas());
        this.stage = new Stage(this.viewport);
        this.stage.addActor(this.textManagerUI);
        this.stage.addActor(this.dialogUI);
        this.stage.addActor((Actor)this.inventoryButton);
        this.stage.addActor((Actor)this.menuButton);
        this.stage.addActor((Actor)this.inventoryUI);
        this.stage.addActor((Actor)this.pie);
    }

    public static enum UIModes {
        TWO_BUTTONS,
        PIE,
        SINGLE_CLICK;

    }
}

