/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.RectangleRenderer;

public class ScenePointer {
    private static final String LEAVE_ICON = "leave";
    private static final String POINTER_ICON = "pointer";
    private static final String HOTSPOT_ICON = "hotspotpointer";
    private static final Color DRAG_NOT_HOTSPOT_COLOR = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private Color tmpTint = new Color();
    private BitmapFont font;
    private String desc = null;
    private TextureRegion leaveIcon;
    private TextureRegion pointerIcon;
    private TextureRegion hotspotIcon;
    private TextureRegion currentIcon;
    private SpriteActor draggingActor;
    private final Vector2 mousepos = new Vector2();
    private float pointerScale;
    private float leaveRotation = 0.0f;
    private final GlyphLayout layout = new GlyphLayout();

    public ScenePointer(Skin skin) {
        this.font = skin.getFont("desc");
        this.pointerIcon = skin.getAtlas().findRegion(POINTER_ICON);
        this.leaveIcon = skin.getAtlas().findRegion(LEAVE_ICON);
        this.hotspotIcon = skin.getAtlas().findRegion(HOTSPOT_ICON);
        this.reset();
    }

    public void reset() {
        this.setDefaultIcon();
        this.draggingActor = null;
    }

    public void drag(SpriteActor a) {
        this.draggingActor = a;
        this.tmpTint.set(DRAG_NOT_HOTSPOT_COLOR);
        if (a != null && this.draggingActor.getTint() != null) {
            this.tmpTint.mul(this.draggingActor.getTint());
        }
    }

    public void setDefaultIcon() {
        this.currentIcon = this.pointerIcon;
        this.desc = null;
    }

    public void setLeaveIcon(float rot) {
        this.currentIcon = this.leaveIcon;
        this.leaveRotation = rot;
    }

    public void setHotspotIcon() {
        this.currentIcon = this.hotspotIcon;
    }

    public void setIcon(TextureRegion r) {
        this.currentIcon = r;
    }

    public void setDesc(String s) {
        this.desc = s;
        if (this.desc != null) {
            if (this.desc.charAt(0) == '@') {
                this.desc = I18N.getString(this.desc.substring(1));
            }
            this.layout.setText(this.font, (CharSequence)this.desc);
        }
    }

    private void getInputUnproject(Viewport v, Vector2 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
        v.unproject(out);
    }

    public void draw(SpriteBatch batch, Viewport v) {
        this.getInputUnproject(v, this.mousepos);
        boolean multiTouch = Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen);
        if (this.desc != null && (!multiTouch || Gdx.input.isTouched())) {
            float margin = DPIUtils.UI_SPACE;
            float textX = this.mousepos.x - this.layout.width / 2.0f;
            float textY = this.mousepos.y + this.layout.height + DPIUtils.UI_SPACE + DPIUtils.getTouchMinSize();
            if (textX < 0.0f) {
                textX = 0.0f;
            }
            RectangleRenderer.draw((Batch)batch, textX - margin, textY - this.layout.height - margin, this.layout.width + margin * 2.0f, this.layout.height + margin * 2.0f, Color.BLACK);
            this.font.draw((Batch)batch, this.layout, textX, textY);
        }
        if (this.draggingActor == null) {
            if (!multiTouch || this.currentIcon == this.leaveIcon) {
                batch.draw(this.currentIcon, this.mousepos.x - (float)(this.currentIcon.getRegionWidth() / 2), this.mousepos.y - (float)(this.currentIcon.getRegionHeight() / 2), (float)(this.currentIcon.getRegionWidth() / 2), (float)(this.currentIcon.getRegionHeight() / 2), (float)this.currentIcon.getRegionWidth(), (float)this.currentIcon.getRegionHeight(), this.pointerScale, this.pointerScale, this.currentIcon == this.leaveIcon ? this.leaveRotation : 0.0f);
            }
        } else {
            float h = this.draggingActor.getHeight() > this.draggingActor.getWidth() ? this.draggingActor.getHeight() : this.draggingActor.getWidth();
            float size = DPIUtils.getTouchMinSize() / h * 1.8f;
            ActorRenderer r = this.draggingActor.getRenderer();
            r.draw(batch, this.mousepos.x, this.mousepos.y - this.draggingActor.getHeight() * size / 2.0f, size, size, 0.0f, this.currentIcon != this.hotspotIcon ? this.tmpTint : this.draggingActor.getTint());
        }
    }

    public void resize(int width, int height) {
        this.pointerScale = DPIUtils.getTouchMinSize() / (float)this.pointerIcon.getRegionHeight() * 0.8f;
    }
}

