/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.retro;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.Transition;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.model.WorldListener;
import com.bladecoder.engine.ui.DialogUI;
import com.bladecoder.engine.ui.Pointer;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.SceneFitViewport;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.TesterBot;
import com.bladecoder.engine.ui.TextManagerUI;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.retro.VerbUI;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.io.IOException;

public class RetroSceneScreen
implements SceneScreen {
    private static final float UI_SCREEN_PERCENT = 0.27999997f;
    private UI ui;
    private Stage stage;
    private Stage worldViewportStage;
    private VerbUI verbUI;
    private DialogUI dialogUI;
    private TextManagerUI textManagerUI;
    private ShapeRenderer renderer;
    private Button menuButton;
    private Recorder recorder;
    private TesterBot testerBot;
    private final Viewport screenViewport;
    private final Viewport worldViewport;
    private final Vector3 unprojectTmp = new Vector3();
    private final StringBuilder sbTmp = new StringBuilder();
    private InteractiveActor currentActor = null;
    private boolean drawHotspots = false;
    private float speed = 1.0f;
    private final GlyphLayout textLayout = new GlyphLayout();
    private Pointer pointer;
    private boolean uiEnabled = true;
    private final GestureDetector inputProcessor = new GestureDetector((GestureDetector.GestureListener)new GestureDetector.GestureAdapter(){

        public boolean touchDown(float x, float y, int pointer, int button) {
            return true;
        }

        public boolean tap(float x, float y, int count, int button) {
            EngineLogger.debug("Event TAP button: " + button);
            World w = RetroSceneScreen.this.ui.getWorld();
            if (w.isPaused() || RetroSceneScreen.this.recorder.isPlaying() || RetroSceneScreen.this.testerBot.isEnabled()) {
                return true;
            }
            if (RetroSceneScreen.this.drawHotspots) {
                RetroSceneScreen.this.drawHotspots = false;
            } else if (w.inCutMode() && !RetroSceneScreen.this.recorder.isRecording()) {
                w.getCurrentScene().getTextManager().next();
            } else if (!w.hasDialogOptions()) {
                RetroSceneScreen.this.sceneClick(button);
            }
            return true;
        }

        public boolean longPress(float x, float y) {
            EngineLogger.debug("Event LONG PRESS");
            if (RetroSceneScreen.this.uiEnabled && !RetroSceneScreen.this.ui.getWorld().hasDialogOptions()) {
                RetroSceneScreen.this.drawHotspots = true;
            }
            return false;
        }

        public boolean pan(float x, float y, float deltaX, float deltaY) {
            return true;
        }

        public boolean panStop(float x, float y, int pointer, int button) {
            return true;
        }
    }){

        public boolean keyUp(int keycode) {
            switch (keycode) {
                case 4: 
                case 82: 
                case 131: {
                    RetroSceneScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
                    break;
                }
                case 62: {
                    if (!RetroSceneScreen.this.drawHotspots) break;
                    RetroSceneScreen.this.drawHotspots = false;
                }
            }
            return true;
        }

        public boolean keyTyped(char character) {
            switch (character) {
                case 'd': {
                    EngineLogger.toggle();
                    break;
                }
                case '1': {
                    EngineLogger.setDebugLevel(0);
                    break;
                }
                case '2': {
                    EngineLogger.setDebugLevel(1);
                    break;
                }
                case '3': {
                    EngineLogger.setDebugLevel(2);
                    break;
                }
                case 'f': {
                    break;
                }
                case 's': {
                    try {
                        RetroSceneScreen.this.ui.getWorld().saveGameState();
                    }
                    catch (IOException e) {
                        EngineLogger.error(e.getMessage());
                    }
                    break;
                }
                case 'l': {
                    try {
                        RetroSceneScreen.this.ui.getWorld().loadGameState();
                    }
                    catch (IOException e) {
                        EngineLogger.error(e.getMessage());
                    }
                    break;
                }
                case 't': {
                    RetroSceneScreen.this.testerBot.setEnabled(!RetroSceneScreen.this.testerBot.isEnabled());
                    break;
                }
                case '.': {
                    if (RetroSceneScreen.this.recorder.isRecording()) {
                        RetroSceneScreen.this.recorder.setRecording(false);
                        break;
                    }
                    RetroSceneScreen.this.recorder.setRecording(true);
                    break;
                }
                case ',': {
                    if (RetroSceneScreen.this.recorder.isPlaying()) {
                        RetroSceneScreen.this.recorder.setPlaying(false);
                        break;
                    }
                    RetroSceneScreen.this.recorder.load();
                    RetroSceneScreen.this.recorder.setPlaying(true);
                    break;
                }
                case 'p': {
                    if (RetroSceneScreen.this.ui.getWorld().isPaused()) {
                        RetroSceneScreen.this.ui.getWorld().resume();
                        break;
                    }
                    RetroSceneScreen.this.ui.getWorld().pause();
                    break;
                }
                case ' ': {
                    if (!RetroSceneScreen.this.uiEnabled || RetroSceneScreen.this.ui.getWorld().hasDialogOptions()) break;
                    RetroSceneScreen.this.drawHotspots = true;
                }
            }
            return false;
        }
    };
    private final WorldListener worldListener = new WorldListener(){

        @Override
        public void text(Text t) {
            RetroSceneScreen.this.textManagerUI.setText(t);
        }

        @Override
        public void dialogOptions() {
            RetroSceneScreen.this.updateUI();
        }

        @Override
        public void cutMode(boolean value) {
            RetroSceneScreen.this.updateUI();
        }

        @Override
        public void inventoryEnabled(boolean value) {
            if (value) {
                RetroSceneScreen.this.verbUI.show();
            } else {
                RetroSceneScreen.this.verbUI.hide();
            }
        }

        @Override
        public void pause(boolean value) {
            RetroSceneScreen.this.updateUI();
        }
    };

    public RetroSceneScreen() {
        this.screenViewport = new SceneFitViewport();
        this.worldViewport = new Viewport(){

            public void apply(boolean centerCamera) {
                HdpiUtils.glViewport((int)this.getScreenX(), (int)this.getScreenY(), (int)this.getScreenWidth(), (int)this.getScreenHeight());
                this.getCamera().viewportWidth = this.getScreenWidth();
                this.getCamera().viewportHeight = this.getScreenHeight();
                if (centerCamera) {
                    this.getCamera().position.set((float)(this.getScreenWidth() / 2), (float)(this.getScreenHeight() / 2), 0.0f);
                }
                this.getCamera().update();
            }
        };
        this.worldViewport.setCamera(this.screenViewport.getCamera());
    }

    @Override
    public UI getUI() {
        return this.ui;
    }

    private void updateUI() {
        World w = this.ui.getWorld();
        if (w.isPaused() || w.inCutMode() || this.testerBot.isEnabled() || this.recorder.isPlaying()) {
            this.dialogUI.setVisible(false);
            this.verbUI.hide();
            this.pointer.hide();
            this.uiEnabled = false;
        } else {
            if (this.ui.getWorld().hasDialogOptions()) {
                this.dialogUI.setVisible(true);
                this.verbUI.hide();
            } else {
                this.dialogUI.setVisible(false);
                if (w.getInventory().isVisible()) {
                    this.verbUI.show();
                } else {
                    this.verbUI.hide();
                }
            }
            this.pointer.show();
            this.uiEnabled = true;
        }
    }

    @Override
    public void setSpeed(float s) {
        this.speed = s;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    private void update(float delta) {
        World.AssetState assetState;
        World world = this.ui.getWorld();
        this.currentActor = null;
        if (!world.isDisposed()) {
            world.update(delta * this.speed);
        }
        if ((assetState = world.getAssetState()) != World.AssetState.LOADED) {
            this.ui.setCurrentScreen(UI.Screens.LOADING_SCREEN);
            return;
        }
        this.stage.act(delta);
        this.worldViewportStage.act(delta);
        if (world.isPaused()) {
            return;
        }
        this.recorder.update(delta * this.speed);
        this.testerBot.update(delta * this.speed);
        if (this.uiEnabled && !world.hasDialogOptions()) {
            float tolerance = Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) ? DPIUtils.getTouchMinSize() : 0.0f;
            this.currentActor = world.getInteractiveActorAtInput(this.worldViewport, tolerance);
            this.verbUI.setCurrentActor(this.currentActor);
        }
    }

    public void render(float delta) {
        World world = this.ui.getWorld();
        this.update(delta);
        if (world.getAssetState() != World.AssetState.LOADED) {
            return;
        }
        SpriteBatch batch = this.ui.getBatch();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (world.getInventory().isVisible()) {
            this.worldViewport.setScreenY(this.screenViewport.getScreenY() + (int)this.verbUI.getHeight());
            this.worldViewport.setScreenHeight(this.screenViewport.getScreenHeight() - (int)this.verbUI.getHeight());
            world.resize(world.getWidth(), (float)world.getHeight() * 0.72f);
        } else {
            this.worldViewport.setScreenY(this.screenViewport.getScreenY());
            this.worldViewport.setScreenHeight(this.screenViewport.getScreenHeight());
            world.resize(world.getWidth(), world.getHeight());
        }
        this.worldViewport.apply(true);
        world.draw();
        if (EngineLogger.debugMode() && EngineLogger.getDebugLevel() == 1) {
            this.renderer.setProjectionMatrix(world.getSceneCamera().combined);
            world.getCurrentScene().drawBBoxLines(this.renderer);
            this.renderer.end();
        }
        batch.setProjectionMatrix(this.worldViewport.getCamera().combined);
        batch.begin();
        if (EngineLogger.debugMode()) {
            this.drawDebugText(batch);
        }
        Transition t = world.getTransition();
        t.draw(batch, this.worldViewport.getScreenWidth(), this.worldViewport.getScreenHeight());
        this.recorder.draw(batch);
        this.testerBot.draw(batch);
        if (this.drawHotspots) {
            this.drawHotspots(batch);
        }
        batch.end();
        this.worldViewportStage.draw();
        this.screenViewport.apply(true);
        this.stage.draw();
    }

    private void drawDebugText(SpriteBatch batch) {
        Color color;
        World w = this.ui.getWorld();
        w.getSceneCamera().getInputUnProject(this.worldViewport, this.unprojectTmp);
        this.sbTmp.setLength(0);
        if (EngineLogger.lastError != null) {
            this.sbTmp.append(EngineLogger.lastError);
            color = Color.RED;
        } else {
            this.sbTmp.append("( ");
            this.sbTmp.append((int)this.unprojectTmp.x);
            this.sbTmp.append(", ");
            this.sbTmp.append((int)this.unprojectTmp.y);
            this.sbTmp.append(") FPS:");
            this.sbTmp.append(Gdx.graphics.getFramesPerSecond());
            if (w.getCurrentScene().getPlayer() != null) {
                this.sbTmp.append(" Depth Scl: ");
                this.sbTmp.append(w.getCurrentScene().getFakeDepthScale(this.unprojectTmp.y));
            }
            color = Color.WHITE;
        }
        String strDebug = this.sbTmp.toString();
        this.textLayout.setText(this.ui.getSkin().getFont("debug"), (CharSequence)strDebug, color, (float)this.worldViewport.getScreenWidth(), 8, true);
        RectangleRenderer.draw((Batch)batch, 0.0f, (float)this.worldViewport.getScreenHeight() - this.textLayout.height - 10.0f, this.textLayout.width, this.textLayout.height + 10.0f, Color.BLACK);
        this.ui.getSkin().getFont("debug").draw((Batch)batch, this.textLayout, 0.0f, (float)(this.worldViewport.getScreenHeight() - 5));
        if (EngineLogger.getDebugLevel() == 1) {
            for (BaseActor a : w.getCurrentScene().getActors().values()) {
                Rectangle r = a.getBBox().getBoundingRectangle();
                this.sbTmp.setLength(0);
                this.sbTmp.append(a.getId());
                if (a instanceof InteractiveActor && ((InteractiveActor)a).getState() != null) {
                    this.sbTmp.append(".").append(((InteractiveActor)a).getState());
                }
                this.unprojectTmp.set(r.getX(), r.getY(), 0.0f);
                w.getSceneCamera().scene2screen(this.worldViewport, this.unprojectTmp);
                if (w.getInventory().isVisible()) {
                    // empty if block
                }
                this.ui.getSkin().getFont("debug").draw((Batch)batch, (CharSequence)this.sbTmp.toString(), this.unprojectTmp.x, this.unprojectTmp.y);
            }
        }
    }

    private void drawHotspots(SpriteBatch batch) {
        World world = this.ui.getWorld();
        for (BaseActor a : world.getCurrentScene().getActors().values()) {
            InteractiveActor ia;
            if (!(a instanceof InteractiveActor) || !a.isVisible() || a == world.getCurrentScene().getPlayer() || !(ia = (InteractiveActor)a).canInteract()) continue;
            Polygon p = a.getBBox();
            if (p == null) {
                EngineLogger.error("ERROR DRAWING HOTSPOT FOR: " + a.getId());
            }
            Rectangle r = a.getBBox().getBoundingRectangle();
            this.unprojectTmp.set(r.getX() + r.getWidth() / 2.0f, r.getY() + r.getHeight() / 2.0f, 0.0f);
            world.getSceneCamera().scene2screen(this.worldViewport, this.unprojectTmp);
            if (world.getInventory().isVisible()) {
                // empty if block
            }
            if (ia.getDesc() == null) {
                float size = DPIUtils.ICON_SIZE * DPIUtils.getSizeMultiplier();
                Drawable drawable = ((TextureRegionDrawable)this.getUI().getSkin().getDrawable("circle")).tint(Color.RED);
                drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size, size);
                continue;
            }
            BitmapFont font = this.getUI().getSkin().getFont("desc");
            String desc = ia.getDesc();
            if (desc.charAt(0) == '@') {
                desc = I18N.getString(desc.substring(1));
            }
            this.textLayout.setText(font, (CharSequence)desc);
            float textX = this.unprojectTmp.x - this.textLayout.width / 2.0f;
            float textY = this.unprojectTmp.y + this.textLayout.height;
            RectangleRenderer.draw((Batch)batch, textX - 8.0f, textY - this.textLayout.height - 8.0f, this.textLayout.width + 16.0f, this.textLayout.height + 16.0f, Color.BLACK);
            font.draw((Batch)batch, this.textLayout, textX, textY);
        }
    }

    public void resize(int width, int height) {
        World world = this.ui.getWorld();
        if (!world.isDisposed()) {
            this.screenViewport.setWorldSize((float)world.getWidth(), (float)world.getHeight());
            this.screenViewport.update(width, height, true);
            this.worldViewport.setScreenBounds(this.screenViewport.getScreenX(), this.screenViewport.getScreenY(), this.screenViewport.getScreenWidth(), this.screenViewport.getScreenHeight());
            world.resize(this.screenViewport.getWorldWidth(), this.screenViewport.getWorldHeight());
        }
        this.pointer.resize();
        this.verbUI.setSize(this.screenViewport.getScreenWidth(), (float)this.screenViewport.getScreenHeight() * 0.27999997f);
        float size = DPIUtils.getPrefButtonSize();
        float margin = DPIUtils.getMarginSize();
        this.menuButton.setSize(size, size);
        this.menuButton.setPosition((float)this.stage.getViewport().getScreenWidth() - this.menuButton.getWidth() - margin, (float)this.stage.getViewport().getScreenHeight() - this.menuButton.getHeight() - margin);
    }

    public void dispose() {
        this.renderer.dispose();
        this.stage.dispose();
        this.worldViewportStage.dispose();
    }

    private void retrieveAssets(TextureAtlas atlas) {
        this.renderer = new ShapeRenderer();
    }

    private void sceneClick(int button) {
        World w = this.ui.getWorld();
        w.getSceneCamera().getInputUnProject(this.worldViewport, this.unprojectTmp);
        Scene s = w.getCurrentScene();
        if (this.currentActor != null) {
            if (EngineLogger.debugMode()) {
                EngineLogger.debug(this.currentActor.toString());
            }
            this.actorClick(this.currentActor, button);
        } else if (s.getPlayer() != null) {
            if (s.getPlayer().getVerb("goto") != null) {
                this.runVerb(s.getPlayer(), "goto", null);
            } else {
                Vector2 pos = new Vector2(this.unprojectTmp.x, this.unprojectTmp.y);
                if (this.recorder.isRecording()) {
                    this.recorder.add(pos);
                }
                s.getPlayer().goTo(pos, null, false);
            }
        }
    }

    @Override
    public void actorClick(InteractiveActor a, int button) {
        this.runVerb(a, this.verbUI.getCurrentVerb(), this.verbUI.getTarget());
    }

    @Override
    public void runVerb(InteractiveActor a, String verb, String target) {
        if (this.recorder.isRecording()) {
            this.recorder.add(a.getId(), verb, target);
        }
        a.runVerb(verb, target);
    }

    public void show() {
        this.retrieveAssets(this.ui.getUIAtlas());
        this.stage = new Stage(this.screenViewport);
        this.stage.addActor((Actor)this.dialogUI);
        this.stage.addActor((Actor)this.menuButton);
        this.stage.addActor((Actor)this.verbUI);
        this.stage.addActor((Actor)this.pointer);
        this.menuButton.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                RetroSceneScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
        });
        this.worldViewportStage = new Stage(this.worldViewport);
        this.worldViewportStage.addActor((Actor)this.textManagerUI);
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor((InputProcessor)this.stage);
        multiplexer.addProcessor((InputProcessor)this.inputProcessor);
        Gdx.input.setInputProcessor((InputProcessor)multiplexer);
        if (this.ui.getWorld().isDisposed()) {
            try {
                this.ui.getWorld().load();
            }
            catch (Exception e) {
                EngineLogger.error("ERROR LOADING GAME", e);
                this.dispose();
                Gdx.app.exit();
            }
        }
        this.ui.getWorld().setListener(this.worldListener);
        this.ui.getWorld().resume();
        this.textManagerUI.setText(this.ui.getWorld().getCurrentScene().getTextManager().getCurrentText());
        this.updateUI();
    }

    public void hide() {
        this.ui.getWorld().pause();
        this.currentActor = null;
        this.dispose();
    }

    public void pause() {
        this.ui.getWorld().pause();
    }

    public void resume() {
        this.ui.getWorld().resume();
    }

    @Override
    public Viewport getViewport() {
        return this.screenViewport;
    }

    @Override
    public InteractiveActor getCurrentActor() {
        return this.currentActor;
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
        this.recorder = ui.getRecorder();
        this.testerBot = ui.getTesterBot();
        this.textManagerUI = new TextManagerUI(ui);
        this.menuButton = new Button(ui.getSkin(), "menu");
        this.dialogUI = new DialogUI(ui);
        this.verbUI = new VerbUI(this);
        this.pointer = new Pointer(ui.getSkin());
    }
}

