/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.retro;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.retro.RendererDrawable;
import com.bladecoder.engine.util.DPIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VerbUI
extends Table {
    private static final float MARGIN = 1.0f;
    private static final List<String> VERBS = Arrays.asList("give", "pickup", "use", "open", "talkto", "push", "close", "lookat", "pull");
    private static final List<String> VERBS_DESC = Arrays.asList("Give", "Pick up", "Use", "Open", "Talk to", "Push", "Close", "Lookat", "Pull");
    private static final int VERB_COLS = 3;
    private static final int INVENTORY_COLS = 3;
    private static final int INVENTORY_ROWS = 3;
    private final List<ImageButton> inventorySlots = new ArrayList<ImageButton>();
    private final SceneScreen sceneScreen;
    private final String DEFAULT_VERB = "lookat";
    private final Label infoLine;
    private String currentVerb = "lookat";
    private InteractiveActor target;
    private VerbUIStyle style;
    private int scroll = 0;
    private Table arrowPanel;
    private Table invPanel;

    public VerbUI(SceneScreen scn) {
        super(scn.getUI().getSkin());
        this.style = (VerbUIStyle)scn.getUI().getSkin().get(VerbUIStyle.class);
        if (this.style.background != null) {
            this.setBackground(this.style.background);
        }
        this.sceneScreen = scn;
        this.infoLine = new Label((CharSequence)VERBS_DESC.get(VERBS.indexOf("lookat")), this.style.infoLineLabelStyle);
        this.infoLine.setAlignment(1);
        this.add((Actor)this.infoLine).colspan(3).fillX().expandX();
        this.row();
        Table verbs = this.createVerbPanel();
        this.add((Actor)verbs).fill().expand();
        this.arrowPanel = this.createArrowPanel();
        this.add((Actor)this.arrowPanel).fillY().expandY();
        this.invPanel = this.createInventoryPanel();
        this.add((Actor)this.invPanel).fill().expand();
    }

    private Table createArrowPanel() {
        Table arrows = new Table();
        arrows.defaults().pad(1.0f);
        ImageButton.ImageButtonStyle s = new ImageButton.ImageButtonStyle(this.style.inventoryButtonStyle);
        s.imageUp = this.style.upArrow;
        ImageButton up = new ImageButton(s);
        arrows.add((Actor)up).fillY().expandY();
        up.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                if (VerbUI.this.scroll > 0) {
                    VerbUI.this.scroll--;
                }
            }
        });
        arrows.row();
        ImageButton.ImageButtonStyle s2 = new ImageButton.ImageButtonStyle(this.style.inventoryButtonStyle);
        s2.imageUp = this.style.downArrow;
        ImageButton down = new ImageButton(s2);
        arrows.add((Actor)down).fillY().expandY();
        down.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                Inventory inv = VerbUI.this.sceneScreen.getUI().getWorld().getInventory();
                int itemsLeft = inv.getNumItems() - VerbUI.this.scroll * 3;
                if (itemsLeft > VerbUI.this.inventorySlots.size()) {
                    VerbUI.this.scroll++;
                }
            }
        });
        return arrows;
    }

    private Table createVerbPanel() {
        Table verbs = new Table();
        verbs.defaults().pad(1.0f);
        for (int i = 0; i < VERBS.size(); ++i) {
            if (i % 3 == 0) {
                verbs.row();
            }
            TextButton b = new TextButton(VERBS_DESC.get(i), this.style.verbButtonStyle);
            b.setName(VERBS.get(i));
            b.addListener((EventListener)new ClickListener(){

                public void clicked(InputEvent event, float x, float y) {
                    VerbUI.this.currentVerb = event.getListenerActor().getName();
                    VerbUI.this.infoLine.setText(((TextButton)event.getListenerActor()).getText());
                    VerbUI.this.target = null;
                }
            });
            verbs.add((Actor)b).fill().expand();
        }
        return verbs;
    }

    public void sizeChanged() {
        super.sizeChanged();
        for (Actor a : this.arrowPanel.getChildren()) {
            ImageButton b = (ImageButton)a;
            float h = this.getHeight() / 2.0f - this.style.infoLineLabelStyle.font.getLineHeight() / 2.0f - DPIUtils.getSpacing();
            float ih = b.getImage().getDrawable().getMinHeight();
            float iw = b.getImage().getDrawable().getMinWidth() * h / ih;
            b.getImageCell().maxSize(iw, h);
        }
        this.arrowPanel.invalidateHierarchy();
    }

    public void act(float delta) {
        super.act(delta);
        Inventory inv = this.sceneScreen.getUI().getWorld().getInventory();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            RendererDrawable r = (RendererDrawable)this.inventorySlots.get(i).getImage().getDrawable();
            int pos = this.scroll * 3 + i;
            if (pos < inv.getNumItems()) {
                r.setRenderer(inv.get(pos).getRenderer());
            } else {
                r.setRenderer(null);
            }
            this.inventorySlots.get(i).getImage().invalidate();
        }
    }

    private Table createInventoryPanel() {
        Table inventory = new Table();
        inventory.defaults().pad(1.0f);
        for (int i = 0; i < 9; ++i) {
            if (i % 3 == 0) {
                inventory.row();
            }
            ImageButton.ImageButtonStyle s = new ImageButton.ImageButtonStyle(this.style.inventoryButtonStyle);
            RendererDrawable r = new RendererDrawable();
            s.imageUp = r;
            ImageButton b = new ImageButton(s);
            inventory.add((Actor)b).fill().expand();
            b.setUserObject((Object)i);
            this.inventorySlots.add(b);
            b.addListener((EventListener)new ClickListener(){

                public void clicked(InputEvent event, float x, float y) {
                    int i = (Integer)event.getListenerActor().getUserObject();
                    Inventory inv = VerbUI.this.sceneScreen.getUI().getWorld().getInventory();
                    VerbUI.this.target = null;
                    if (i < inv.getNumItems()) {
                        SpriteActor actor = inv.get(i);
                        if (VerbUI.this.currentVerb.equals("use") || VerbUI.this.currentVerb.equals("give")) {
                            VerbUI.this.target = actor;
                        } else {
                            VerbUI.this.sceneScreen.runVerb(actor, VerbUI.this.currentVerb, null);
                        }
                    }
                }
            });
            b.getImageCell().pad(1.0f).expand().fill();
        }
        return inventory;
    }

    public String getCurrentVerb() {
        return this.currentVerb;
    }

    public String getTarget() {
        return this.target == null ? null : this.target.getId();
    }

    public void setCurrentActor(InteractiveActor actor) {
        String verbDesc = VERBS_DESC.get(VERBS.indexOf(this.currentVerb));
        String desc = this.getTranslatedDesc(actor);
        if (this.target != null) {
            String prep = this.currentVerb.equals("give") ? " to " : " with ";
            if (desc != null) {
                this.infoLine.setText((CharSequence)(verbDesc + " " + this.getTranslatedDesc(this.target) + prep + desc));
            } else {
                this.infoLine.setText((CharSequence)(verbDesc + " " + this.getTranslatedDesc(this.target) + prep));
            }
        } else if (desc != null) {
            this.infoLine.setText((CharSequence)(verbDesc + " " + desc));
        } else {
            this.infoLine.setText((CharSequence)verbDesc);
        }
    }

    private String getTranslatedDesc(InteractiveActor actor) {
        String desc = null;
        if (actor != null && actor.getDesc() != null && (desc = actor.getDesc()).charAt(0) == '@') {
            desc = I18N.getString(desc.substring(1));
        }
        return desc;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.target = null;
        this.currentVerb = "lookat";
        this.setCurrentActor(null);
        this.setVisible(false);
    }

    public static class VerbUIStyle {
        public Drawable background;
        public TextButton.TextButtonStyle verbButtonStyle;
        public Button.ButtonStyle inventoryButtonStyle;
        public Label.LabelStyle infoLineLabelStyle;
        public Drawable upArrow;
        public Drawable downArrow;

        public VerbUIStyle() {
        }

        public VerbUIStyle(VerbUIStyle style) {
            this.background = style.background;
            this.verbButtonStyle = style.verbButtonStyle;
            this.inventoryButtonStyle = style.inventoryButtonStyle;
            this.infoLineLabelStyle = style.infoLineLabelStyle;
            this.upArrow = style.upArrow;
            this.downArrow = style.downArrow;
        }
    }
}

